/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.local.bigswitch;

import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;
import org.opencord.ce.api.models.CarrierEthernetNetworkInterface;
import org.opencord.ce.api.services.virtualprovider.LinkId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

import static org.opencord.ce.api.services.channel.Symbols.MEF_PORT_TYPE;
import static org.opencord.ce.api.models.CarrierEthernetNetworkInterface.Type;

/**
 * See config-samples/ecord-local-config.json.
 */
public class MefPortsConfig extends Config<ApplicationId> {
    private final Logger log = LoggerFactory.getLogger(getClass());
    public static final String MEF_PORTS = "mefPorts";
    public static final String CONNECT_POINT = "connectPoint";
    public static final String INTERLINK_ID = "interlinkId";

    public List<MefPortConfig> mefPortConfigs() {
        List<MefPortConfig> mefPortConfigs = new ArrayList<>();
        array.forEach(item -> mefPortConfigs.add(new MefPortConfig(
                ConnectPoint.deviceConnectPoint(item.path(CONNECT_POINT).asText()),
                CarrierEthernetNetworkInterface.Type.valueOf(item.path(MEF_PORT_TYPE).asText()),
                LinkId.linkId(item.path(INTERLINK_ID).isMissingNode() ? "internal" :
                        item.path(INTERLINK_ID).asText())
        )));
        return mefPortConfigs;
    }

    public static class MefPortConfig {
        private ConnectPoint cp;
        private CarrierEthernetNetworkInterface.Type mefType;
        private LinkId interlinkId;

        public MefPortConfig(ConnectPoint cp, Type mefType,
                              LinkId interlinkId) {
            this.cp = cp;
            this.mefType = mefType;
            this.interlinkId = interlinkId;
        }

        public ConnectPoint cp() {
            return cp;
        }

        public Type mefType() {
            return mefType;
        }

        public LinkId interlinkId() {
            return interlinkId;
        }
    }
}
