/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.local.bigswitch;


import org.onosproject.event.ListenerService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.domain.DomainId;

import java.util.List;
import java.util.Optional;

/**
 * Service to interact with big switch abstraction.
 */
public interface BigSwitchService extends ListenerService<BigSwitchEvent, BigSwitchListener> {
    /**
     * Gets list of big switch ports.
     *
     * @return list of port descriptions
     */
    List<PortDescription> getPorts();

    /**
     * Gets the big switch port mapped to the physical port.
     *
     * @param port the physical port
     * @return virtual port number
     */
    PortNumber getPort(ConnectPoint port);


    /**
     * Gets the local connect point mapped to the specified virtual port number.
     * @param portNumber virtual port number
     * @return optional local-site connect point
     */
    Optional<ConnectPoint> connectPointFromVirtPort(PortNumber portNumber);

    /**
     * Returns the local site/domain ID of this biw switch.
     *
     * @return domain/site ID
     */
    DomainId siteId();
}

