/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.channel.server;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onlab.packet.IpAddress;
import org.onosproject.rest.AbstractWebResource;
import org.opencord.ce.api.services.channel.ConnectionService;
import org.slf4j.Logger;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import static org.opencord.ce.api.services.channel.Symbols.MASTER_API_NO_IP_BODY;
import static org.opencord.ce.api.services.channel.Symbols.MASTER_IP;
import static org.opencord.ce.api.services.channel.Symbols.OK;
import static org.opencord.ce.api.services.channel.Symbols.RESULT;
import static org.slf4j.LoggerFactory.getLogger;

/**
 * Gets the ip of the instance leader of the communication with the specified
 * domainId.
 */
@Path("master/{domainId}")
public class DomainMasterIpResource extends AbstractWebResource {
    private final Logger log = getLogger(getClass());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public Response getMasterIp(@PathParam("domainId") String id) {
        log.info("Domain {} asks who is the master for him", id);

        IpAddress ip = get(ConnectionService.class).getLocalMasterIp(id);
        if (ip != null) {
            ObjectNode body = mapper().createObjectNode();
            body.put(RESULT, OK);
            body.put(MASTER_IP, ip.toString());

            return ok(body.toString()).build();
        } else {
            return ok(MASTER_API_NO_IP_BODY).build();
        }
    }
}
