/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.api.services.channel;

import org.onlab.packet.IpAddress;
import org.onosproject.net.domain.DomainId;

import java.util.Set;

/**
 * ONOS cluster endpoint for the communication between local and global.
 */
public class EndPoint {
    private DomainId domainId;
    private Set<IpAddress> ipAddresses;
    private int port;
    private String username;
    private String password;
    private String topic;

    public EndPoint(DomainId domainId, Set<IpAddress> ipAddresses, int port,
                    String username, String password, String topic) {
        this.domainId = domainId;
        this.ipAddresses = ipAddresses;
        this.port = port;
        this.username = username;
        this.password = password;
        this.topic = topic;
    }

    public DomainId domainId() {
        return domainId;
    }

    public Set<IpAddress> ipAddresses() {
        return ipAddresses;
    }

    public int port() {
        return port;
    }

    public String username() {
        return username;
    }

    public String password() {
        return password;
    }

    public String topic() {
        return topic;
    }
}
