/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.local.channel.client;

import com.google.common.collect.Sets;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;
import org.onosproject.net.domain.DomainId;
import org.opencord.ce.api.models.DomainEndPoint;

import java.util.Set;

/**
 * Configuration class for this bundle.
 * Currently this configuration is simply the connection endpoint of the global ONOS.
 *
 * Look at config-samples/ecord-local-config.json for a sample configuration
 */
public class ConnectionConfig extends Config<ApplicationId> {

    private static final String PORT = "port";
    private static final String PUBLIC_IP = "publicIp";
    private static final String USERNAME = "username";
    private static final String PASSWD = "password";
    private static final String TOPIC = "topic";

    public DomainEndPoint global() {
        Set<IpAddress> ipAddresses = Sets.newHashSet();
        IpAddress publicIp = IpAddress.valueOf(object.path(PUBLIC_IP).asText());
        int port = object.path(PORT).asInt();

        String username = object.path(USERNAME).asText();
        String password = object.path(PASSWD).asText();

        String topic = object.path(TOPIC).asText();

        return new DomainEndPoint(DomainId.domainId("global"), publicIp, port,
                username, password, topic);
    }
}
