/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.virtualdomain.config;

import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;

/**
 * ICONA driver configuration class.
 */
public class EcordDriverConfig extends Config<ApplicationId> {

    private static final String MANUFACTURER = "manufacturer";
    private static final String SW_VERSION = "swVersion";
    private static final String HW_VERSION = "hwVersion";


    public String manufacturer() {
        return object.get(MANUFACTURER).asText();
    }

    public String swVersion() {
        return object.get(SW_VERSION).asText();
    }

    public String hwVersion() {
        return  object.get(HW_VERSION).asText();
    }

}
