/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.virtualdomain.config;

import com.fasterxml.jackson.databind.JsonNode;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.config.Config;

/**
 * Global XoS endpoint.
 */
public class XosEndPointConfig extends Config<ApplicationId> {
    private static final String USERNAME = "username";
    private static final String PASSWD = "password";
    private static final String XOS = "xos";
    private static final String ADDRESS = "address";
    private static final String RESOURCE = "resource";

    public XosEndPoint xos() {
        JsonNode xosNode = object.path(XOS);
        IpAddress ipAddress = IpAddress.valueOf(xosNode.get(ADDRESS).asText());
        String username = xosNode.get(USERNAME).asText();
        String password = xosNode.get(PASSWD).asText();
        String resource = xosNode.get(RESOURCE).asText();
        return new XosEndPoint(ipAddress, username, password, resource);
    }

    public static class XosEndPoint {
        private IpAddress ipAddress;
        private String username;
        private String password;
        private String resource;

        public XosEndPoint(IpAddress ipAddress, String username,
                           String password, String resource) {
            this.ipAddress = ipAddress;
            this.username = username;
            this.password = password;
            this.resource = resource;
        }

        public IpAddress ipAddress() {
            return ipAddress;
        }

        public String username() {
            return username;
        }

        public String password() {
            return password;
        }

        public String resource() {
            return resource;
        }
    }

}
