/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.local.bigswitch.cli;

import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.opencord.ce.local.bigswitch.BigSwitchService;

/**
 * Command to list the ports of the bigswitch.
 */
@Command(scope = "onos", name = "bigswitch-ports",
        description = "Lists the bigswitch ports")
public class BigSwitchPortsCommand extends AbstractShellCommand {

    @Override
    public void execute() {
        BigSwitchService bigSwitchService = get(BigSwitchService.class);

        bigSwitchService.getPorts().forEach(
                portDescription -> print(portDescription.toString())
        );
    }
}
