/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.api.models.codecs;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.codec.CodecService;
import org.opencord.ce.api.models.CarrierEthernetBandwidthProfile;
import org.opencord.ce.api.models.CarrierEthernetForwardingConstruct;
import org.opencord.ce.api.models.CarrierEthernetLogicalTerminationPoint;
import org.opencord.ce.api.models.CarrierEthernetNetworkInterface;
import org.opencord.ce.api.models.CarrierEthernetVirtualConnection;
import org.slf4j.Logger;
import static org.slf4j.LoggerFactory.getLogger;

@Component(immediate = true)
public class CodecRegistrator {
    private final Logger log = getLogger(getClass());

    @Reference(cardinality = ReferenceCardinality.MANDATORY_UNARY)
    protected CodecService codecService;

    @Activate
    public void activate() {
        codecService.registerCodec(CarrierEthernetVirtualConnection.class,
                new CarrierEthernetEvcCodec());
        codecService.registerCodec(CarrierEthernetBandwidthProfile.class, new CarrierEthernetBwProfileCodec());
        codecService.registerCodec(CarrierEthernetNetworkInterface.class,
                new CarrierEthernetNetworkInterfaceCodec());
        codecService.registerCodec(CarrierEthernetLogicalTerminationPoint.class,
                new LogicalTerminationEndPointCodec());
        codecService.registerCodec(CarrierEthernetForwardingConstruct.class,
                new ForwardingConstructCodec());
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        codecService.unregisterCodec(CarrierEthernetVirtualConnection.class);
        codecService.unregisterCodec(CarrierEthernetBandwidthProfile.class);
        codecService.unregisterCodec(CarrierEthernetNetworkInterface.class);
        codecService.unregisterCodec(CarrierEthernetForwardingConstruct.class);
        codecService.unregisterCodec(CarrierEthernetLogicalTerminationPoint.class);
        log.info("Stopped");
    }
}