/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.api.services.channel;


/**
 * HTTP resource paths.
 */
public final class Symbols {

    private Symbols() {
    }

    public static final String POST = "post";
    public static final String GET = "get";
    public static final String DELETE = "delete";
    public static final String HTTP = "http";
    public static final String DOUBLESLASH = "//";
    public static final String L_BRACKET = "{";
    public static final String R_BRACKET = "}";
    public static final String QUOTES = "\"";
    public static final String COLON = ":";
    public static final String OK = "ok";
    public static final String MASTER_IP = "masterIp";
    public static final String RESULT = "result";
    public static final String NO_ENDPOINT_AVAILABLE = "unavailable";

    public static final String MASTER_API_NO_IP_BODY = L_BRACKET
            + QUOTES + RESULT + QUOTES + COLON + QUOTES + NO_ENDPOINT_AVAILABLE + QUOTES
            + R_BRACKET;

    public static final String BASE_URL = "/ecord";

    public static final String MASTER = "/master";

    public static final String FC = "fc";
    public static final String SRC_NI = "srcNi";
    public static final String DST_NI_LIST = "dstNiList";
    public static final String UNI = "uni";

    public static final String FC_ID = "fcId";
    // ======== Forwarding Construct data ====== //
    public static final String FC_TAG = "fcTag";
    public static final String FC_INGRESS_CP = "fcIngressCp";
    public static final String FC_TYPE = "fcType";
    public static final String INGRESS_NI_TYPE = "ingressNiType";
    public static final String INGRESS_FC_TAG = "ingressFcTag";
    public static final String CUSTOMER_TAG = "customerTag";
    public static final String FC_EGRESS_LST = "fcEgressList";
    public static final String FC_EGRESS_CP = "fcEgressCp";
    public static final String FC_EGRESS_TYPE = "fcEgressType";

    // ======== Bandwidth profile data ====== //
    public static final String BW_PROFILE = "bwProfile";
    public static final String CIR = "cir";
    public static final String EIR = "eir";
    public static final String CBS = "cbs";
    public static final String EBS = "ebs";
    public static final String UNI_CP = "uniCp";


    // ===== Device and Port annotations ==== //
    public static final String DEVICE_ID = "deviceId";
    public static final String MEF_PORT_TYPE = "mefPortType";


}

