/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opencord.ce.global.orchestration.channel;

import com.google.common.collect.ImmutableSet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.opencord.ce.api.services.channel.ControlChannelListenerService;
import org.opencord.ce.api.services.MetroNetworkVirtualNodeService;
import org.slf4j.Logger;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

import static org.slf4j.LoggerFactory.getLogger;


/**
 * Implementation o the {@link ControlChannelListenerService}.
 */
@Component(immediate = true)
@Service
public class ControlChannelManager implements ControlChannelListenerService {

    private final Logger log = getLogger(getClass());
    private Set<MetroNetworkVirtualNodeService> sbListeners = new CopyOnWriteArraySet<>();

    @Activate
    public void activate() {
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        log.info("Stopped");
    }

    @Override
    public void addListener(MetroNetworkVirtualNodeService listener) {
        log.debug("listener added");
        sbListeners.add(listener);
    }

    @Override
    public void removeListener(MetroNetworkVirtualNodeService listener) {
        sbListeners.remove(listener);
    }

    @Override
    public Set<MetroNetworkVirtualNodeService> listeners() {
        return ImmutableSet.copyOf(sbListeners);
    }

}
