// Code generated by protoc-gen-go. DO NOT EDIT.
// source: dmi/hw_events_mgmt_service.proto

package dmi

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EventIds int32

const (
	EventIds_EVENT_NAME_UNDEFINED EventIds = 0
	// Events from the Transceivers
	EventIds_EVENT_TRANSCEIVER_PLUG_OUT EventIds = 100
	EventIds_EVENT_TRANSCEIVER_PLUG_IN  EventIds = 101
	// The threshold based events on the transceivers should be configured on
	// the port components of that transceiver and not on the transceiver
	// component itself. This is because there could be different thresholds
	// on the different ports of a transceiver (for example for a transceiver of
	// type COMBO_GPON_XGSPON the power thresholds could be different for the
	// GPON and XGSPON ports)
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD               EventIds = 102
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD               EventIds = 103
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD           EventIds = 104
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD           EventIds = 105
	EventIds_EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD               EventIds = 106
	EventIds_EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD               EventIds = 107
	EventIds_EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD              EventIds = 108
	EventIds_EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD              EventIds = 109
	EventIds_EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD              EventIds = 110
	EventIds_EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD              EventIds = 111
	EventIds_EVENT_TRANSCEIVER_FAILURE                               EventIds = 112
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED     EventIds = 113
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED     EventIds = 114
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED EventIds = 115
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED EventIds = 116
	EventIds_EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED     EventIds = 117
	EventIds_EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED     EventIds = 118
	EventIds_EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED    EventIds = 119
	EventIds_EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED    EventIds = 120
	EventIds_EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED    EventIds = 121
	EventIds_EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED    EventIds = 122
	EventIds_EVENT_TRANSCEIVER_FAILURE_RECOVERED                     EventIds = 123
	// Events from the PSU
	EventIds_EVENT_PSU_PLUG_OUT          EventIds = 200
	EventIds_EVENT_PSU_PLUG_IN           EventIds = 201
	EventIds_EVENT_PSU_FAILURE           EventIds = 202
	EventIds_EVENT_PSU_FAILURE_RECOVERED EventIds = 203
	// Events for the Fans
	EventIds_EVENT_FAN_FAILURE           EventIds = 300
	EventIds_EVENT_FAN_PLUG_OUT          EventIds = 301
	EventIds_EVENT_FAN_PLUG_IN           EventIds = 302
	EventIds_EVENT_FAN_FAILURE_RECOVERED EventIds = 303
	// Events for the CPUs
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL           EventIds = 400
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_FATAL              EventIds = 401
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED EventIds = 402
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED    EventIds = 403
	EventIds_EVENT_CPU_USAGE_ABOVE_THRESHOLD                EventIds = 404
	EventIds_EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED      EventIds = 405
	// Events for the complete HW Device
	EventIds_EVENT_HW_DEVICE_RESET                                EventIds = 500
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL           EventIds = 501
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL              EventIds = 502
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED EventIds = 503
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED    EventIds = 504
	EventIds_EVENT_HW_DEVICE_REBOOT                               EventIds = 505
	EventIds_EVENT_HW_TEMPERATURE_SENSOR_FAILED                   EventIds = 506
	EventIds_EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED              EventIds = 507
	EventIds_EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD                  EventIds = 508
	EventIds_EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED        EventIds = 509
	EventIds_EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD                EventIds = 510
	EventIds_EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED      EventIds = 511
	EventIds_EVENT_HW_NTP_SYNC_FAILURE                            EventIds = 512
	EventIds_EVENT_HW_NTP_SYNC_FAILURE_RECOVERED                  EventIds = 513
	// Events for the line cards on the HW Device
	EventIds_EVENT_LINE_CARD_PLUG_OUT EventIds = 600
	EventIds_EVENT_LINE_CARD_PLUG_IN  EventIds = 601
)

var EventIds_name = map[int32]string{
	0:   "EVENT_NAME_UNDEFINED",
	100: "EVENT_TRANSCEIVER_PLUG_OUT",
	101: "EVENT_TRANSCEIVER_PLUG_IN",
	102: "EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD",
	103: "EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD",
	104: "EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD",
	105: "EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD",
	106: "EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD",
	107: "EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD",
	108: "EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD",
	109: "EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD",
	110: "EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD",
	111: "EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD",
	112: "EVENT_TRANSCEIVER_FAILURE",
	113: "EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED",
	114: "EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED",
	115: "EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED",
	116: "EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED",
	117: "EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED",
	118: "EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED",
	119: "EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED",
	120: "EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED",
	121: "EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED",
	122: "EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED",
	123: "EVENT_TRANSCEIVER_FAILURE_RECOVERED",
	200: "EVENT_PSU_PLUG_OUT",
	201: "EVENT_PSU_PLUG_IN",
	202: "EVENT_PSU_FAILURE",
	203: "EVENT_PSU_FAILURE_RECOVERED",
	300: "EVENT_FAN_FAILURE",
	301: "EVENT_FAN_PLUG_OUT",
	302: "EVENT_FAN_PLUG_IN",
	303: "EVENT_FAN_FAILURE_RECOVERED",
	400: "EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL",
	401: "EVENT_CPU_TEMPERATURE_ABOVE_FATAL",
	402: "EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED",
	403: "EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED",
	404: "EVENT_CPU_USAGE_ABOVE_THRESHOLD",
	405: "EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED",
	500: "EVENT_HW_DEVICE_RESET",
	501: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL",
	502: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL",
	503: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED",
	504: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED",
	505: "EVENT_HW_DEVICE_REBOOT",
	506: "EVENT_HW_TEMPERATURE_SENSOR_FAILED",
	507: "EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED",
	508: "EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD",
	509: "EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED",
	510: "EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD",
	511: "EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED",
	512: "EVENT_HW_NTP_SYNC_FAILURE",
	513: "EVENT_HW_NTP_SYNC_FAILURE_RECOVERED",
	600: "EVENT_LINE_CARD_PLUG_OUT",
	601: "EVENT_LINE_CARD_PLUG_IN",
}

var EventIds_value = map[string]int32{
	"EVENT_NAME_UNDEFINED":                                    0,
	"EVENT_TRANSCEIVER_PLUG_OUT":                              100,
	"EVENT_TRANSCEIVER_PLUG_IN":                               101,
	"EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD":               102,
	"EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD":               103,
	"EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD":           104,
	"EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD":           105,
	"EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD":               106,
	"EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD":               107,
	"EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD":              108,
	"EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD":              109,
	"EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD":              110,
	"EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD":              111,
	"EVENT_TRANSCEIVER_FAILURE":                               112,
	"EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED":     113,
	"EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED":     114,
	"EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED": 115,
	"EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED": 116,
	"EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED":     117,
	"EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED":     118,
	"EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED":    119,
	"EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED":    120,
	"EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED":    121,
	"EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED":    122,
	"EVENT_TRANSCEIVER_FAILURE_RECOVERED":                     123,
	"EVENT_PSU_PLUG_OUT":                                      200,
	"EVENT_PSU_PLUG_IN":                                       201,
	"EVENT_PSU_FAILURE":                                       202,
	"EVENT_PSU_FAILURE_RECOVERED":                             203,
	"EVENT_FAN_FAILURE":                                       300,
	"EVENT_FAN_PLUG_OUT":                                      301,
	"EVENT_FAN_PLUG_IN":                                       302,
	"EVENT_FAN_FAILURE_RECOVERED":                             303,
	"EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL":                    400,
	"EVENT_CPU_TEMPERATURE_ABOVE_FATAL":                       401,
	"EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED":          402,
	"EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED":             403,
	"EVENT_CPU_USAGE_ABOVE_THRESHOLD":                         404,
	"EVENT_CPU_USAGE_ABOVE_THRESHOLD_RECOVERED":               405,
	"EVENT_HW_DEVICE_RESET":                                   500,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL":              501,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL":                 502,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED":    503,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED":       504,
	"EVENT_HW_DEVICE_REBOOT":                                  505,
	"EVENT_HW_TEMPERATURE_SENSOR_FAILED":                      506,
	"EVENT_HW_ALL_TEMPERATURE_SENSORS_FAILED":                 507,
	"EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD":                     508,
	"EVENT_HW_DISK_USAGE_ABOVE_THRESHOLD_RECOVERED":           509,
	"EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD":                   510,
	"EVENT_HW_MEMORY_USAGE_ABOVE_THRESHOLD_RECOVERED":         511,
	"EVENT_HW_NTP_SYNC_FAILURE":                               512,
	"EVENT_HW_NTP_SYNC_FAILURE_RECOVERED":                     513,
	"EVENT_LINE_CARD_PLUG_OUT":                                600,
	"EVENT_LINE_CARD_PLUG_IN":                                 601,
}

func (x EventIds) String() string {
	return proto.EnumName(EventIds_name, int32(x))
}

func (EventIds) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{0}
}

type ListEventsResponse_Reason int32

const (
	ListEventsResponse_UNDEFINED_REASON   ListEventsResponse_Reason = 0
	ListEventsResponse_UNKNOWN_DEVICE     ListEventsResponse_Reason = 1
	ListEventsResponse_INTERNAL_ERROR     ListEventsResponse_Reason = 2
	ListEventsResponse_DEVICE_UNREACHABLE ListEventsResponse_Reason = 3
)

var ListEventsResponse_Reason_name = map[int32]string{
	0: "UNDEFINED_REASON",
	1: "UNKNOWN_DEVICE",
	2: "INTERNAL_ERROR",
	3: "DEVICE_UNREACHABLE",
}

var ListEventsResponse_Reason_value = map[string]int32{
	"UNDEFINED_REASON":   0,
	"UNKNOWN_DEVICE":     1,
	"INTERNAL_ERROR":     2,
	"DEVICE_UNREACHABLE": 3,
}

func (x ListEventsResponse_Reason) String() string {
	return proto.EnumName(ListEventsResponse_Reason_name, int32(x))
}

func (ListEventsResponse_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{6, 0}
}

type EventsConfigurationResponse_Reason int32

const (
	EventsConfigurationResponse_UNDEFINED_REASON   EventsConfigurationResponse_Reason = 0
	EventsConfigurationResponse_UNKNOWN_DEVICE     EventsConfigurationResponse_Reason = 1
	EventsConfigurationResponse_INTERNAL_ERROR     EventsConfigurationResponse_Reason = 2
	EventsConfigurationResponse_INVALID_CONFIG     EventsConfigurationResponse_Reason = 3
	EventsConfigurationResponse_DEVICE_UNREACHABLE EventsConfigurationResponse_Reason = 4
)

var EventsConfigurationResponse_Reason_name = map[int32]string{
	0: "UNDEFINED_REASON",
	1: "UNKNOWN_DEVICE",
	2: "INTERNAL_ERROR",
	3: "INVALID_CONFIG",
	4: "DEVICE_UNREACHABLE",
}

var EventsConfigurationResponse_Reason_value = map[string]int32{
	"UNDEFINED_REASON":   0,
	"UNKNOWN_DEVICE":     1,
	"INTERNAL_ERROR":     2,
	"INVALID_CONFIG":     3,
	"DEVICE_UNREACHABLE": 4,
}

func (x EventsConfigurationResponse_Reason) String() string {
	return proto.EnumName(EventsConfigurationResponse_Reason_name, int32(x))
}

func (EventsConfigurationResponse_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{8, 0}
}

type ValueType struct {
	// For val no multiples of units shall be used.
	// For example, for memory val should be in bytes and not in kilobytes or any
	// other multiple of the unit byte.
	//
	// Types that are valid to be assigned to Val:
	//	*ValueType_IntVal
	//	*ValueType_UintVal
	//	*ValueType_FloatVal
	Val                  isValueType_Val `protobuf_oneof:"val"`
	TypeOfVal            DataValueType   `protobuf:"varint,4,opt,name=typeOfVal,proto3,enum=dmi.DataValueType" json:"typeOfVal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ValueType) Reset()         { *m = ValueType{} }
func (m *ValueType) String() string { return proto.CompactTextString(m) }
func (*ValueType) ProtoMessage()    {}
func (*ValueType) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{0}
}

func (m *ValueType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueType.Unmarshal(m, b)
}
func (m *ValueType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueType.Marshal(b, m, deterministic)
}
func (m *ValueType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueType.Merge(m, src)
}
func (m *ValueType) XXX_Size() int {
	return xxx_messageInfo_ValueType.Size(m)
}
func (m *ValueType) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueType.DiscardUnknown(m)
}

var xxx_messageInfo_ValueType proto.InternalMessageInfo

type isValueType_Val interface {
	isValueType_Val()
}

type ValueType_IntVal struct {
	IntVal int64 `protobuf:"varint,1,opt,name=int_val,json=intVal,proto3,oneof"`
}

type ValueType_UintVal struct {
	UintVal uint64 `protobuf:"varint,2,opt,name=uint_val,json=uintVal,proto3,oneof"`
}

type ValueType_FloatVal struct {
	FloatVal float32 `protobuf:"fixed32,3,opt,name=float_val,json=floatVal,proto3,oneof"`
}

func (*ValueType_IntVal) isValueType_Val() {}

func (*ValueType_UintVal) isValueType_Val() {}

func (*ValueType_FloatVal) isValueType_Val() {}

func (m *ValueType) GetVal() isValueType_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *ValueType) GetIntVal() int64 {
	if x, ok := m.GetVal().(*ValueType_IntVal); ok {
		return x.IntVal
	}
	return 0
}

func (m *ValueType) GetUintVal() uint64 {
	if x, ok := m.GetVal().(*ValueType_UintVal); ok {
		return x.UintVal
	}
	return 0
}

func (m *ValueType) GetFloatVal() float32 {
	if x, ok := m.GetVal().(*ValueType_FloatVal); ok {
		return x.FloatVal
	}
	return 0
}

func (m *ValueType) GetTypeOfVal() DataValueType {
	if m != nil {
		return m.TypeOfVal
	}
	return DataValueType_VALUE_TYPE_UNDEFINED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueType) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueType_IntVal)(nil),
		(*ValueType_UintVal)(nil),
		(*ValueType_FloatVal)(nil),
	}
}

type WaterMarks struct {
	High                 *ValueType `protobuf:"bytes,1,opt,name=high,proto3" json:"high,omitempty"`
	Low                  *ValueType `protobuf:"bytes,2,opt,name=low,proto3" json:"low,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *WaterMarks) Reset()         { *m = WaterMarks{} }
func (m *WaterMarks) String() string { return proto.CompactTextString(m) }
func (*WaterMarks) ProtoMessage()    {}
func (*WaterMarks) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{1}
}

func (m *WaterMarks) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WaterMarks.Unmarshal(m, b)
}
func (m *WaterMarks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WaterMarks.Marshal(b, m, deterministic)
}
func (m *WaterMarks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WaterMarks.Merge(m, src)
}
func (m *WaterMarks) XXX_Size() int {
	return xxx_messageInfo_WaterMarks.Size(m)
}
func (m *WaterMarks) XXX_DiscardUnknown() {
	xxx_messageInfo_WaterMarks.DiscardUnknown(m)
}

var xxx_messageInfo_WaterMarks proto.InternalMessageInfo

func (m *WaterMarks) GetHigh() *ValueType {
	if m != nil {
		return m.High
	}
	return nil
}

func (m *WaterMarks) GetLow() *ValueType {
	if m != nil {
		return m.Low
	}
	return nil
}

type Thresholds struct {
	// Types that are valid to be assigned to Threshold:
	//	*Thresholds_Upper
	//	*Thresholds_Lower
	Threshold            isThresholds_Threshold `protobuf_oneof:"threshold"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Thresholds) Reset()         { *m = Thresholds{} }
func (m *Thresholds) String() string { return proto.CompactTextString(m) }
func (*Thresholds) ProtoMessage()    {}
func (*Thresholds) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{2}
}

func (m *Thresholds) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Thresholds.Unmarshal(m, b)
}
func (m *Thresholds) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Thresholds.Marshal(b, m, deterministic)
}
func (m *Thresholds) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Thresholds.Merge(m, src)
}
func (m *Thresholds) XXX_Size() int {
	return xxx_messageInfo_Thresholds.Size(m)
}
func (m *Thresholds) XXX_DiscardUnknown() {
	xxx_messageInfo_Thresholds.DiscardUnknown(m)
}

var xxx_messageInfo_Thresholds proto.InternalMessageInfo

type isThresholds_Threshold interface {
	isThresholds_Threshold()
}

type Thresholds_Upper struct {
	Upper *WaterMarks `protobuf:"bytes,1,opt,name=upper,proto3,oneof"`
}

type Thresholds_Lower struct {
	Lower *WaterMarks `protobuf:"bytes,2,opt,name=lower,proto3,oneof"`
}

func (*Thresholds_Upper) isThresholds_Threshold() {}

func (*Thresholds_Lower) isThresholds_Threshold() {}

func (m *Thresholds) GetThreshold() isThresholds_Threshold {
	if m != nil {
		return m.Threshold
	}
	return nil
}

func (m *Thresholds) GetUpper() *WaterMarks {
	if x, ok := m.GetThreshold().(*Thresholds_Upper); ok {
		return x.Upper
	}
	return nil
}

func (m *Thresholds) GetLower() *WaterMarks {
	if x, ok := m.GetThreshold().(*Thresholds_Lower); ok {
		return x.Lower
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Thresholds) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Thresholds_Upper)(nil),
		(*Thresholds_Lower)(nil),
	}
}

type ThresholdInformation struct {
	ObservedValue        *ValueType  `protobuf:"bytes,1,opt,name=observed_value,json=observedValue,proto3" json:"observed_value,omitempty"`
	Thresholds           *Thresholds `protobuf:"bytes,2,opt,name=thresholds,proto3" json:"thresholds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ThresholdInformation) Reset()         { *m = ThresholdInformation{} }
func (m *ThresholdInformation) String() string { return proto.CompactTextString(m) }
func (*ThresholdInformation) ProtoMessage()    {}
func (*ThresholdInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{3}
}

func (m *ThresholdInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThresholdInformation.Unmarshal(m, b)
}
func (m *ThresholdInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThresholdInformation.Marshal(b, m, deterministic)
}
func (m *ThresholdInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThresholdInformation.Merge(m, src)
}
func (m *ThresholdInformation) XXX_Size() int {
	return xxx_messageInfo_ThresholdInformation.Size(m)
}
func (m *ThresholdInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_ThresholdInformation.DiscardUnknown(m)
}

var xxx_messageInfo_ThresholdInformation proto.InternalMessageInfo

func (m *ThresholdInformation) GetObservedValue() *ValueType {
	if m != nil {
		return m.ObservedValue
	}
	return nil
}

func (m *ThresholdInformation) GetThresholds() *Thresholds {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

type EventCfg struct {
	EventId      EventIds `protobuf:"varint,1,opt,name=event_id,json=eventId,proto3,enum=dmi.EventIds" json:"event_id,omitempty"`
	IsConfigured bool     `protobuf:"varint,2,opt,name=is_configured,json=isConfigured,proto3" json:"is_configured,omitempty"`
	// Optional threshold values, applicable only for some specific events
	// If an event needs thresholds but the user does not pass the thresholds here, the Device Manager implementations
	// could choose to use defaults applicable for the specific component (recommended) or return an error for such
	// an EventConfigurationRequest with reason as INVALID_CONFIG
	Thresholds *Thresholds `protobuf:"bytes,3,opt,name=thresholds,proto3" json:"thresholds,omitempty"`
	// For events which can be configured on a particular component this id can be used to identify the component
	// For e.g. for events of the transceivers
	ComponentUuid        *Uuid    `protobuf:"bytes,4,opt,name=component_uuid,json=componentUuid,proto3" json:"component_uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventCfg) Reset()         { *m = EventCfg{} }
func (m *EventCfg) String() string { return proto.CompactTextString(m) }
func (*EventCfg) ProtoMessage()    {}
func (*EventCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{4}
}

func (m *EventCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventCfg.Unmarshal(m, b)
}
func (m *EventCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventCfg.Marshal(b, m, deterministic)
}
func (m *EventCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventCfg.Merge(m, src)
}
func (m *EventCfg) XXX_Size() int {
	return xxx_messageInfo_EventCfg.Size(m)
}
func (m *EventCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EventCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EventCfg proto.InternalMessageInfo

func (m *EventCfg) GetEventId() EventIds {
	if m != nil {
		return m.EventId
	}
	return EventIds_EVENT_NAME_UNDEFINED
}

func (m *EventCfg) GetIsConfigured() bool {
	if m != nil {
		return m.IsConfigured
	}
	return false
}

func (m *EventCfg) GetThresholds() *Thresholds {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

func (m *EventCfg) GetComponentUuid() *Uuid {
	if m != nil {
		return m.ComponentUuid
	}
	return nil
}

type EventsCfg struct {
	Items                []*EventCfg `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EventsCfg) Reset()         { *m = EventsCfg{} }
func (m *EventsCfg) String() string { return proto.CompactTextString(m) }
func (*EventsCfg) ProtoMessage()    {}
func (*EventsCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{5}
}

func (m *EventsCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsCfg.Unmarshal(m, b)
}
func (m *EventsCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsCfg.Marshal(b, m, deterministic)
}
func (m *EventsCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsCfg.Merge(m, src)
}
func (m *EventsCfg) XXX_Size() int {
	return xxx_messageInfo_EventsCfg.Size(m)
}
func (m *EventsCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EventsCfg proto.InternalMessageInfo

func (m *EventsCfg) GetItems() []*EventCfg {
	if m != nil {
		return m.Items
	}
	return nil
}

type ListEventsResponse struct {
	Status               Status                    `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               ListEventsResponse_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.ListEventsResponse_Reason" json:"reason,omitempty"`
	Events               *EventsCfg                `protobuf:"bytes,3,opt,name=events,proto3" json:"events,omitempty"`
	ReasonDetail         string                    `protobuf:"bytes,4,opt,name=reason_detail,json=reasonDetail,proto3" json:"reason_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListEventsResponse) Reset()         { *m = ListEventsResponse{} }
func (m *ListEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEventsResponse) ProtoMessage()    {}
func (*ListEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{6}
}

func (m *ListEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEventsResponse.Unmarshal(m, b)
}
func (m *ListEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEventsResponse.Marshal(b, m, deterministic)
}
func (m *ListEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventsResponse.Merge(m, src)
}
func (m *ListEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEventsResponse.Size(m)
}
func (m *ListEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventsResponse proto.InternalMessageInfo

func (m *ListEventsResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *ListEventsResponse) GetReason() ListEventsResponse_Reason {
	if m != nil {
		return m.Reason
	}
	return ListEventsResponse_UNDEFINED_REASON
}

func (m *ListEventsResponse) GetEvents() *EventsCfg {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *ListEventsResponse) GetReasonDetail() string {
	if m != nil {
		return m.ReasonDetail
	}
	return ""
}

type EventsConfigurationRequest struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// Types that are valid to be assigned to Operation:
	//	*EventsConfigurationRequest_Changes
	//	*EventsConfigurationRequest_ResetToDefault
	Operation            isEventsConfigurationRequest_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EventsConfigurationRequest) Reset()         { *m = EventsConfigurationRequest{} }
func (m *EventsConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*EventsConfigurationRequest) ProtoMessage()    {}
func (*EventsConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{7}
}

func (m *EventsConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsConfigurationRequest.Unmarshal(m, b)
}
func (m *EventsConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *EventsConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsConfigurationRequest.Merge(m, src)
}
func (m *EventsConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_EventsConfigurationRequest.Size(m)
}
func (m *EventsConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EventsConfigurationRequest proto.InternalMessageInfo

func (m *EventsConfigurationRequest) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

type isEventsConfigurationRequest_Operation interface {
	isEventsConfigurationRequest_Operation()
}

type EventsConfigurationRequest_Changes struct {
	Changes *EventsCfg `protobuf:"bytes,2,opt,name=changes,proto3,oneof"`
}

type EventsConfigurationRequest_ResetToDefault struct {
	ResetToDefault bool `protobuf:"varint,3,opt,name=reset_to_default,json=resetToDefault,proto3,oneof"`
}

func (*EventsConfigurationRequest_Changes) isEventsConfigurationRequest_Operation() {}

func (*EventsConfigurationRequest_ResetToDefault) isEventsConfigurationRequest_Operation() {}

func (m *EventsConfigurationRequest) GetOperation() isEventsConfigurationRequest_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *EventsConfigurationRequest) GetChanges() *EventsCfg {
	if x, ok := m.GetOperation().(*EventsConfigurationRequest_Changes); ok {
		return x.Changes
	}
	return nil
}

func (m *EventsConfigurationRequest) GetResetToDefault() bool {
	if x, ok := m.GetOperation().(*EventsConfigurationRequest_ResetToDefault); ok {
		return x.ResetToDefault
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EventsConfigurationRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EventsConfigurationRequest_Changes)(nil),
		(*EventsConfigurationRequest_ResetToDefault)(nil),
	}
}

type EventsConfigurationResponse struct {
	Status               Status                             `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               EventsConfigurationResponse_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.EventsConfigurationResponse_Reason" json:"reason,omitempty"`
	ReasonDetail         string                             `protobuf:"bytes,3,opt,name=reason_detail,json=reasonDetail,proto3" json:"reason_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *EventsConfigurationResponse) Reset()         { *m = EventsConfigurationResponse{} }
func (m *EventsConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*EventsConfigurationResponse) ProtoMessage()    {}
func (*EventsConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{8}
}

func (m *EventsConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsConfigurationResponse.Unmarshal(m, b)
}
func (m *EventsConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsConfigurationResponse.Marshal(b, m, deterministic)
}
func (m *EventsConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsConfigurationResponse.Merge(m, src)
}
func (m *EventsConfigurationResponse) XXX_Size() int {
	return xxx_messageInfo_EventsConfigurationResponse.Size(m)
}
func (m *EventsConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EventsConfigurationResponse proto.InternalMessageInfo

func (m *EventsConfigurationResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *EventsConfigurationResponse) GetReason() EventsConfigurationResponse_Reason {
	if m != nil {
		return m.Reason
	}
	return EventsConfigurationResponse_UNDEFINED_REASON
}

func (m *EventsConfigurationResponse) GetReasonDetail() string {
	if m != nil {
		return m.ReasonDetail
	}
	return ""
}

type EventMetaData struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// uuid of the component
	ComponentUuid        *Uuid    `protobuf:"bytes,2,opt,name=component_uuid,json=componentUuid,proto3" json:"component_uuid,omitempty"`
	ComponentName        string   `protobuf:"bytes,3,opt,name=component_name,json=componentName,proto3" json:"component_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventMetaData) Reset()         { *m = EventMetaData{} }
func (m *EventMetaData) String() string { return proto.CompactTextString(m) }
func (*EventMetaData) ProtoMessage()    {}
func (*EventMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{9}
}

func (m *EventMetaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventMetaData.Unmarshal(m, b)
}
func (m *EventMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventMetaData.Marshal(b, m, deterministic)
}
func (m *EventMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventMetaData.Merge(m, src)
}
func (m *EventMetaData) XXX_Size() int {
	return xxx_messageInfo_EventMetaData.Size(m)
}
func (m *EventMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_EventMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_EventMetaData proto.InternalMessageInfo

func (m *EventMetaData) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

func (m *EventMetaData) GetComponentUuid() *Uuid {
	if m != nil {
		return m.ComponentUuid
	}
	return nil
}

func (m *EventMetaData) GetComponentName() string {
	if m != nil {
		return m.ComponentName
	}
	return ""
}

type Event struct {
	EventMetadata *EventMetaData       `protobuf:"bytes,1,opt,name=event_metadata,json=eventMetadata,proto3" json:"event_metadata,omitempty"`
	EventId       EventIds             `protobuf:"varint,2,opt,name=event_id,json=eventId,proto3,enum=dmi.EventIds" json:"event_id,omitempty"`
	RaisedTs      *timestamp.Timestamp `protobuf:"bytes,3,opt,name=raised_ts,json=raisedTs,proto3" json:"raised_ts,omitempty"`
	// Optional threshold information for an event
	ThresholdInfo *ThresholdInformation `protobuf:"bytes,4,opt,name=threshold_info,json=thresholdInfo,proto3" json:"threshold_info,omitempty"`
	// Any additional info regarding the event
	AddInfo              string   `protobuf:"bytes,5,opt,name=add_info,json=addInfo,proto3" json:"add_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{10}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetEventMetadata() *EventMetaData {
	if m != nil {
		return m.EventMetadata
	}
	return nil
}

func (m *Event) GetEventId() EventIds {
	if m != nil {
		return m.EventId
	}
	return EventIds_EVENT_NAME_UNDEFINED
}

func (m *Event) GetRaisedTs() *timestamp.Timestamp {
	if m != nil {
		return m.RaisedTs
	}
	return nil
}

func (m *Event) GetThresholdInfo() *ThresholdInformation {
	if m != nil {
		return m.ThresholdInfo
	}
	return nil
}

func (m *Event) GetAddInfo() string {
	if m != nil {
		return m.AddInfo
	}
	return ""
}

func init() {
	proto.RegisterEnum("dmi.EventIds", EventIds_name, EventIds_value)
	proto.RegisterEnum("dmi.ListEventsResponse_Reason", ListEventsResponse_Reason_name, ListEventsResponse_Reason_value)
	proto.RegisterEnum("dmi.EventsConfigurationResponse_Reason", EventsConfigurationResponse_Reason_name, EventsConfigurationResponse_Reason_value)
	proto.RegisterType((*ValueType)(nil), "dmi.ValueType")
	proto.RegisterType((*WaterMarks)(nil), "dmi.WaterMarks")
	proto.RegisterType((*Thresholds)(nil), "dmi.Thresholds")
	proto.RegisterType((*ThresholdInformation)(nil), "dmi.ThresholdInformation")
	proto.RegisterType((*EventCfg)(nil), "dmi.EventCfg")
	proto.RegisterType((*EventsCfg)(nil), "dmi.EventsCfg")
	proto.RegisterType((*ListEventsResponse)(nil), "dmi.ListEventsResponse")
	proto.RegisterType((*EventsConfigurationRequest)(nil), "dmi.EventsConfigurationRequest")
	proto.RegisterType((*EventsConfigurationResponse)(nil), "dmi.EventsConfigurationResponse")
	proto.RegisterType((*EventMetaData)(nil), "dmi.EventMetaData")
	proto.RegisterType((*Event)(nil), "dmi.Event")
}

func init() { proto.RegisterFile("dmi/hw_events_mgmt_service.proto", fileDescriptor_8962d785556e9979) }

var fileDescriptor_8962d785556e9979 = []byte{
	// 1682 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x5b, 0x73, 0xe3, 0x48,
	0x15, 0x8e, 0xad, 0x5c, 0x4f, 0x26, 0x46, 0x7b, 0x6a, 0x98, 0x49, 0x1c, 0x66, 0xc6, 0x78, 0x76,
	0x37, 0xd9, 0xc0, 0xd8, 0xd9, 0xcc, 0x30, 0xc3, 0xd4, 0x3e, 0x80, 0x62, 0x2b, 0x63, 0xd5, 0x3a,
	0x72, 0xaa, 0x2d, 0x3b, 0x2c, 0x0f, 0xab, 0xea, 0x89, 0xda, 0x8e, 0x18, 0x4b, 0xf2, 0x4a, 0xed,
	0x84, 0x40, 0x15, 0x05, 0xfc, 0x02, 0x2e, 0xcb, 0x13, 0x14, 0xbf, 0x80, 0x85, 0x3f, 0xc0, 0x0f,
	0xe0, 0xf2, 0x07, 0xe0, 0x95, 0x77, 0xde, 0xb8, 0xdf, 0x4b, 0x2d, 0xd9, 0x56, 0x7c, 0xcd, 0x54,
	0xf1, 0x66, 0x9d, 0xf3, 0x7d, 0xe7, 0x7c, 0xdd, 0xe7, 0xf4, 0x91, 0xda, 0x90, 0xb3, 0x1c, 0xbb,
	0x78, 0x7e, 0x69, 0xb2, 0x0b, 0xe6, 0xf2, 0xc0, 0x74, 0xda, 0x0e, 0x37, 0x03, 0xe6, 0x5f, 0xd8,
	0x67, 0xac, 0xd0, 0xf5, 0x3d, 0xee, 0xa1, 0x64, 0x39, 0x76, 0xf6, 0x8d, 0x10, 0x76, 0xe6, 0x39,
	0x8e, 0xe7, 0x06, 0x91, 0x3d, 0x7b, 0x2b, 0x62, 0xc6, 0x4f, 0x0f, 0xda, 0x9e, 0xd7, 0xee, 0xb0,
	0xa2, 0x78, 0x7a, 0xd9, 0x6b, 0x15, 0xb9, 0xed, 0xb0, 0x80, 0x53, 0xa7, 0x1b, 0x03, 0xb6, 0x47,
	0x01, 0xcc, 0xe9, 0xf2, 0xab, 0xc8, 0x99, 0xff, 0x71, 0x0a, 0xd6, 0x9a, 0xb4, 0xd3, 0x63, 0xc6,
	0x55, 0x97, 0xe1, 0x16, 0xac, 0xd8, 0x2e, 0x37, 0x2f, 0x68, 0x67, 0x33, 0x95, 0x4b, 0xed, 0x4a,
	0x95, 0x05, 0xb2, 0x6c, 0xbb, 0xbc, 0x49, 0x3b, 0xb8, 0x0d, 0xab, 0xbd, 0xbe, 0x2f, 0x9d, 0x4b,
	0xed, 0x2e, 0x56, 0x16, 0xc8, 0x4a, 0x2f, 0x76, 0xde, 0x83, 0xb5, 0x56, 0xc7, 0xa3, 0x91, 0x57,
	0xca, 0xa5, 0x76, 0xd3, 0x95, 0x05, 0xb2, 0x2a, 0x4c, 0xa1, 0x7b, 0x1f, 0xd6, 0xf8, 0x55, 0x97,
	0xd5, 0x5a, 0x4d, 0xda, 0xd9, 0x5c, 0xcc, 0xa5, 0x76, 0x33, 0x07, 0x58, 0xb0, 0x1c, 0xbb, 0x50,
	0xa6, 0x9c, 0x0e, 0xb2, 0x93, 0x21, 0xe8, 0x70, 0x09, 0xa4, 0x0b, 0xda, 0xc9, 0x13, 0x80, 0x53,
	0xca, 0x99, 0x7f, 0x4c, 0xfd, 0x57, 0x01, 0xe6, 0x61, 0xf1, 0xdc, 0x6e, 0x9f, 0x0b, 0x69, 0xeb,
	0x07, 0x19, 0x11, 0x61, 0xc8, 0x16, 0x3e, 0xcc, 0x81, 0xd4, 0xf1, 0x2e, 0x85, 0xc2, 0x71, 0x48,
	0xe8, 0xca, 0xbf, 0x02, 0x30, 0xce, 0x7d, 0x16, 0x9c, 0x7b, 0x1d, 0x2b, 0xc0, 0x1d, 0x58, 0xea,
	0x75, 0xbb, 0xcc, 0x8f, 0x83, 0x7e, 0x4a, 0x30, 0x86, 0x39, 0x2b, 0x0b, 0x24, 0xf2, 0x87, 0xc0,
	0x8e, 0x77, 0xc9, 0xfc, 0x38, 0xf4, 0x24, 0xa0, 0xf0, 0x1f, 0xae, 0xc3, 0x1a, 0xef, 0xc7, 0xcf,
	0x7f, 0x0b, 0x6e, 0x0f, 0x92, 0x69, 0x6e, 0xcb, 0xf3, 0x1d, 0xca, 0x6d, 0xcf, 0xc5, 0x2f, 0x40,
	0xc6, 0x7b, 0x19, 0x56, 0x9b, 0x59, 0xe1, 0x9e, 0xf5, 0xd8, 0x94, 0x45, 0x6d, 0xf4, 0x51, 0xc2,
	0x84, 0x45, 0x80, 0x41, 0xec, 0xe0, 0x9a, 0x92, 0xe1, 0x92, 0x48, 0x02, 0x92, 0xff, 0x65, 0x0a,
	0x56, 0xd5, 0xb0, 0xc1, 0x4a, 0xad, 0x36, 0xee, 0xc2, 0xaa, 0x68, 0x36, 0xd3, 0xb6, 0x44, 0xba,
	0xcc, 0xc1, 0x86, 0xe0, 0x0a, 0x80, 0x66, 0x05, 0x64, 0x85, 0x45, 0xbf, 0xf0, 0x21, 0x6c, 0xd8,
	0x81, 0x79, 0xe6, 0xb9, 0x2d, 0xbb, 0xdd, 0xf3, 0x99, 0x25, 0x52, 0xad, 0x92, 0x5b, 0x76, 0x50,
	0x1a, 0xd8, 0x46, 0xc4, 0x48, 0x73, 0xc5, 0xe0, 0x3e, 0x64, 0xce, 0x3c, 0xa7, 0xeb, 0xb9, 0xa1,
	0x86, 0x5e, 0xcf, 0xb6, 0x44, 0x2f, 0xac, 0x1f, 0xac, 0x09, 0x52, 0xa3, 0x67, 0x5b, 0x64, 0x63,
	0x00, 0x08, 0x1f, 0xf3, 0xfb, 0xb0, 0x26, 0xc4, 0x05, 0xa1, 0xfc, 0x87, 0xb0, 0x64, 0x73, 0xe6,
	0x04, 0x9b, 0xa9, 0x9c, 0xb4, 0xbb, 0x9e, 0xd4, 0x5e, 0x6a, 0xb5, 0x49, 0xe4, 0xcb, 0xff, 0x34,
	0x0d, 0x58, 0xb5, 0x03, 0x1e, 0xd1, 0x08, 0x0b, 0xba, 0x9e, 0x1b, 0x30, 0x7c, 0x08, 0xcb, 0x01,
	0xa7, 0xbc, 0x17, 0xc4, 0x0b, 0x5f, 0x17, 0xe4, 0xba, 0x30, 0x91, 0xd8, 0x85, 0x4f, 0x61, 0xd9,
	0x67, 0x34, 0xf0, 0x5c, 0xb1, 0xdc, 0xcc, 0xc1, 0x7d, 0x01, 0x1a, 0x8f, 0x56, 0x20, 0x02, 0x45,
	0x62, 0x34, 0xbe, 0x0d, 0xcb, 0xd1, 0x21, 0x8e, 0x37, 0x21, 0x33, 0x54, 0x16, 0x0a, 0x27, 0xb1,
	0x37, 0xdc, 0xd5, 0x88, 0x61, 0x5a, 0x8c, 0x53, 0x3b, 0x3a, 0x0a, 0x6b, 0xe4, 0x56, 0x64, 0x2c,
	0x0b, 0x5b, 0xfe, 0x43, 0x58, 0x8e, 0xc2, 0xe3, 0x6d, 0x90, 0x1b, 0x7a, 0x59, 0x3d, 0xd2, 0x74,
	0xb5, 0x6c, 0x12, 0x55, 0xa9, 0xd7, 0x74, 0x79, 0x01, 0x11, 0x32, 0x0d, 0xfd, 0x7d, 0xbd, 0x76,
	0xaa, 0x9b, 0x65, 0xb5, 0xa9, 0x95, 0x54, 0x39, 0x15, 0xda, 0x34, 0xdd, 0x50, 0x89, 0xae, 0x54,
	0x4d, 0x95, 0x90, 0x1a, 0x91, 0xd3, 0x78, 0x07, 0x30, 0xf2, 0x9b, 0x0d, 0x9d, 0xa8, 0x4a, 0xa9,
	0xa2, 0x1c, 0x56, 0x55, 0x59, 0xca, 0x7f, 0x92, 0x82, 0x6c, 0x2c, 0x2d, 0x2e, 0xa5, 0xe8, 0x48,
	0xc2, 0x3e, 0xea, 0xb1, 0x80, 0xe3, 0x1e, 0xac, 0x5b, 0x2c, 0x9c, 0x41, 0x51, 0x81, 0x52, 0xa3,
	0x05, 0x82, 0xc8, 0x1b, 0xfe, 0xc6, 0x3d, 0x58, 0x39, 0x3b, 0xa7, 0x6e, 0x9b, 0x05, 0xd7, 0xce,
	0xdb, 0x60, 0xe1, 0xe1, 0x84, 0x88, 0x01, 0xb8, 0x07, 0xb2, 0xcf, 0x02, 0xc6, 0x4d, 0xee, 0x99,
	0x16, 0x6b, 0xd1, 0x5e, 0x87, 0x8b, 0xdd, 0x5a, 0xad, 0x2c, 0x90, 0x8c, 0xf0, 0x18, 0x5e, 0x39,
	0xb2, 0x87, 0x27, 0xc8, 0xeb, 0xb2, 0x48, 0x57, 0xfe, 0x27, 0x69, 0xd8, 0x9e, 0xa8, 0xf7, 0x75,
	0x2a, 0xfb, 0xa5, 0x91, 0xca, 0xee, 0x24, 0x85, 0x4e, 0x0a, 0x3b, 0x5a, 0xe2, 0xb1, 0xd2, 0x49,
	0x13, 0x4a, 0xe7, 0xff, 0x9f, 0x4a, 0x27, 0x6c, 0x4d, 0xa5, 0xaa, 0x95, 0xcd, 0x52, 0x4d, 0x3f,
	0xd2, 0x5e, 0xc8, 0xd2, 0x94, 0x72, 0x2e, 0xe6, 0x3f, 0x4e, 0xc1, 0x86, 0x58, 0xc7, 0x31, 0xe3,
	0x34, 0x1c, 0xa7, 0xaf, 0x55, 0xc1, 0xf1, 0x13, 0x99, 0x9e, 0x7d, 0x22, 0xf1, 0xad, 0x24, 0xc3,
	0xa5, 0x0e, 0x8b, 0x77, 0x62, 0x08, 0xd3, 0xa9, 0xc3, 0xf2, 0xdf, 0x4d, 0xc3, 0x92, 0x90, 0x85,
	0xcf, 0x21, 0x13, 0x0d, 0x1d, 0x87, 0x71, 0x6a, 0x51, 0x4e, 0x63, 0x45, 0x38, 0x2c, 0x41, 0x5f,
	0x3a, 0xd9, 0x60, 0xfd, 0xc7, 0x10, 0x78, 0x6d, 0x5e, 0xa5, 0x67, 0xce, 0xab, 0x67, 0xb0, 0xe6,
	0x53, 0x3b, 0x60, 0x96, 0x39, 0x38, 0x84, 0xd9, 0x42, 0xf4, 0xda, 0x2b, 0xf4, 0x5f, 0x7b, 0x05,
	0xa3, 0xff, 0x5e, 0x24, 0xab, 0x11, 0xd8, 0x08, 0xf0, 0xcb, 0x90, 0x19, 0x0c, 0x28, 0xd3, 0x76,
	0x5b, 0x5e, 0x3c, 0x92, 0xb6, 0xae, 0xcf, 0xb1, 0xc4, 0xe8, 0x26, 0x1b, 0x3c, 0x69, 0xc5, 0x2d,
	0x58, 0xa5, 0x56, 0xcc, 0x5d, 0x12, 0x5b, 0xb1, 0x42, 0x2d, 0xe1, 0xda, 0xfb, 0x03, 0xc6, 0xc3,
	0x57, 0xb3, 0x02, 0xdc, 0x84, 0xdb, 0x6a, 0x53, 0xd5, 0x0d, 0x53, 0x57, 0x8e, 0xc3, 0x22, 0xc6,
	0xdd, 0x21, 0x2f, 0xe0, 0x7d, 0xc8, 0x46, 0x1e, 0x83, 0x28, 0x7a, 0xbd, 0xa4, 0x6a, 0x4d, 0x95,
	0x98, 0x27, 0xd5, 0xc6, 0x0b, 0xb3, 0xd6, 0x30, 0x64, 0x0b, 0xef, 0xc1, 0xd6, 0x14, 0xbf, 0xa6,
	0xcb, 0x0c, 0x1f, 0xc1, 0x3b, 0xe3, 0xee, 0x66, 0xad, 0x6a, 0x28, 0x2f, 0x54, 0x53, 0x39, 0xac,
	0x35, 0x55, 0xd3, 0xa8, 0x10, 0xb5, 0x5e, 0xa9, 0x55, 0xcb, 0x72, 0x6b, 0x36, 0xfc, 0x50, 0xad,
	0xd6, 0x4e, 0x13, 0xf0, 0x36, 0xbe, 0x0b, 0x8f, 0xc6, 0xe1, 0x86, 0x7a, 0x7c, 0xa2, 0x12, 0xc5,
	0x68, 0x90, 0xf1, 0x0c, 0xe7, 0xf3, 0x29, 0xa3, 0x59, 0xec, 0xc9, 0xa2, 0x4a, 0x0d, 0x42, 0x42,
	0xdb, 0x68, 0x86, 0xaf, 0xcd, 0x86, 0x8f, 0x46, 0x7f, 0x85, 0x05, 0xd8, 0x1b, 0x87, 0x93, 0xaf,
	0x98, 0x27, 0xb5, 0x53, 0x95, 0x8c, 0x85, 0xef, 0xcc, 0xc1, 0x8f, 0xc6, 0x77, 0x26, 0xe3, 0x8d,
	0x69, 0xf1, 0xdd, 0x39, 0xf8, 0xd1, 0xf8, 0xde, 0xe4, 0x06, 0x38, 0x52, 0xb4, 0x6a, 0x83, 0xa8,
	0x72, 0x17, 0x9f, 0xc1, 0xe3, 0x1b, 0x37, 0x80, 0x49, 0xd4, 0x52, 0xad, 0xa9, 0x12, 0xb5, 0x2c,
	0x7f, 0x34, 0x9b, 0x38, 0x22, 0x23, 0x41, 0xf4, 0xf1, 0x3d, 0x78, 0xf6, 0x5a, 0x4d, 0x91, 0x20,
	0x07, 0xf3, 0xc9, 0xd3, 0x33, 0xf3, 0xc9, 0x92, 0xa7, 0x34, 0x4a, 0x82, 0xd8, 0x9b, 0x4d, 0x9c,
	0x9e, 0xf1, 0x02, 0xbf, 0x08, 0x4f, 0x6e, 0xde, 0x3c, 0x09, 0xe6, 0xe5, 0x1c, 0xe6, 0xf4, 0x9c,
	0x5f, 0x9f, 0xcc, 0x34, 0xe6, 0xe7, 0xbc, 0x9a, 0xc3, 0x9c, 0x9e, 0xf3, 0x1b, 0xb8, 0x03, 0x0f,
	0xa7, 0x36, 0x59, 0x02, 0xf8, 0x4d, 0xbc, 0x0b, 0x18, 0x01, 0x4f, 0xea, 0x8d, 0xe1, 0x98, 0xfa,
	0x55, 0x0a, 0xef, 0xc0, 0x1b, 0x23, 0x0e, 0x4d, 0x97, 0x7f, 0x3d, 0x62, 0xef, 0xb7, 0xed, 0x6f,
	0x52, 0x98, 0x83, 0xed, 0x31, 0x7b, 0x22, 0xd3, 0x6f, 0x13, 0xcc, 0x23, 0x45, 0x1f, 0x30, 0x7f,
	0x96, 0x1e, 0x4a, 0x08, 0xed, 0x03, 0x09, 0x9f, 0xa4, 0xaf, 0x13, 0xfa, 0x12, 0x7e, 0x9e, 0x1e,
	0xa6, 0x4a, 0x04, 0x4a, 0xa4, 0xfa, 0x45, 0x1a, 0xdf, 0x81, 0x37, 0x23, 0x44, 0xe9, 0xa4, 0x31,
	0xa1, 0x95, 0x4b, 0x44, 0x33, 0xb4, 0x92, 0x52, 0x95, 0xbf, 0x27, 0xe1, 0xdb, 0xf0, 0xd9, 0x59,
	0xd0, 0x23, 0xc5, 0x50, 0xaa, 0xf2, 0xf7, 0x25, 0x7c, 0x0c, 0x85, 0x9b, 0x84, 0x4c, 0xe8, 0xf8,
	0x81, 0x84, 0xfb, 0xf0, 0xb9, 0xb9, 0xc1, 0x13, 0x8c, 0x1f, 0x4a, 0xf8, 0x26, 0x3c, 0x18, 0x32,
	0x1a, 0xf5, 0x49, 0x53, 0xff, 0x63, 0x09, 0x0b, 0xfd, 0x91, 0x39, 0x15, 0x95, 0x88, 0xfa, 0x23,
	0x09, 0xb3, 0xf0, 0xe9, 0x08, 0x5f, 0x39, 0x8d, 0x3f, 0x56, 0x4c, 0xa2, 0xd6, 0x55, 0x43, 0xfe,
	0x93, 0x84, 0xc5, 0xfe, 0xfc, 0x1a, 0xfa, 0x66, 0xec, 0xd8, 0x9f, 0x25, 0xfc, 0x3c, 0xec, 0xcc,
	0x27, 0x44, 0xfb, 0xf6, 0x17, 0x09, 0x9f, 0xf7, 0x7b, 0xf8, 0x26, 0xe1, 0x13, 0xaa, 0xff, 0x2a,
	0xe1, 0x53, 0x78, 0xf7, 0x86, 0x89, 0x12, 0xbc, 0xbf, 0x49, 0xb8, 0x0d, 0x77, 0xc6, 0x57, 0x7b,
	0x58, 0xab, 0x19, 0xf2, 0xdf, 0x25, 0xdc, 0x81, 0xfc, 0xc0, 0x99, 0x8c, 0x56, 0x57, 0xf5, 0x7a,
	0x2d, 0x3a, 0x23, 0x6a, 0x59, 0xfe, 0xc7, 0xf5, 0x65, 0x2a, 0xd5, 0xea, 0x04, 0x70, 0xbd, 0x8f,
	0xfe, 0xa7, 0x84, 0xbb, 0xfd, 0x03, 0x17, 0xe6, 0xd4, 0xea, 0xef, 0x4f, 0xa9, 0xdd, 0xbf, 0x24,
	0x3c, 0xe8, 0xbf, 0x50, 0x67, 0x22, 0x13, 0x2b, 0xfa, 0xb7, 0x84, 0x7b, 0xf0, 0xd6, 0x80, 0x73,
	0xac, 0x1e, 0xd7, 0xc8, 0x07, 0x53, 0xe2, 0xff, 0x47, 0xc2, 0x27, 0x50, 0xbc, 0x11, 0x36, 0x91,
	0xe1, 0xbf, 0x12, 0xde, 0xef, 0xbf, 0x95, 0x2a, 0xa7, 0xa6, 0x6e, 0x9c, 0x98, 0xf5, 0x0f, 0xf4,
	0xd2, 0xe0, 0x90, 0x7e, 0x7b, 0xf1, 0xda, 0xfa, 0x46, 0xfd, 0x89, 0x48, 0xdf, 0x59, 0xc4, 0x7b,
	0xb0, 0x19, 0x21, 0xab, 0x9a, 0xae, 0x9a, 0x25, 0x85, 0x94, 0x87, 0x87, 0xfa, 0x77, 0x8b, 0xf8,
	0x19, 0xb8, 0x3b, 0xd1, 0xad, 0xe9, 0xf2, 0xef, 0x17, 0x0f, 0xfe, 0x98, 0x82, 0x7b, 0x3a, 0xe5,
	0xf6, 0x05, 0x8b, 0x3e, 0xe7, 0x8f, 0xa9, 0x4b, 0xdb, 0xcc, 0x61, 0x2e, 0xaf, 0x47, 0x7f, 0xa6,
	0xe0, 0x53, 0x80, 0xe1, 0x1d, 0x0e, 0xa3, 0x1b, 0x6a, 0x85, 0xfa, 0xd6, 0x25, 0xf5, 0x99, 0x56,
	0xce, 0xde, 0x9d, 0x72, 0xcb, 0xc3, 0x0f, 0x61, 0xab, 0xd1, 0xb5, 0x28, 0x67, 0x13, 0xee, 0x09,
	0xf8, 0x60, 0xfa, 0x0d, 0x42, 0x5c, 0xa4, 0xb2, 0xb9, 0x79, 0x57, 0x0c, 0x7c, 0x02, 0xb7, 0xea,
	0xdc, 0x67, 0xd4, 0x89, 0x95, 0xdd, 0x19, 0xfb, 0x62, 0x55, 0x9d, 0x2e, 0xbf, 0xca, 0xc2, 0x30,
	0xd2, 0x7e, 0xea, 0xf0, 0xbd, 0xaf, 0x3e, 0x6f, 0xdb, 0xfc, 0xbc, 0xf7, 0xb2, 0x70, 0xe6, 0x39,
	0x45, 0xaf, 0xcb, 0xdc, 0x33, 0xcf, 0xb7, 0x8a, 0xd1, 0x47, 0xfd, 0x23, 0x67, 0xb0, 0xfa, 0x47,
	0xb6, 0xcb, 0x99, 0xdf, 0xa2, 0x67, 0xac, 0x78, 0xf1, 0xb8, 0xd8, 0xf6, 0x8a, 0x96, 0x63, 0xbf,
	0x5c, 0x16, 0xa1, 0x1f, 0xff, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x76, 0x35, 0xd3, 0x5d, 0x7c, 0x12,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// NativeEventsManagementServiceClient is the client API for NativeEventsManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NativeEventsManagementServiceClient interface {
	// List the supported events for the passed device
	ListEvents(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Updates the configuration of the list of events in the request
	// The default behavior of the device is to report all the supported events
	// This configuration is persisted across reboots of the device or the device manager
	UpdateEventsConfiguration(ctx context.Context, in *EventsConfigurationRequest, opts ...grpc.CallOption) (*EventsConfigurationResponse, error)
	// Initiate the server streaming of the events
	StreamEvents(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (NativeEventsManagementService_StreamEventsClient, error)
}

type nativeEventsManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewNativeEventsManagementServiceClient(cc *grpc.ClientConn) NativeEventsManagementServiceClient {
	return &nativeEventsManagementServiceClient{cc}
}

func (c *nativeEventsManagementServiceClient) ListEvents(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeEventsManagementService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeEventsManagementServiceClient) UpdateEventsConfiguration(ctx context.Context, in *EventsConfigurationRequest, opts ...grpc.CallOption) (*EventsConfigurationResponse, error) {
	out := new(EventsConfigurationResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeEventsManagementService/UpdateEventsConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeEventsManagementServiceClient) StreamEvents(ctx context.Context, in *empty.Empty, opts ...grpc.CallOption) (NativeEventsManagementService_StreamEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_NativeEventsManagementService_serviceDesc.Streams[0], "/dmi.NativeEventsManagementService/StreamEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &nativeEventsManagementServiceStreamEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type NativeEventsManagementService_StreamEventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type nativeEventsManagementServiceStreamEventsClient struct {
	grpc.ClientStream
}

func (x *nativeEventsManagementServiceStreamEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// NativeEventsManagementServiceServer is the server API for NativeEventsManagementService service.
type NativeEventsManagementServiceServer interface {
	// List the supported events for the passed device
	ListEvents(context.Context, *HardwareID) (*ListEventsResponse, error)
	// Updates the configuration of the list of events in the request
	// The default behavior of the device is to report all the supported events
	// This configuration is persisted across reboots of the device or the device manager
	UpdateEventsConfiguration(context.Context, *EventsConfigurationRequest) (*EventsConfigurationResponse, error)
	// Initiate the server streaming of the events
	StreamEvents(*empty.Empty, NativeEventsManagementService_StreamEventsServer) error
}

// UnimplementedNativeEventsManagementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedNativeEventsManagementServiceServer struct {
}

func (*UnimplementedNativeEventsManagementServiceServer) ListEvents(ctx context.Context, req *HardwareID) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (*UnimplementedNativeEventsManagementServiceServer) UpdateEventsConfiguration(ctx context.Context, req *EventsConfigurationRequest) (*EventsConfigurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEventsConfiguration not implemented")
}
func (*UnimplementedNativeEventsManagementServiceServer) StreamEvents(req *empty.Empty, srv NativeEventsManagementService_StreamEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamEvents not implemented")
}

func RegisterNativeEventsManagementServiceServer(s *grpc.Server, srv NativeEventsManagementServiceServer) {
	s.RegisterService(&_NativeEventsManagementService_serviceDesc, srv)
}

func _NativeEventsManagementService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HardwareID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeEventsManagementServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeEventsManagementService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeEventsManagementServiceServer).ListEvents(ctx, req.(*HardwareID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeEventsManagementService_UpdateEventsConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventsConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeEventsManagementServiceServer).UpdateEventsConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeEventsManagementService/UpdateEventsConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeEventsManagementServiceServer).UpdateEventsConfiguration(ctx, req.(*EventsConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeEventsManagementService_StreamEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(empty.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(NativeEventsManagementServiceServer).StreamEvents(m, &nativeEventsManagementServiceStreamEventsServer{stream})
}

type NativeEventsManagementService_StreamEventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type nativeEventsManagementServiceStreamEventsServer struct {
	grpc.ServerStream
}

func (x *nativeEventsManagementServiceStreamEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

var _NativeEventsManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dmi.NativeEventsManagementService",
	HandlerType: (*NativeEventsManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEvents",
			Handler:    _NativeEventsManagementService_ListEvents_Handler,
		},
		{
			MethodName: "UpdateEventsConfiguration",
			Handler:    _NativeEventsManagementService_UpdateEventsConfiguration_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamEvents",
			Handler:       _NativeEventsManagementService_StreamEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "dmi/hw_events_mgmt_service.proto",
}
