// Code generated by protoc-gen-go. DO NOT EDIT.
// source: dmi/hw_events_mgmt_service.proto

package dmi

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EventIds int32

const (
	EventIds_EVENT_NAME_UNDEFINED EventIds = 0
	// Events from the Transceivers
	EventIds_EVENT_TRANSCEIVER_PLUG_OUT                              EventIds = 100
	EventIds_EVENT_TRANSCEIVER_PLUG_IN                               EventIds = 101
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD               EventIds = 102
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD               EventIds = 103
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD           EventIds = 104
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD           EventIds = 105
	EventIds_EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD               EventIds = 106
	EventIds_EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD               EventIds = 107
	EventIds_EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD              EventIds = 108
	EventIds_EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD              EventIds = 109
	EventIds_EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD              EventIds = 110
	EventIds_EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD              EventIds = 111
	EventIds_EVENT_TRANSCEIVER_FAILURE                               EventIds = 112
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED     EventIds = 113
	EventIds_EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED     EventIds = 114
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED EventIds = 115
	EventIds_EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED EventIds = 116
	EventIds_EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED     EventIds = 117
	EventIds_EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED     EventIds = 118
	EventIds_EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED    EventIds = 119
	EventIds_EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED    EventIds = 120
	EventIds_EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED    EventIds = 121
	EventIds_EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED    EventIds = 122
	EventIds_EVENT_TRANSCEIVER_FAILURE_RECOVERED                     EventIds = 123
	// Events from the PSU
	EventIds_EVENT_PSU_PLUG_OUT          EventIds = 200
	EventIds_EVENT_PSU_PLUG_IN           EventIds = 201
	EventIds_EVENT_PSU_FAILURE           EventIds = 202
	EventIds_EVENT_PSU_FAILURE_RECOVERED EventIds = 203
	// Events for the Fans
	EventIds_EVENT_FAN_FAILURE           EventIds = 300
	EventIds_EVENT_FAN_PLUG_OUT          EventIds = 301
	EventIds_EVENT_FAN_PLUG_IN           EventIds = 302
	EventIds_EVENT_FAN_FAILURE_RECOVERED EventIds = 303
	// Events for the CPUs
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL           EventIds = 400
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_FATAL              EventIds = 401
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED EventIds = 402
	EventIds_EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED    EventIds = 403
	// Events for the complete HW Device
	EventIds_EVENT_HW_DEVICE_RESET                                EventIds = 500
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL           EventIds = 501
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL              EventIds = 502
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED EventIds = 503
	EventIds_EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED    EventIds = 504
)

var EventIds_name = map[int32]string{
	0:   "EVENT_NAME_UNDEFINED",
	100: "EVENT_TRANSCEIVER_PLUG_OUT",
	101: "EVENT_TRANSCEIVER_PLUG_IN",
	102: "EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD",
	103: "EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD",
	104: "EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD",
	105: "EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD",
	106: "EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD",
	107: "EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD",
	108: "EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD",
	109: "EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD",
	110: "EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD",
	111: "EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD",
	112: "EVENT_TRANSCEIVER_FAILURE",
	113: "EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED",
	114: "EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED",
	115: "EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED",
	116: "EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED",
	117: "EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED",
	118: "EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED",
	119: "EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED",
	120: "EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED",
	121: "EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED",
	122: "EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED",
	123: "EVENT_TRANSCEIVER_FAILURE_RECOVERED",
	200: "EVENT_PSU_PLUG_OUT",
	201: "EVENT_PSU_PLUG_IN",
	202: "EVENT_PSU_FAILURE",
	203: "EVENT_PSU_FAILURE_RECOVERED",
	300: "EVENT_FAN_FAILURE",
	301: "EVENT_FAN_PLUG_OUT",
	302: "EVENT_FAN_PLUG_IN",
	303: "EVENT_FAN_FAILURE_RECOVERED",
	400: "EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL",
	401: "EVENT_CPU_TEMPERATURE_ABOVE_FATAL",
	402: "EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED",
	403: "EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED",
	500: "EVENT_HW_DEVICE_RESET",
	501: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL",
	502: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL",
	503: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED",
	504: "EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED",
}

var EventIds_value = map[string]int32{
	"EVENT_NAME_UNDEFINED":                                    0,
	"EVENT_TRANSCEIVER_PLUG_OUT":                              100,
	"EVENT_TRANSCEIVER_PLUG_IN":                               101,
	"EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD":               102,
	"EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD":               103,
	"EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD":           104,
	"EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD":           105,
	"EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD":               106,
	"EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD":               107,
	"EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD":              108,
	"EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD":              109,
	"EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD":              110,
	"EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD":              111,
	"EVENT_TRANSCEIVER_FAILURE":                               112,
	"EVENT_TRANSCEIVER_VOLTAGE_ABOVE_THRESHOLD_RECOVERED":     113,
	"EVENT_TRANSCEIVER_VOLTAGE_BELOW_THRESHOLD_RECOVERED":     114,
	"EVENT_TRANSCEIVER_TEMPERATURE_ABOVE_THRESHOLD_RECOVERED": 115,
	"EVENT_TRANSCEIVER_TEMPERATURE_BELOW_THRESHOLD_RECOVERED": 116,
	"EVENT_TRANSCEIVER_CURRENT_ABOVE_THRESHOLD_RECOVERED":     117,
	"EVENT_TRANSCEIVER_CURRENT_BELOW_THRESHOLD_RECOVERED":     118,
	"EVENT_TRANSCEIVER_RX_POWER_ABOVE_THRESHOLD_RECOVERED":    119,
	"EVENT_TRANSCEIVER_RX_POWER_BELOW_THRESHOLD_RECOVERED":    120,
	"EVENT_TRANSCEIVER_TX_POWER_ABOVE_THRESHOLD_RECOVERED":    121,
	"EVENT_TRANSCEIVER_TX_POWER_BELOW_THRESHOLD_RECOVERED":    122,
	"EVENT_TRANSCEIVER_FAILURE_RECOVERED":                     123,
	"EVENT_PSU_PLUG_OUT":                                      200,
	"EVENT_PSU_PLUG_IN":                                       201,
	"EVENT_PSU_FAILURE":                                       202,
	"EVENT_PSU_FAILURE_RECOVERED":                             203,
	"EVENT_FAN_FAILURE":                                       300,
	"EVENT_FAN_PLUG_OUT":                                      301,
	"EVENT_FAN_PLUG_IN":                                       302,
	"EVENT_FAN_FAILURE_RECOVERED":                             303,
	"EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL":                    400,
	"EVENT_CPU_TEMPERATURE_ABOVE_FATAL":                       401,
	"EVENT_CPU_TEMPERATURE_ABOVE_CRITICAL_RECOVERED":          402,
	"EVENT_CPU_TEMPERATURE_ABOVE_FATAL_RECOVERED":             403,
	"EVENT_HW_DEVICE_RESET":                                   500,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL":              501,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL":                 502,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_CRITICAL_RECOVERED":    503,
	"EVENT_HW_DEVICE_TEMPERATURE_ABOVE_FATAL_RECOVERED":       504,
}

func (x EventIds) String() string {
	return proto.EnumName(EventIds_name, int32(x))
}

func (EventIds) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{0}
}

type ListEventsResponse_Reason int32

const (
	ListEventsResponse_UNDEFINED_REASON   ListEventsResponse_Reason = 0
	ListEventsResponse_UNKNOWN_DEVICE     ListEventsResponse_Reason = 1
	ListEventsResponse_INTERNAL_ERROR     ListEventsResponse_Reason = 2
	ListEventsResponse_DEVICE_UNREACHABLE ListEventsResponse_Reason = 3
)

var ListEventsResponse_Reason_name = map[int32]string{
	0: "UNDEFINED_REASON",
	1: "UNKNOWN_DEVICE",
	2: "INTERNAL_ERROR",
	3: "DEVICE_UNREACHABLE",
}

var ListEventsResponse_Reason_value = map[string]int32{
	"UNDEFINED_REASON":   0,
	"UNKNOWN_DEVICE":     1,
	"INTERNAL_ERROR":     2,
	"DEVICE_UNREACHABLE": 3,
}

func (x ListEventsResponse_Reason) String() string {
	return proto.EnumName(ListEventsResponse_Reason_name, int32(x))
}

func (ListEventsResponse_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{6, 0}
}

type EventsConfigurationResponse_Reason int32

const (
	EventsConfigurationResponse_UNDEFINED_REASON   EventsConfigurationResponse_Reason = 0
	EventsConfigurationResponse_UNKNOWN_DEVICE     EventsConfigurationResponse_Reason = 1
	EventsConfigurationResponse_INTERNAL_ERROR     EventsConfigurationResponse_Reason = 2
	EventsConfigurationResponse_INVALID_CONFIG     EventsConfigurationResponse_Reason = 3
	EventsConfigurationResponse_DEVICE_UNREACHABLE EventsConfigurationResponse_Reason = 4
)

var EventsConfigurationResponse_Reason_name = map[int32]string{
	0: "UNDEFINED_REASON",
	1: "UNKNOWN_DEVICE",
	2: "INTERNAL_ERROR",
	3: "INVALID_CONFIG",
	4: "DEVICE_UNREACHABLE",
}

var EventsConfigurationResponse_Reason_value = map[string]int32{
	"UNDEFINED_REASON":   0,
	"UNKNOWN_DEVICE":     1,
	"INTERNAL_ERROR":     2,
	"INVALID_CONFIG":     3,
	"DEVICE_UNREACHABLE": 4,
}

func (x EventsConfigurationResponse_Reason) String() string {
	return proto.EnumName(EventsConfigurationResponse_Reason_name, int32(x))
}

func (EventsConfigurationResponse_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{8, 0}
}

type ValueType struct {
	// Types that are valid to be assigned to Val:
	//	*ValueType_IntVal
	//	*ValueType_UintVal
	//	*ValueType_FloatVal
	Val                  isValueType_Val `protobuf_oneof:"val"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ValueType) Reset()         { *m = ValueType{} }
func (m *ValueType) String() string { return proto.CompactTextString(m) }
func (*ValueType) ProtoMessage()    {}
func (*ValueType) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{0}
}

func (m *ValueType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueType.Unmarshal(m, b)
}
func (m *ValueType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueType.Marshal(b, m, deterministic)
}
func (m *ValueType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueType.Merge(m, src)
}
func (m *ValueType) XXX_Size() int {
	return xxx_messageInfo_ValueType.Size(m)
}
func (m *ValueType) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueType.DiscardUnknown(m)
}

var xxx_messageInfo_ValueType proto.InternalMessageInfo

type isValueType_Val interface {
	isValueType_Val()
}

type ValueType_IntVal struct {
	IntVal int64 `protobuf:"varint,1,opt,name=int_val,json=intVal,proto3,oneof"`
}

type ValueType_UintVal struct {
	UintVal uint64 `protobuf:"varint,2,opt,name=uint_val,json=uintVal,proto3,oneof"`
}

type ValueType_FloatVal struct {
	FloatVal float32 `protobuf:"fixed32,3,opt,name=float_val,json=floatVal,proto3,oneof"`
}

func (*ValueType_IntVal) isValueType_Val() {}

func (*ValueType_UintVal) isValueType_Val() {}

func (*ValueType_FloatVal) isValueType_Val() {}

func (m *ValueType) GetVal() isValueType_Val {
	if m != nil {
		return m.Val
	}
	return nil
}

func (m *ValueType) GetIntVal() int64 {
	if x, ok := m.GetVal().(*ValueType_IntVal); ok {
		return x.IntVal
	}
	return 0
}

func (m *ValueType) GetUintVal() uint64 {
	if x, ok := m.GetVal().(*ValueType_UintVal); ok {
		return x.UintVal
	}
	return 0
}

func (m *ValueType) GetFloatVal() float32 {
	if x, ok := m.GetVal().(*ValueType_FloatVal); ok {
		return x.FloatVal
	}
	return 0
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueType) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueType_IntVal)(nil),
		(*ValueType_UintVal)(nil),
		(*ValueType_FloatVal)(nil),
	}
}

type WaterMarks struct {
	High                 *ValueType `protobuf:"bytes,1,opt,name=high,proto3" json:"high,omitempty"`
	Low                  *ValueType `protobuf:"bytes,2,opt,name=low,proto3" json:"low,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *WaterMarks) Reset()         { *m = WaterMarks{} }
func (m *WaterMarks) String() string { return proto.CompactTextString(m) }
func (*WaterMarks) ProtoMessage()    {}
func (*WaterMarks) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{1}
}

func (m *WaterMarks) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WaterMarks.Unmarshal(m, b)
}
func (m *WaterMarks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WaterMarks.Marshal(b, m, deterministic)
}
func (m *WaterMarks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WaterMarks.Merge(m, src)
}
func (m *WaterMarks) XXX_Size() int {
	return xxx_messageInfo_WaterMarks.Size(m)
}
func (m *WaterMarks) XXX_DiscardUnknown() {
	xxx_messageInfo_WaterMarks.DiscardUnknown(m)
}

var xxx_messageInfo_WaterMarks proto.InternalMessageInfo

func (m *WaterMarks) GetHigh() *ValueType {
	if m != nil {
		return m.High
	}
	return nil
}

func (m *WaterMarks) GetLow() *ValueType {
	if m != nil {
		return m.Low
	}
	return nil
}

type Thresholds struct {
	// Types that are valid to be assigned to Threshold:
	//	*Thresholds_Upper
	//	*Thresholds_Lower
	Threshold            isThresholds_Threshold `protobuf_oneof:"threshold"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Thresholds) Reset()         { *m = Thresholds{} }
func (m *Thresholds) String() string { return proto.CompactTextString(m) }
func (*Thresholds) ProtoMessage()    {}
func (*Thresholds) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{2}
}

func (m *Thresholds) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Thresholds.Unmarshal(m, b)
}
func (m *Thresholds) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Thresholds.Marshal(b, m, deterministic)
}
func (m *Thresholds) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Thresholds.Merge(m, src)
}
func (m *Thresholds) XXX_Size() int {
	return xxx_messageInfo_Thresholds.Size(m)
}
func (m *Thresholds) XXX_DiscardUnknown() {
	xxx_messageInfo_Thresholds.DiscardUnknown(m)
}

var xxx_messageInfo_Thresholds proto.InternalMessageInfo

type isThresholds_Threshold interface {
	isThresholds_Threshold()
}

type Thresholds_Upper struct {
	Upper *WaterMarks `protobuf:"bytes,1,opt,name=upper,proto3,oneof"`
}

type Thresholds_Lower struct {
	Lower *WaterMarks `protobuf:"bytes,2,opt,name=lower,proto3,oneof"`
}

func (*Thresholds_Upper) isThresholds_Threshold() {}

func (*Thresholds_Lower) isThresholds_Threshold() {}

func (m *Thresholds) GetThreshold() isThresholds_Threshold {
	if m != nil {
		return m.Threshold
	}
	return nil
}

func (m *Thresholds) GetUpper() *WaterMarks {
	if x, ok := m.GetThreshold().(*Thresholds_Upper); ok {
		return x.Upper
	}
	return nil
}

func (m *Thresholds) GetLower() *WaterMarks {
	if x, ok := m.GetThreshold().(*Thresholds_Lower); ok {
		return x.Lower
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Thresholds) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Thresholds_Upper)(nil),
		(*Thresholds_Lower)(nil),
	}
}

type ThresholdInformation struct {
	ObservedValue        *ValueType  `protobuf:"bytes,1,opt,name=observed_value,json=observedValue,proto3" json:"observed_value,omitempty"`
	Thresholds           *Thresholds `protobuf:"bytes,2,opt,name=thresholds,proto3" json:"thresholds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ThresholdInformation) Reset()         { *m = ThresholdInformation{} }
func (m *ThresholdInformation) String() string { return proto.CompactTextString(m) }
func (*ThresholdInformation) ProtoMessage()    {}
func (*ThresholdInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{3}
}

func (m *ThresholdInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThresholdInformation.Unmarshal(m, b)
}
func (m *ThresholdInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThresholdInformation.Marshal(b, m, deterministic)
}
func (m *ThresholdInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThresholdInformation.Merge(m, src)
}
func (m *ThresholdInformation) XXX_Size() int {
	return xxx_messageInfo_ThresholdInformation.Size(m)
}
func (m *ThresholdInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_ThresholdInformation.DiscardUnknown(m)
}

var xxx_messageInfo_ThresholdInformation proto.InternalMessageInfo

func (m *ThresholdInformation) GetObservedValue() *ValueType {
	if m != nil {
		return m.ObservedValue
	}
	return nil
}

func (m *ThresholdInformation) GetThresholds() *Thresholds {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

type EventCfg struct {
	EventId      EventIds `protobuf:"varint,1,opt,name=event_id,json=eventId,proto3,enum=dmi.EventIds" json:"event_id,omitempty"`
	IsConfigured bool     `protobuf:"varint,2,opt,name=is_configured,json=isConfigured,proto3" json:"is_configured,omitempty"`
	// Optional threshold values, applicable only for some specific events
	Thresholds           *Thresholds `protobuf:"bytes,3,opt,name=thresholds,proto3" json:"thresholds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EventCfg) Reset()         { *m = EventCfg{} }
func (m *EventCfg) String() string { return proto.CompactTextString(m) }
func (*EventCfg) ProtoMessage()    {}
func (*EventCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{4}
}

func (m *EventCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventCfg.Unmarshal(m, b)
}
func (m *EventCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventCfg.Marshal(b, m, deterministic)
}
func (m *EventCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventCfg.Merge(m, src)
}
func (m *EventCfg) XXX_Size() int {
	return xxx_messageInfo_EventCfg.Size(m)
}
func (m *EventCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EventCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EventCfg proto.InternalMessageInfo

func (m *EventCfg) GetEventId() EventIds {
	if m != nil {
		return m.EventId
	}
	return EventIds_EVENT_NAME_UNDEFINED
}

func (m *EventCfg) GetIsConfigured() bool {
	if m != nil {
		return m.IsConfigured
	}
	return false
}

func (m *EventCfg) GetThresholds() *Thresholds {
	if m != nil {
		return m.Thresholds
	}
	return nil
}

type EventsCfg struct {
	Items                []*EventCfg `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EventsCfg) Reset()         { *m = EventsCfg{} }
func (m *EventsCfg) String() string { return proto.CompactTextString(m) }
func (*EventsCfg) ProtoMessage()    {}
func (*EventsCfg) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{5}
}

func (m *EventsCfg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsCfg.Unmarshal(m, b)
}
func (m *EventsCfg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsCfg.Marshal(b, m, deterministic)
}
func (m *EventsCfg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsCfg.Merge(m, src)
}
func (m *EventsCfg) XXX_Size() int {
	return xxx_messageInfo_EventsCfg.Size(m)
}
func (m *EventsCfg) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsCfg.DiscardUnknown(m)
}

var xxx_messageInfo_EventsCfg proto.InternalMessageInfo

func (m *EventsCfg) GetItems() []*EventCfg {
	if m != nil {
		return m.Items
	}
	return nil
}

type ListEventsResponse struct {
	Status               Status                    `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               ListEventsResponse_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.ListEventsResponse_Reason" json:"reason,omitempty"`
	Events               *EventsCfg                `protobuf:"bytes,3,opt,name=events,proto3" json:"events,omitempty"`
	ReasonDetail         string                    `protobuf:"bytes,4,opt,name=reason_detail,json=reasonDetail,proto3" json:"reason_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ListEventsResponse) Reset()         { *m = ListEventsResponse{} }
func (m *ListEventsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEventsResponse) ProtoMessage()    {}
func (*ListEventsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{6}
}

func (m *ListEventsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEventsResponse.Unmarshal(m, b)
}
func (m *ListEventsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEventsResponse.Marshal(b, m, deterministic)
}
func (m *ListEventsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEventsResponse.Merge(m, src)
}
func (m *ListEventsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEventsResponse.Size(m)
}
func (m *ListEventsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEventsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEventsResponse proto.InternalMessageInfo

func (m *ListEventsResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *ListEventsResponse) GetReason() ListEventsResponse_Reason {
	if m != nil {
		return m.Reason
	}
	return ListEventsResponse_UNDEFINED_REASON
}

func (m *ListEventsResponse) GetEvents() *EventsCfg {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *ListEventsResponse) GetReasonDetail() string {
	if m != nil {
		return m.ReasonDetail
	}
	return ""
}

type EventsConfigurationRequest struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// Types that are valid to be assigned to Operation:
	//	*EventsConfigurationRequest_Changes
	//	*EventsConfigurationRequest_ResetToDefault
	Operation            isEventsConfigurationRequest_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *EventsConfigurationRequest) Reset()         { *m = EventsConfigurationRequest{} }
func (m *EventsConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*EventsConfigurationRequest) ProtoMessage()    {}
func (*EventsConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{7}
}

func (m *EventsConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsConfigurationRequest.Unmarshal(m, b)
}
func (m *EventsConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *EventsConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsConfigurationRequest.Merge(m, src)
}
func (m *EventsConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_EventsConfigurationRequest.Size(m)
}
func (m *EventsConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EventsConfigurationRequest proto.InternalMessageInfo

func (m *EventsConfigurationRequest) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

type isEventsConfigurationRequest_Operation interface {
	isEventsConfigurationRequest_Operation()
}

type EventsConfigurationRequest_Changes struct {
	Changes *EventsCfg `protobuf:"bytes,2,opt,name=changes,proto3,oneof"`
}

type EventsConfigurationRequest_ResetToDefault struct {
	ResetToDefault bool `protobuf:"varint,3,opt,name=reset_to_default,json=resetToDefault,proto3,oneof"`
}

func (*EventsConfigurationRequest_Changes) isEventsConfigurationRequest_Operation() {}

func (*EventsConfigurationRequest_ResetToDefault) isEventsConfigurationRequest_Operation() {}

func (m *EventsConfigurationRequest) GetOperation() isEventsConfigurationRequest_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *EventsConfigurationRequest) GetChanges() *EventsCfg {
	if x, ok := m.GetOperation().(*EventsConfigurationRequest_Changes); ok {
		return x.Changes
	}
	return nil
}

func (m *EventsConfigurationRequest) GetResetToDefault() bool {
	if x, ok := m.GetOperation().(*EventsConfigurationRequest_ResetToDefault); ok {
		return x.ResetToDefault
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*EventsConfigurationRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*EventsConfigurationRequest_Changes)(nil),
		(*EventsConfigurationRequest_ResetToDefault)(nil),
	}
}

type EventsConfigurationResponse struct {
	Status               Status                             `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               EventsConfigurationResponse_Reason `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.EventsConfigurationResponse_Reason" json:"reason,omitempty"`
	ReasonDetail         string                             `protobuf:"bytes,3,opt,name=reason_detail,json=reasonDetail,proto3" json:"reason_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *EventsConfigurationResponse) Reset()         { *m = EventsConfigurationResponse{} }
func (m *EventsConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*EventsConfigurationResponse) ProtoMessage()    {}
func (*EventsConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{8}
}

func (m *EventsConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsConfigurationResponse.Unmarshal(m, b)
}
func (m *EventsConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsConfigurationResponse.Marshal(b, m, deterministic)
}
func (m *EventsConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsConfigurationResponse.Merge(m, src)
}
func (m *EventsConfigurationResponse) XXX_Size() int {
	return xxx_messageInfo_EventsConfigurationResponse.Size(m)
}
func (m *EventsConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EventsConfigurationResponse proto.InternalMessageInfo

func (m *EventsConfigurationResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *EventsConfigurationResponse) GetReason() EventsConfigurationResponse_Reason {
	if m != nil {
		return m.Reason
	}
	return EventsConfigurationResponse_UNDEFINED_REASON
}

func (m *EventsConfigurationResponse) GetReasonDetail() string {
	if m != nil {
		return m.ReasonDetail
	}
	return ""
}

type EventMetaData struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// uuid of the component
	ComponentUuid        *Uuid    `protobuf:"bytes,2,opt,name=component_uuid,json=componentUuid,proto3" json:"component_uuid,omitempty"`
	ComponentName        string   `protobuf:"bytes,3,opt,name=component_name,json=componentName,proto3" json:"component_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventMetaData) Reset()         { *m = EventMetaData{} }
func (m *EventMetaData) String() string { return proto.CompactTextString(m) }
func (*EventMetaData) ProtoMessage()    {}
func (*EventMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{9}
}

func (m *EventMetaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventMetaData.Unmarshal(m, b)
}
func (m *EventMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventMetaData.Marshal(b, m, deterministic)
}
func (m *EventMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventMetaData.Merge(m, src)
}
func (m *EventMetaData) XXX_Size() int {
	return xxx_messageInfo_EventMetaData.Size(m)
}
func (m *EventMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_EventMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_EventMetaData proto.InternalMessageInfo

func (m *EventMetaData) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

func (m *EventMetaData) GetComponentUuid() *Uuid {
	if m != nil {
		return m.ComponentUuid
	}
	return nil
}

func (m *EventMetaData) GetComponentName() string {
	if m != nil {
		return m.ComponentName
	}
	return ""
}

type Event struct {
	EventMetadata *EventMetaData       `protobuf:"bytes,1,opt,name=event_metadata,json=eventMetadata,proto3" json:"event_metadata,omitempty"`
	EventId       EventIds             `protobuf:"varint,2,opt,name=event_id,json=eventId,proto3,enum=dmi.EventIds" json:"event_id,omitempty"`
	RaisedTs      *timestamp.Timestamp `protobuf:"bytes,3,opt,name=raised_ts,json=raisedTs,proto3" json:"raised_ts,omitempty"`
	// Optional threshold information for an event
	ThresholdInfo *ThresholdInformation `protobuf:"bytes,4,opt,name=threshold_info,json=thresholdInfo,proto3" json:"threshold_info,omitempty"`
	// Any additional info regarding the event
	AddInfo              string   `protobuf:"bytes,5,opt,name=add_info,json=addInfo,proto3" json:"add_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_8962d785556e9979, []int{10}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetEventMetadata() *EventMetaData {
	if m != nil {
		return m.EventMetadata
	}
	return nil
}

func (m *Event) GetEventId() EventIds {
	if m != nil {
		return m.EventId
	}
	return EventIds_EVENT_NAME_UNDEFINED
}

func (m *Event) GetRaisedTs() *timestamp.Timestamp {
	if m != nil {
		return m.RaisedTs
	}
	return nil
}

func (m *Event) GetThresholdInfo() *ThresholdInformation {
	if m != nil {
		return m.ThresholdInfo
	}
	return nil
}

func (m *Event) GetAddInfo() string {
	if m != nil {
		return m.AddInfo
	}
	return ""
}

func init() {
	proto.RegisterEnum("dmi.EventIds", EventIds_name, EventIds_value)
	proto.RegisterEnum("dmi.ListEventsResponse_Reason", ListEventsResponse_Reason_name, ListEventsResponse_Reason_value)
	proto.RegisterEnum("dmi.EventsConfigurationResponse_Reason", EventsConfigurationResponse_Reason_name, EventsConfigurationResponse_Reason_value)
	proto.RegisterType((*ValueType)(nil), "dmi.ValueType")
	proto.RegisterType((*WaterMarks)(nil), "dmi.WaterMarks")
	proto.RegisterType((*Thresholds)(nil), "dmi.Thresholds")
	proto.RegisterType((*ThresholdInformation)(nil), "dmi.ThresholdInformation")
	proto.RegisterType((*EventCfg)(nil), "dmi.EventCfg")
	proto.RegisterType((*EventsCfg)(nil), "dmi.EventsCfg")
	proto.RegisterType((*ListEventsResponse)(nil), "dmi.ListEventsResponse")
	proto.RegisterType((*EventsConfigurationRequest)(nil), "dmi.EventsConfigurationRequest")
	proto.RegisterType((*EventsConfigurationResponse)(nil), "dmi.EventsConfigurationResponse")
	proto.RegisterType((*EventMetaData)(nil), "dmi.EventMetaData")
	proto.RegisterType((*Event)(nil), "dmi.Event")
}

func init() { proto.RegisterFile("dmi/hw_events_mgmt_service.proto", fileDescriptor_8962d785556e9979) }

var fileDescriptor_8962d785556e9979 = []byte{
	// 1448 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0x4b, 0x73, 0xdb, 0xd4,
	0x17, 0x8f, 0xad, 0x3c, 0x9c, 0x93, 0xc6, 0x7f, 0xf5, 0x4e, 0xff, 0x6d, 0xe2, 0x4e, 0x5b, 0xe3,
	0x40, 0x93, 0x06, 0x62, 0xb7, 0x09, 0xb4, 0x74, 0xba, 0x00, 0xc5, 0x56, 0x6a, 0x0d, 0x8e, 0x9c,
	0xb9, 0x91, 0x1d, 0x86, 0x45, 0x35, 0x37, 0xd6, 0xb5, 0x2d, 0x6a, 0x49, 0xae, 0x74, 0x95, 0x50,
	0x98, 0x61, 0xc1, 0x92, 0x15, 0xaf, 0x25, 0xc3, 0x27, 0xa0, 0xb0, 0xe4, 0x2b, 0xf0, 0x58, 0xf1,
	0x5d, 0x78, 0x2d, 0x19, 0x5d, 0xc9, 0xb6, 0xe2, 0x47, 0x9c, 0xce, 0xb0, 0xb3, 0xce, 0xf9, 0xfd,
	0xce, 0xf9, 0x5d, 0x9d, 0x73, 0x8f, 0x8e, 0x21, 0x6b, 0x58, 0x66, 0xa1, 0x7d, 0xaa, 0xd3, 0x13,
	0x6a, 0x33, 0x4f, 0xb7, 0x5a, 0x16, 0xd3, 0x3d, 0xea, 0x9e, 0x98, 0x0d, 0x9a, 0xef, 0xba, 0x0e,
	0x73, 0x90, 0x60, 0x58, 0x66, 0xe6, 0x72, 0x00, 0x6b, 0x38, 0x96, 0xe5, 0xd8, 0x5e, 0x68, 0xcf,
	0x5c, 0x0a, 0x99, 0xd1, 0xd3, 0xad, 0x96, 0xe3, 0xb4, 0x3a, 0xb4, 0xc0, 0x9f, 0x8e, 0xfd, 0x66,
	0x81, 0x99, 0x16, 0xf5, 0x18, 0xb1, 0xba, 0x21, 0x20, 0x67, 0xc2, 0x62, 0x9d, 0x74, 0x7c, 0xaa,
	0x3d, 0xef, 0x52, 0xb4, 0x0a, 0x0b, 0xa6, 0xcd, 0xf4, 0x13, 0xd2, 0x59, 0x49, 0x64, 0x13, 0x1b,
	0x42, 0x79, 0x06, 0xcf, 0x9b, 0x36, 0xab, 0x93, 0x0e, 0xba, 0x0e, 0x29, 0xbf, 0xe7, 0x4b, 0x66,
	0x13, 0x1b, 0xb3, 0xe5, 0x19, 0xbc, 0xe0, 0x47, 0xce, 0x1b, 0xb0, 0xd8, 0xec, 0x38, 0x24, 0xf4,
	0x0a, 0xd9, 0xc4, 0x46, 0xb2, 0x3c, 0x83, 0x53, 0xdc, 0x54, 0x27, 0x9d, 0xdd, 0x39, 0x10, 0x4e,
	0x48, 0x27, 0x87, 0x01, 0x8e, 0x08, 0xa3, 0xee, 0x3e, 0x71, 0x9f, 0x7a, 0x28, 0x07, 0xb3, 0x6d,
	0xb3, 0xd5, 0xe6, 0x89, 0x96, 0xb6, 0xd3, 0x79, 0xc3, 0x32, 0xf3, 0x7d, 0x25, 0x98, 0xfb, 0x50,
	0x16, 0x84, 0x8e, 0x73, 0xca, 0xf3, 0x8d, 0x42, 0x02, 0x57, 0xee, 0x29, 0x80, 0xd6, 0x76, 0xa9,
	0xd7, 0x76, 0x3a, 0x86, 0x87, 0xd6, 0x61, 0xce, 0xef, 0x76, 0xa9, 0x1b, 0x05, 0xfd, 0x1f, 0x67,
	0x0c, 0x72, 0x96, 0x67, 0x70, 0xe8, 0x0f, 0x80, 0x1d, 0xe7, 0x94, 0xba, 0x51, 0xe8, 0x71, 0x40,
	0xee, 0xdf, 0x5d, 0x82, 0x45, 0xd6, 0x8b, 0x9f, 0xfb, 0x14, 0xae, 0xf4, 0x93, 0x29, 0x76, 0xd3,
	0x71, 0x2d, 0xc2, 0x4c, 0xc7, 0x46, 0x6f, 0x41, 0xda, 0x39, 0x0e, 0xaa, 0x43, 0x8d, 0xe0, 0x0d,
	0xf8, 0x74, 0xc2, 0xa1, 0x96, 0x7b, 0x28, 0x6e, 0x42, 0x05, 0x80, 0x7e, 0x6c, 0xef, 0x8c, 0x92,
	0xc1, 0x91, 0x70, 0x0c, 0x92, 0xfb, 0x3c, 0x01, 0x29, 0x39, 0x68, 0x88, 0x62, 0xb3, 0x85, 0x36,
	0x20, 0xc5, 0x9b, 0x43, 0x37, 0x0d, 0x9e, 0x2e, 0xbd, 0xbd, 0xcc, 0xb9, 0x1c, 0xa0, 0x18, 0x1e,
	0x5e, 0xa0, 0xe1, 0x2f, 0xb4, 0x06, 0xcb, 0xa6, 0xa7, 0x37, 0x1c, 0xbb, 0x69, 0xb6, 0x7c, 0x97,
	0x1a, 0x3c, 0x55, 0x0a, 0x5f, 0x32, 0xbd, 0x62, 0xdf, 0x36, 0x24, 0x46, 0x98, 0x2e, 0xe6, 0x2e,
	0x2c, 0xf2, 0x54, 0x5e, 0x20, 0x66, 0x0d, 0xe6, 0x4c, 0x46, 0x2d, 0x6f, 0x25, 0x91, 0x15, 0x36,
	0x96, 0xe2, 0x4a, 0x8a, 0xcd, 0x16, 0x0e, 0x7d, 0xb9, 0xef, 0x92, 0x80, 0x2a, 0xa6, 0xc7, 0x42,
	0x1a, 0xa6, 0x5e, 0xd7, 0xb1, 0x3d, 0x8a, 0xd6, 0x60, 0xde, 0x63, 0x84, 0xf9, 0x5e, 0x74, 0x8c,
	0x25, 0x4e, 0x3e, 0xe4, 0x26, 0x1c, 0xb9, 0xd0, 0x7d, 0x98, 0x77, 0x29, 0xf1, 0x1c, 0x9b, 0x8b,
	0x4f, 0x6f, 0xdf, 0xe4, 0xa0, 0xd1, 0x68, 0x79, 0xcc, 0x51, 0x38, 0x42, 0xa3, 0xdb, 0x30, 0x1f,
	0x5e, 0xa1, 0xe8, 0x48, 0xe9, 0x81, 0xb2, 0x40, 0x38, 0x8e, 0xbc, 0xc1, 0x3b, 0x0a, 0x19, 0xba,
	0x41, 0x19, 0x31, 0x3b, 0x2b, 0xb3, 0xd9, 0xc4, 0xc6, 0x22, 0xbe, 0x14, 0x1a, 0x4b, 0xdc, 0x96,
	0x7b, 0x02, 0xf3, 0x61, 0x78, 0x74, 0x05, 0xc4, 0x9a, 0x5a, 0x92, 0xf7, 0x14, 0x55, 0x2e, 0xe9,
	0x58, 0x96, 0x0e, 0xab, 0xaa, 0x38, 0x83, 0x10, 0xa4, 0x6b, 0xea, 0x7b, 0x6a, 0xf5, 0x48, 0xd5,
	0x4b, 0x72, 0x5d, 0x29, 0xca, 0x62, 0x22, 0xb0, 0x29, 0xaa, 0x26, 0x63, 0x55, 0xaa, 0xe8, 0x32,
	0xc6, 0x55, 0x2c, 0x26, 0xd1, 0x55, 0x40, 0xa1, 0x5f, 0xaf, 0xa9, 0x58, 0x96, 0x8a, 0x65, 0x69,
	0xb7, 0x22, 0x8b, 0x42, 0xee, 0x45, 0x02, 0x32, 0x91, 0xb4, 0xa8, 0x30, 0xbc, 0xbf, 0x30, 0x7d,
	0xe6, 0x53, 0x8f, 0xa1, 0x4d, 0x58, 0x32, 0x68, 0x30, 0x01, 0x74, 0xdf, 0x8f, 0x8a, 0xbe, 0xb4,
	0xbd, 0xc8, 0x0f, 0x54, 0xf3, 0x4d, 0x03, 0x43, 0xe8, 0x0d, 0x7e, 0xa3, 0x4d, 0x58, 0x68, 0xb4,
	0x89, 0xdd, 0xa2, 0xde, 0x99, 0xdb, 0xd3, 0x3f, 0x78, 0x70, 0x7b, 0x23, 0x00, 0xda, 0x04, 0xd1,
	0xa5, 0x1e, 0x65, 0x3a, 0x73, 0x74, 0x83, 0x36, 0x89, 0xdf, 0x61, 0xfc, 0x6d, 0xa5, 0xca, 0x33,
	0x38, 0xcd, 0x3d, 0x9a, 0x53, 0x0a, 0xed, 0xc1, 0x7d, 0x70, 0xba, 0x34, 0xd4, 0x95, 0xfb, 0x36,
	0x09, 0xd7, 0xc7, 0xea, 0x7d, 0x99, 0xca, 0xbe, 0x33, 0x54, 0xd9, 0xf5, 0xb8, 0xd0, 0x71, 0x61,
	0x87, 0x4b, 0x3c, 0x52, 0x3a, 0x61, 0x4c, 0xe9, 0xdc, 0xff, 0xa8, 0x74, 0xdc, 0x56, 0x97, 0x2a,
	0x4a, 0x49, 0x2f, 0x56, 0xd5, 0x3d, 0xe5, 0xb1, 0x28, 0x4c, 0x28, 0xe7, 0x6c, 0xee, 0x9b, 0x04,
	0x2c, 0xf3, 0x73, 0xec, 0x53, 0x46, 0x4a, 0x84, 0x91, 0x97, 0xaa, 0xe0, 0x5d, 0x48, 0x37, 0x1c,
	0xab, 0xeb, 0xd8, 0xc1, 0x1d, 0xe7, 0xf0, 0xe4, 0x30, 0x7c, 0xb9, 0x0f, 0xe0, 0x8c, 0xd7, 0xe2,
	0x0c, 0x9b, 0x58, 0x34, 0x7a, 0x13, 0x03, 0x98, 0x4a, 0x2c, 0x9a, 0xfb, 0x2c, 0x09, 0x73, 0x5c,
	0x16, 0x7a, 0x08, 0xe9, 0x70, 0x84, 0x58, 0x94, 0x11, 0x83, 0x30, 0x12, 0x29, 0x42, 0x83, 0x12,
	0xf4, 0xa4, 0xe3, 0x65, 0xda, 0x7b, 0x0c, 0x80, 0x67, 0xa6, 0x4f, 0xf2, 0xdc, 0xe9, 0xf3, 0x00,
	0x16, 0x5d, 0x62, 0x7a, 0xd4, 0xd0, 0xfb, 0x97, 0x30, 0x93, 0x0f, 0xbf, 0x4a, 0xf9, 0xde, 0x57,
	0x29, 0xaf, 0xf5, 0xbe, 0x4a, 0x38, 0x15, 0x82, 0x35, 0x0f, 0xbd, 0x0b, 0xe9, 0xfe, 0xb8, 0xd1,
	0x4d, 0xbb, 0xe9, 0xf0, 0x3b, 0xb9, 0xb4, 0xbd, 0x7a, 0x76, 0x2a, 0xc5, 0x06, 0x31, 0x5e, 0x66,
	0x71, 0x2b, 0x5a, 0x85, 0x14, 0x31, 0x22, 0xee, 0x1c, 0x7f, 0x15, 0x0b, 0xc4, 0xe0, 0xae, 0xcd,
	0xdf, 0xd3, 0xd1, 0x28, 0x55, 0x0c, 0x0f, 0xad, 0xc0, 0x15, 0xb9, 0x2e, 0xab, 0x9a, 0xae, 0x4a,
	0xfb, 0x41, 0x11, 0xa3, 0xee, 0x10, 0x67, 0xd0, 0x4d, 0xc8, 0x84, 0x1e, 0x0d, 0x4b, 0xea, 0x61,
	0x51, 0x56, 0xea, 0x32, 0xd6, 0x0f, 0x2a, 0xb5, 0xc7, 0x7a, 0xb5, 0xa6, 0x89, 0x06, 0xba, 0x01,
	0xab, 0x13, 0xfc, 0x8a, 0x2a, 0x52, 0xb4, 0x05, 0x77, 0x46, 0xdd, 0xf5, 0x6a, 0x45, 0x93, 0x1e,
	0xcb, 0xba, 0xb4, 0x5b, 0xad, 0xcb, 0xba, 0x56, 0xc6, 0xf2, 0x61, 0xb9, 0x5a, 0x29, 0x89, 0xcd,
	0xf3, 0xe1, 0xbb, 0x72, 0xa5, 0x7a, 0x14, 0x83, 0xb7, 0xd0, 0x3d, 0xd8, 0x1a, 0x85, 0x6b, 0xf2,
	0xfe, 0x81, 0x8c, 0x25, 0xad, 0x86, 0x47, 0x33, 0xb4, 0xa7, 0x53, 0x86, 0xb3, 0x98, 0xe3, 0x45,
	0x15, 0x6b, 0x18, 0x07, 0xb6, 0xe1, 0x0c, 0x1f, 0x9e, 0x0f, 0x1f, 0x8e, 0xfe, 0x14, 0xe5, 0x61,
	0x73, 0x14, 0x8e, 0xdf, 0xd7, 0x0f, 0xaa, 0x47, 0x32, 0x1e, 0x09, 0xdf, 0x99, 0x82, 0x1f, 0x8e,
	0x6f, 0x8d, 0xc7, 0x6b, 0x93, 0xe2, 0xdb, 0x53, 0xf0, 0xc3, 0xf1, 0x9d, 0xf1, 0x0d, 0xb0, 0x27,
	0x29, 0x95, 0x1a, 0x96, 0xc5, 0x2e, 0x7a, 0x00, 0x3b, 0x17, 0x6e, 0x00, 0x1d, 0xcb, 0xc5, 0x6a,
	0x5d, 0xc6, 0x72, 0x49, 0x7c, 0x76, 0x3e, 0x71, 0x48, 0x46, 0x8c, 0xe8, 0xa2, 0x47, 0xf0, 0xe0,
	0xa5, 0x9a, 0x22, 0x46, 0xf6, 0xa6, 0x93, 0x27, 0x67, 0x66, 0xe3, 0x25, 0x4f, 0x68, 0x94, 0x18,
	0xd1, 0x3f, 0x9f, 0x38, 0x39, 0xe3, 0x09, 0x7a, 0x1b, 0xde, 0xbc, 0x78, 0xf3, 0xc4, 0x98, 0xa7,
	0x53, 0x98, 0x93, 0x73, 0x7e, 0x34, 0x9e, 0xa9, 0x4d, 0xcf, 0xf9, 0x7c, 0x0a, 0x73, 0x72, 0xce,
	0x8f, 0xd1, 0x3a, 0xac, 0x4d, 0x6c, 0xb2, 0x18, 0xf0, 0x13, 0x74, 0x0d, 0x50, 0x08, 0x3c, 0x38,
	0xac, 0x0d, 0xc6, 0xd4, 0xcf, 0x09, 0x74, 0x15, 0x2e, 0x0f, 0x39, 0x14, 0x55, 0xfc, 0x65, 0xc8,
	0xde, 0x6b, 0xdb, 0x5f, 0x13, 0x28, 0x0b, 0xd7, 0x47, 0xec, 0xb1, 0x4c, 0xbf, 0xc5, 0x98, 0x7b,
	0x92, 0xda, 0x67, 0x7e, 0x9f, 0x1c, 0x48, 0x08, 0xec, 0x7d, 0x09, 0x2f, 0x92, 0x67, 0x09, 0x3d,
	0x09, 0x3f, 0x24, 0x07, 0xa9, 0x62, 0x81, 0x62, 0xa9, 0x7e, 0x4c, 0xa2, 0x3b, 0xf0, 0x6a, 0x88,
	0x28, 0x1e, 0xd4, 0xc6, 0xb4, 0x72, 0x11, 0x2b, 0x9a, 0x52, 0x94, 0x2a, 0xe2, 0x17, 0x02, 0xba,
	0x0d, 0xaf, 0x9c, 0x07, 0xdd, 0x93, 0x34, 0xa9, 0x22, 0x7e, 0x29, 0xa0, 0x1d, 0xc8, 0x5f, 0x24,
	0x64, 0x4c, 0xc7, 0x57, 0x02, 0xba, 0x0b, 0xaf, 0x4f, 0x0d, 0x1e, 0x63, 0x7c, 0x2d, 0xa0, 0x0c,
	0xfc, 0x3f, 0x64, 0x94, 0x8f, 0xa2, 0xb5, 0x42, 0xc7, 0xf2, 0xa1, 0xac, 0x89, 0x7f, 0x08, 0xa8,
	0xd0, 0x9b, 0x34, 0x03, 0xdf, 0x39, 0x67, 0xfb, 0x53, 0x40, 0x6f, 0xc0, 0xfa, 0x74, 0x42, 0x78,
	0xc2, 0xbf, 0x04, 0xf4, 0xb0, 0xd7, 0x6d, 0x17, 0x09, 0x1f, 0x53, 0xfd, 0xb7, 0x80, 0xee, 0xc3,
	0xbd, 0x0b, 0x26, 0x8a, 0xf1, 0xfe, 0x11, 0xb6, 0x7f, 0x4a, 0xc0, 0x0d, 0x95, 0x30, 0xf3, 0x84,
	0x86, 0xdb, 0xdb, 0x3e, 0xb1, 0x49, 0x8b, 0x5a, 0xd4, 0x66, 0x87, 0xe1, 0x3f, 0x57, 0x74, 0x1f,
	0x60, 0xb0, 0xb2, 0xa3, 0xf0, 0xef, 0x45, 0x99, 0xb8, 0xc6, 0x29, 0x71, 0xa9, 0x52, 0xca, 0x5c,
	0x9b, 0xb0, 0xd4, 0xa3, 0x27, 0xb0, 0x5a, 0xeb, 0x1a, 0x84, 0xd1, 0x31, 0x6b, 0x21, 0xba, 0x35,
	0x79, 0x61, 0xe4, 0x7b, 0x73, 0x26, 0x3b, 0x6d, 0xa3, 0xdc, 0x7d, 0xf4, 0xc1, 0xc3, 0x96, 0xc9,
	0xda, 0xfe, 0x71, 0xbe, 0xe1, 0x58, 0x05, 0xa7, 0x4b, 0xed, 0x86, 0xe3, 0x1a, 0x85, 0x70, 0x1b,
	0xdb, 0xb2, 0xfa, 0xe7, 0xd8, 0x32, 0x6d, 0x46, 0xdd, 0x26, 0x69, 0xd0, 0xc2, 0xc9, 0x4e, 0xa1,
	0xe5, 0x14, 0x0c, 0xcb, 0x3c, 0x9e, 0xe7, 0x5b, 0xcc, 0xce, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff,
	0x36, 0x83, 0x3b, 0x4c, 0xb3, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// NativeEventsManagementServiceClient is the client API for NativeEventsManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NativeEventsManagementServiceClient interface {
	// List the supported events for the passed device
	ListEvents(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Updates the configuration of the list of events in the request
	// The default behavior of the device is to report all the supported events
	// This configuration is persisted across reboots of the device or the device manager
	UpdateEventsConfiguration(ctx context.Context, in *EventsConfigurationRequest, opts ...grpc.CallOption) (*EventsConfigurationResponse, error)
}

type nativeEventsManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewNativeEventsManagementServiceClient(cc *grpc.ClientConn) NativeEventsManagementServiceClient {
	return &nativeEventsManagementServiceClient{cc}
}

func (c *nativeEventsManagementServiceClient) ListEvents(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeEventsManagementService/ListEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeEventsManagementServiceClient) UpdateEventsConfiguration(ctx context.Context, in *EventsConfigurationRequest, opts ...grpc.CallOption) (*EventsConfigurationResponse, error) {
	out := new(EventsConfigurationResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeEventsManagementService/UpdateEventsConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NativeEventsManagementServiceServer is the server API for NativeEventsManagementService service.
type NativeEventsManagementServiceServer interface {
	// List the supported events for the passed device
	ListEvents(context.Context, *HardwareID) (*ListEventsResponse, error)
	// Updates the configuration of the list of events in the request
	// The default behavior of the device is to report all the supported events
	// This configuration is persisted across reboots of the device or the device manager
	UpdateEventsConfiguration(context.Context, *EventsConfigurationRequest) (*EventsConfigurationResponse, error)
}

func RegisterNativeEventsManagementServiceServer(s *grpc.Server, srv NativeEventsManagementServiceServer) {
	s.RegisterService(&_NativeEventsManagementService_serviceDesc, srv)
}

func _NativeEventsManagementService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HardwareID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeEventsManagementServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeEventsManagementService/ListEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeEventsManagementServiceServer).ListEvents(ctx, req.(*HardwareID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeEventsManagementService_UpdateEventsConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EventsConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeEventsManagementServiceServer).UpdateEventsConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeEventsManagementService/UpdateEventsConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeEventsManagementServiceServer).UpdateEventsConfiguration(ctx, req.(*EventsConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NativeEventsManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dmi.NativeEventsManagementService",
	HandlerType: (*NativeEventsManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEvents",
			Handler:    _NativeEventsManagementService_ListEvents_Handler,
		},
		{
			MethodName: "UpdateEventsConfiguration",
			Handler:    _NativeEventsManagementService_UpdateEventsConfiguration_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "dmi/hw_events_mgmt_service.proto",
}
