/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// ReCommonAmplifierParametersClassID is the 16-bit ID for the OMCI
// Managed entity RE common amplifier parameters
const ReCommonAmplifierParametersClassID = ClassID(328) // 0x0148

var recommonamplifierparametersBME *ManagedEntityDefinition

// ReCommonAmplifierParameters (Class ID: #328 / 0x0148)
//	This ME organizes data associated with each OA supported by the RE. The management ONU
//	automatically creates one instance of this ME for each upstream or downstream OA.
//
//	Relationships
//		An instance of this ME is associated with an instance of the RE downstream amplifier or RE
//		upstream amplifier ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of an upstream or downstream OA. The first byte is the slot ID
//			(defined in clause 9.1.5). The second byte is the port ID. (R)-(mandatory) (2-bytes)
//
//			NOTE - The type of the linked ME can be determined by uniqueness of slot and port.
//
//		Gain
//			This attribute reports the current measurement of the OA's gain, in decibels. Its value is a 2s
//			complement integer with 0.25-dB granularity, and with a range from -32-dB to 31.5-dB. The value
//			0x7F indicates that the current measured gain is 0, i.e., negative infinity in decibels terms.
//			(R) (optional) (1-byte)
//
//		Lower Gain Threshold
//			This attribute specifies the gain the RE uses to declare the low gain alarm. Valid values are
//			0-dB (coded as 0x00) to 63.5-dB (coded as 0xFE). The default value 0xFF selects the RE's
//			internal policy. (R,-W) (optional) (1-byte)
//
//		Upper Gain Threshold
//			This attribute specifies the gain the RE uses to declare the high gain alarm. Valid values are
//			0-dB (coded as 0x00) to 63.5-dB (coded as 0xFE). The default value 0xFF selects the RE's
//			internal policy. (R,-W) (optional) (1-byte)
//
//		Target Gain
//			This attribute specifies the target gain, when the operational mode of the parent RE downstream
//			or upstream amplifier is set to constant gain mode. Valid values are 0-dB (coded as 0x00) to
//			63.5-dB (coded as 0xFE). The default value 0xFF selects the RE's internal policy. (R,-W)
//			(optional) (1-byte)
//
//		Device Temperature
//			This attribute reports the temperature in degrees Celcius of the active device (SOA or pump) in
//			the OA. Its value is a 2s complement integer with granularity 1/256-degree-C. (R) (optional)
//			(2-bytes)
//
//		Lower Device Temperature Threshold
//			This attribute is a 2s complement integer that specifies the temperature the RE uses to declare
//			the low temperature alarm. Valid values are -64 to +63-degree-C in 0.5-degree-C increments. The
//			default value 0x7F selects the RE's internal policy. (R,-W) (optional) (1-byte)
//
//		Upper Device Temperature Threshold
//			This attribute is a 2s complement integer that specifies the temperature the RE uses to declare
//			the high temperature alarm. Valid values are -64 to +63-degree-C in 0.5-degree-C increments. The
//			default value 0x7F selects the RE's internal policy. (R,-W) (optional) (1-byte)
//
//		Device Bias Current
//			This attribute contains the measured bias current applied to the SOA or pump laser. Its value is
//			an unsigned integer with granularity 2-mA. Valid values are 0 to 512-mA. (R) (optional) (1-byte)
//
//		Amplifier Saturation Output Power
//			This attribute reports the saturation output power of the amplifier as specified by the
//			manufacturer. Its value is an unsigned integer referred to 1-mW (i.e., dBm), with 0.1-dB
//			granularity. (R) (optional) (2-bytes)
//
//		Amplifier Noise Figure
//			This attribute reports the intrinsic noise figure of the amplifier, as specified by the
//			manufacturer. Its value is an unsigned integer with 0.1-dB granularity (R) (optional) (1-byte)
//
//		Amplifier Saturation Gain
//			This attribute reports the gain of the amplifier at saturation, as specified by the
//			manufacturer. Its value is an unsigned integer with 0.25-dB granularity, and with a range from 0
//			to 63.75-dB. (R) (optional) (1-byte)
//
type ReCommonAmplifierParameters struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const ReCommonAmplifierParameters_Gain = "Gain"
const ReCommonAmplifierParameters_LowerGainThreshold = "LowerGainThreshold"
const ReCommonAmplifierParameters_UpperGainThreshold = "UpperGainThreshold"
const ReCommonAmplifierParameters_TargetGain = "TargetGain"
const ReCommonAmplifierParameters_DeviceTemperature = "DeviceTemperature"
const ReCommonAmplifierParameters_LowerDeviceTemperatureThreshold = "LowerDeviceTemperatureThreshold"
const ReCommonAmplifierParameters_UpperDeviceTemperatureThreshold = "UpperDeviceTemperatureThreshold"
const ReCommonAmplifierParameters_DeviceBiasCurrent = "DeviceBiasCurrent"
const ReCommonAmplifierParameters_AmplifierSaturationOutputPower = "AmplifierSaturationOutputPower"
const ReCommonAmplifierParameters_AmplifierNoiseFigure = "AmplifierNoiseFigure"
const ReCommonAmplifierParameters_AmplifierSaturationGain = "AmplifierSaturationGain"

func init() {
	recommonamplifierparametersBME = &ManagedEntityDefinition{
		Name:    "ReCommonAmplifierParameters",
		ClassID: ReCommonAmplifierParametersClassID,
		MessageTypes: mapset.NewSetWith(
			Get,
			Set,
		),
		AllowedAttributeMask: 0xffe0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1:  ByteField(ReCommonAmplifierParameters_Gain, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, true, false, 1),
			2:  ByteField(ReCommonAmplifierParameters_LowerGainThreshold, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, Write), false, true, false, 2),
			3:  ByteField(ReCommonAmplifierParameters_UpperGainThreshold, UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, Write), false, true, false, 3),
			4:  ByteField(ReCommonAmplifierParameters_TargetGain, UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, Write), false, true, false, 4),
			5:  Uint16Field(ReCommonAmplifierParameters_DeviceTemperature, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, true, false, 5),
			6:  ByteField(ReCommonAmplifierParameters_LowerDeviceTemperatureThreshold, UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, Write), false, true, false, 6),
			7:  ByteField(ReCommonAmplifierParameters_UpperDeviceTemperatureThreshold, UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, Write), false, true, false, 7),
			8:  ByteField(ReCommonAmplifierParameters_DeviceBiasCurrent, UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, true, false, 8),
			9:  Uint16Field(ReCommonAmplifierParameters_AmplifierSaturationOutputPower, UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, true, false, 9),
			10: ByteField(ReCommonAmplifierParameters_AmplifierNoiseFigure, UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, true, false, 10),
			11: ByteField(ReCommonAmplifierParameters_AmplifierSaturationGain, UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, true, false, 11),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "Low gain",
			1: "High gain",
			2: "Low temperature",
			3: "High temperature",
			4: "High bias current",
			5: "High temperature shutdown",
			6: "High current shutdown",
		},
	}
}

// NewReCommonAmplifierParameters (class ID 328) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewReCommonAmplifierParameters(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*recommonamplifierparametersBME, params...)
}
