// Code generated by protoc-gen-go. DO NOT EDIT.
// source: dmi/hw.proto

package dmi

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ComponentType int32

const (
	ComponentType_COMPONENT_TYPE_UNDEFINED           ComponentType = 0
	ComponentType_COMPONENT_TYPE_UNKNOWN             ComponentType = 1
	ComponentType_COMPONENT_TYPE_CHASSIS             ComponentType = 2
	ComponentType_COMPONENT_TYPE_BACKPLANE           ComponentType = 3
	ComponentType_COMPONENT_TYPE_CONTAINER           ComponentType = 4
	ComponentType_COMPONENT_TYPE_POWER_SUPPLY        ComponentType = 5
	ComponentType_COMPONENT_TYPE_FAN                 ComponentType = 6
	ComponentType_COMPONENT_TYPE_SENSOR              ComponentType = 7
	ComponentType_COMPONENT_TYPE_MODULE              ComponentType = 8
	ComponentType_COMPONENT_TYPE_PORT                ComponentType = 9
	ComponentType_COMPONENT_TYPE_CPU                 ComponentType = 10
	ComponentType_COMPONENT_TYPE_BATTERY             ComponentType = 11
	ComponentType_COMPONENT_TYPE_STORAGE             ComponentType = 12
	ComponentType_COMPONENT_TYPE_MEMORY              ComponentType = 13
	ComponentType_COMPONENT_TYPE_TRANSCEIVER         ComponentType = 14
	ComponentType_COMPONENT_TYPE_GPON_TRANSCEIVER    ComponentType = 15
	ComponentType_COMPONENT_TYPE_XGS_PON_TRANSCEIVER ComponentType = 16
)

var ComponentType_name = map[int32]string{
	0:  "COMPONENT_TYPE_UNDEFINED",
	1:  "COMPONENT_TYPE_UNKNOWN",
	2:  "COMPONENT_TYPE_CHASSIS",
	3:  "COMPONENT_TYPE_BACKPLANE",
	4:  "COMPONENT_TYPE_CONTAINER",
	5:  "COMPONENT_TYPE_POWER_SUPPLY",
	6:  "COMPONENT_TYPE_FAN",
	7:  "COMPONENT_TYPE_SENSOR",
	8:  "COMPONENT_TYPE_MODULE",
	9:  "COMPONENT_TYPE_PORT",
	10: "COMPONENT_TYPE_CPU",
	11: "COMPONENT_TYPE_BATTERY",
	12: "COMPONENT_TYPE_STORAGE",
	13: "COMPONENT_TYPE_MEMORY",
	14: "COMPONENT_TYPE_TRANSCEIVER",
	15: "COMPONENT_TYPE_GPON_TRANSCEIVER",
	16: "COMPONENT_TYPE_XGS_PON_TRANSCEIVER",
}

var ComponentType_value = map[string]int32{
	"COMPONENT_TYPE_UNDEFINED":           0,
	"COMPONENT_TYPE_UNKNOWN":             1,
	"COMPONENT_TYPE_CHASSIS":             2,
	"COMPONENT_TYPE_BACKPLANE":           3,
	"COMPONENT_TYPE_CONTAINER":           4,
	"COMPONENT_TYPE_POWER_SUPPLY":        5,
	"COMPONENT_TYPE_FAN":                 6,
	"COMPONENT_TYPE_SENSOR":              7,
	"COMPONENT_TYPE_MODULE":              8,
	"COMPONENT_TYPE_PORT":                9,
	"COMPONENT_TYPE_CPU":                 10,
	"COMPONENT_TYPE_BATTERY":             11,
	"COMPONENT_TYPE_STORAGE":             12,
	"COMPONENT_TYPE_MEMORY":              13,
	"COMPONENT_TYPE_TRANSCEIVER":         14,
	"COMPONENT_TYPE_GPON_TRANSCEIVER":    15,
	"COMPONENT_TYPE_XGS_PON_TRANSCEIVER": 16,
}

func (x ComponentType) String() string {
	return proto.EnumName(ComponentType_name, int32(x))
}

func (ComponentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{0}
}

type ComponentAdminState int32

const (
	ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED     ComponentAdminState = 0
	ComponentAdminState_COMP_ADMIN_STATE_UNKNOWN       ComponentAdminState = 1
	ComponentAdminState_COMP_ADMIN_STATE_LOCKED        ComponentAdminState = 2
	ComponentAdminState_COMP_ADMIN_STATE_SHUTTING_DOWN ComponentAdminState = 3
	ComponentAdminState_COMP_ADMIN_STATE_UNLOCKED      ComponentAdminState = 4
)

var ComponentAdminState_name = map[int32]string{
	0: "COMP_ADMIN_STATE_UNDEFINED",
	1: "COMP_ADMIN_STATE_UNKNOWN",
	2: "COMP_ADMIN_STATE_LOCKED",
	3: "COMP_ADMIN_STATE_SHUTTING_DOWN",
	4: "COMP_ADMIN_STATE_UNLOCKED",
}

var ComponentAdminState_value = map[string]int32{
	"COMP_ADMIN_STATE_UNDEFINED":     0,
	"COMP_ADMIN_STATE_UNKNOWN":       1,
	"COMP_ADMIN_STATE_LOCKED":        2,
	"COMP_ADMIN_STATE_SHUTTING_DOWN": 3,
	"COMP_ADMIN_STATE_UNLOCKED":      4,
}

func (x ComponentAdminState) String() string {
	return proto.EnumName(ComponentAdminState_name, int32(x))
}

func (ComponentAdminState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{1}
}

type ComponentOperState int32

const (
	ComponentOperState_COMP_OPER_STATE_UNDEFINED ComponentOperState = 0
	ComponentOperState_COMP_OPER_STATE_UNKNOWN   ComponentOperState = 1
	ComponentOperState_COMP_OPER_STATE_DISABLED  ComponentOperState = 2
	ComponentOperState_COMP_OPER_STATE_ENABLED   ComponentOperState = 3
	ComponentOperState_COMP_OPER_STATE_TESTING   ComponentOperState = 4
)

var ComponentOperState_name = map[int32]string{
	0: "COMP_OPER_STATE_UNDEFINED",
	1: "COMP_OPER_STATE_UNKNOWN",
	2: "COMP_OPER_STATE_DISABLED",
	3: "COMP_OPER_STATE_ENABLED",
	4: "COMP_OPER_STATE_TESTING",
}

var ComponentOperState_value = map[string]int32{
	"COMP_OPER_STATE_UNDEFINED": 0,
	"COMP_OPER_STATE_UNKNOWN":   1,
	"COMP_OPER_STATE_DISABLED":  2,
	"COMP_OPER_STATE_ENABLED":   3,
	"COMP_OPER_STATE_TESTING":   4,
}

func (x ComponentOperState) String() string {
	return proto.EnumName(ComponentOperState_name, int32(x))
}

func (ComponentOperState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{2}
}

type ComponentUsageState int32

const (
	ComponentUsageState_COMP_USAGE_STATE_UNDEFINED ComponentUsageState = 0
	ComponentUsageState_COMP_USAGE_STATE_UNKNOWN   ComponentUsageState = 1
	ComponentUsageState_COMP_USAGE_STATE_IDLE      ComponentUsageState = 2
	ComponentUsageState_COMP_USAGE_STATE_ACTIVE    ComponentUsageState = 3
	ComponentUsageState_COMP_USAGE_STATE_BUSY      ComponentUsageState = 4
)

var ComponentUsageState_name = map[int32]string{
	0: "COMP_USAGE_STATE_UNDEFINED",
	1: "COMP_USAGE_STATE_UNKNOWN",
	2: "COMP_USAGE_STATE_IDLE",
	3: "COMP_USAGE_STATE_ACTIVE",
	4: "COMP_USAGE_STATE_BUSY",
}

var ComponentUsageState_value = map[string]int32{
	"COMP_USAGE_STATE_UNDEFINED": 0,
	"COMP_USAGE_STATE_UNKNOWN":   1,
	"COMP_USAGE_STATE_IDLE":      2,
	"COMP_USAGE_STATE_ACTIVE":    3,
	"COMP_USAGE_STATE_BUSY":      4,
}

func (x ComponentUsageState) String() string {
	return proto.EnumName(ComponentUsageState_name, int32(x))
}

func (ComponentUsageState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{3}
}

type ComponentAlarmState int32

const (
	ComponentAlarmState_COMP_ALARM_STATE_UNDEFINED    ComponentAlarmState = 0
	ComponentAlarmState_COMP_ALARM_STATE_UNKNOWN      ComponentAlarmState = 1
	ComponentAlarmState_COMP_ALARM_STATE_UNDER_REPAIR ComponentAlarmState = 2
	ComponentAlarmState_COMP_ALARM_STATE_CRITICAL     ComponentAlarmState = 3
	ComponentAlarmState_COMP_ALARM_STATE_MAJOR        ComponentAlarmState = 4
	ComponentAlarmState_COMP_ALARM_STATE_MINOR        ComponentAlarmState = 5
	ComponentAlarmState_COMP_ALARM_STATE_WARNING      ComponentAlarmState = 6
	ComponentAlarmState_COMP_ALARM_STATE_INTERMEDIATE ComponentAlarmState = 7
)

var ComponentAlarmState_name = map[int32]string{
	0: "COMP_ALARM_STATE_UNDEFINED",
	1: "COMP_ALARM_STATE_UNKNOWN",
	2: "COMP_ALARM_STATE_UNDER_REPAIR",
	3: "COMP_ALARM_STATE_CRITICAL",
	4: "COMP_ALARM_STATE_MAJOR",
	5: "COMP_ALARM_STATE_MINOR",
	6: "COMP_ALARM_STATE_WARNING",
	7: "COMP_ALARM_STATE_INTERMEDIATE",
}

var ComponentAlarmState_value = map[string]int32{
	"COMP_ALARM_STATE_UNDEFINED":    0,
	"COMP_ALARM_STATE_UNKNOWN":      1,
	"COMP_ALARM_STATE_UNDER_REPAIR": 2,
	"COMP_ALARM_STATE_CRITICAL":     3,
	"COMP_ALARM_STATE_MAJOR":        4,
	"COMP_ALARM_STATE_MINOR":        5,
	"COMP_ALARM_STATE_WARNING":      6,
	"COMP_ALARM_STATE_INTERMEDIATE": 7,
}

func (x ComponentAlarmState) String() string {
	return proto.EnumName(ComponentAlarmState_name, int32(x))
}

func (ComponentAlarmState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{4}
}

type ComponentStandbyState int32

const (
	ComponentStandbyState_COMP_STANDBY_STATE_UNDEFINED         ComponentStandbyState = 0
	ComponentStandbyState_COMP_STANDBY_STATE_UNKNOWN           ComponentStandbyState = 1
	ComponentStandbyState_COMP_STANDBY_STATE_HOT               ComponentStandbyState = 2
	ComponentStandbyState_COMP_STANDBY_STATE_COLD              ComponentStandbyState = 3
	ComponentStandbyState_COMP_STANDBY_STATE_PROVIDING_SERVICE ComponentStandbyState = 4
)

var ComponentStandbyState_name = map[int32]string{
	0: "COMP_STANDBY_STATE_UNDEFINED",
	1: "COMP_STANDBY_STATE_UNKNOWN",
	2: "COMP_STANDBY_STATE_HOT",
	3: "COMP_STANDBY_STATE_COLD",
	4: "COMP_STANDBY_STATE_PROVIDING_SERVICE",
}

var ComponentStandbyState_value = map[string]int32{
	"COMP_STANDBY_STATE_UNDEFINED":         0,
	"COMP_STANDBY_STATE_UNKNOWN":           1,
	"COMP_STANDBY_STATE_HOT":               2,
	"COMP_STANDBY_STATE_COLD":              3,
	"COMP_STANDBY_STATE_PROVIDING_SERVICE": 4,
}

func (x ComponentStandbyState) String() string {
	return proto.EnumName(ComponentStandbyState_name, int32(x))
}

func (ComponentStandbyState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5}
}

type SensorValueType int32

const (
	SensorValueType_SENSOR_VALUE_TYPE_UNDEFINED   SensorValueType = 0
	SensorValueType_SENSOR_VALUE_TYPE_OTHER       SensorValueType = 1
	SensorValueType_SENSOR_VALUE_TYPE_UNKNOWN     SensorValueType = 2
	SensorValueType_SENSOR_VALUE_TYPE_VOLTS_AC    SensorValueType = 3
	SensorValueType_SENSOR_VALUE_TYPE_VOLTS_DC    SensorValueType = 4
	SensorValueType_SENSOR_VALUE_TYPE_AMPERES     SensorValueType = 5
	SensorValueType_SENSOR_VALUE_TYPE_WATTS       SensorValueType = 6
	SensorValueType_SENSOR_VALUE_TYPE_HERTZ       SensorValueType = 7
	SensorValueType_SENSOR_VALUE_TYPE_CELSIUS     SensorValueType = 8
	SensorValueType_SENSOR_VALUE_TYPE_PERCENT_RH  SensorValueType = 9
	SensorValueType_SENSOR_VALUE_TYPE_RPM         SensorValueType = 10
	SensorValueType_SENSOR_VALUE_TYPE_CMM         SensorValueType = 11
	SensorValueType_SENSOR_VALUE_TYPE_TRUTH_VALUE SensorValueType = 12
)

var SensorValueType_name = map[int32]string{
	0:  "SENSOR_VALUE_TYPE_UNDEFINED",
	1:  "SENSOR_VALUE_TYPE_OTHER",
	2:  "SENSOR_VALUE_TYPE_UNKNOWN",
	3:  "SENSOR_VALUE_TYPE_VOLTS_AC",
	4:  "SENSOR_VALUE_TYPE_VOLTS_DC",
	5:  "SENSOR_VALUE_TYPE_AMPERES",
	6:  "SENSOR_VALUE_TYPE_WATTS",
	7:  "SENSOR_VALUE_TYPE_HERTZ",
	8:  "SENSOR_VALUE_TYPE_CELSIUS",
	9:  "SENSOR_VALUE_TYPE_PERCENT_RH",
	10: "SENSOR_VALUE_TYPE_RPM",
	11: "SENSOR_VALUE_TYPE_CMM",
	12: "SENSOR_VALUE_TYPE_TRUTH_VALUE",
}

var SensorValueType_value = map[string]int32{
	"SENSOR_VALUE_TYPE_UNDEFINED":   0,
	"SENSOR_VALUE_TYPE_OTHER":       1,
	"SENSOR_VALUE_TYPE_UNKNOWN":     2,
	"SENSOR_VALUE_TYPE_VOLTS_AC":    3,
	"SENSOR_VALUE_TYPE_VOLTS_DC":    4,
	"SENSOR_VALUE_TYPE_AMPERES":     5,
	"SENSOR_VALUE_TYPE_WATTS":       6,
	"SENSOR_VALUE_TYPE_HERTZ":       7,
	"SENSOR_VALUE_TYPE_CELSIUS":     8,
	"SENSOR_VALUE_TYPE_PERCENT_RH":  9,
	"SENSOR_VALUE_TYPE_RPM":         10,
	"SENSOR_VALUE_TYPE_CMM":         11,
	"SENSOR_VALUE_TYPE_TRUTH_VALUE": 12,
}

func (x SensorValueType) String() string {
	return proto.EnumName(SensorValueType_name, int32(x))
}

func (SensorValueType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{6}
}

type SensorValueScale int32

const (
	SensorValueScale_SENSOR_VALUE_SCALE_UNDEFINED SensorValueScale = 0
	SensorValueScale_SENSOR_VALUE_SCALE_YOCTO     SensorValueScale = 1
	SensorValueScale_SENSOR_VALUE_SCALE_ZEPTO     SensorValueScale = 2
	SensorValueScale_SENSOR_VALUE_SCALE_ATTO      SensorValueScale = 3
	SensorValueScale_SENSOR_VALUE_SCALE_FEMTO     SensorValueScale = 4
	SensorValueScale_SENSOR_VALUE_SCALE_PICO      SensorValueScale = 5
	SensorValueScale_SENSOR_VALUE_SCALE_NANO      SensorValueScale = 6
	SensorValueScale_SENSOR_VALUE_SCALE_MICRO     SensorValueScale = 7
	SensorValueScale_SENSOR_VALUE_SCALE_MILLI     SensorValueScale = 8
	SensorValueScale_SENSOR_VALUE_SCALE_UNITS     SensorValueScale = 9
	SensorValueScale_SENSOR_VALUE_SCALE_KILO      SensorValueScale = 10
	SensorValueScale_SENSOR_VALUE_SCALE_MEGA      SensorValueScale = 11
	SensorValueScale_SENSOR_VALUE_SCALE_GIGA      SensorValueScale = 12
	SensorValueScale_SENSOR_VALUE_SCALE_TERA      SensorValueScale = 13
	SensorValueScale_SENSOR_VALUE_SCALE_PETA      SensorValueScale = 14
	SensorValueScale_SENSOR_VALUE_SCALE_EXA       SensorValueScale = 15
	SensorValueScale_SENSOR_VALUE_SCALE_ZETTA     SensorValueScale = 16
	SensorValueScale_SENSOR_VALUE_SCALE_YOTTA     SensorValueScale = 17
)

var SensorValueScale_name = map[int32]string{
	0:  "SENSOR_VALUE_SCALE_UNDEFINED",
	1:  "SENSOR_VALUE_SCALE_YOCTO",
	2:  "SENSOR_VALUE_SCALE_ZEPTO",
	3:  "SENSOR_VALUE_SCALE_ATTO",
	4:  "SENSOR_VALUE_SCALE_FEMTO",
	5:  "SENSOR_VALUE_SCALE_PICO",
	6:  "SENSOR_VALUE_SCALE_NANO",
	7:  "SENSOR_VALUE_SCALE_MICRO",
	8:  "SENSOR_VALUE_SCALE_MILLI",
	9:  "SENSOR_VALUE_SCALE_UNITS",
	10: "SENSOR_VALUE_SCALE_KILO",
	11: "SENSOR_VALUE_SCALE_MEGA",
	12: "SENSOR_VALUE_SCALE_GIGA",
	13: "SENSOR_VALUE_SCALE_TERA",
	14: "SENSOR_VALUE_SCALE_PETA",
	15: "SENSOR_VALUE_SCALE_EXA",
	16: "SENSOR_VALUE_SCALE_ZETTA",
	17: "SENSOR_VALUE_SCALE_YOTTA",
}

var SensorValueScale_value = map[string]int32{
	"SENSOR_VALUE_SCALE_UNDEFINED": 0,
	"SENSOR_VALUE_SCALE_YOCTO":     1,
	"SENSOR_VALUE_SCALE_ZEPTO":     2,
	"SENSOR_VALUE_SCALE_ATTO":      3,
	"SENSOR_VALUE_SCALE_FEMTO":     4,
	"SENSOR_VALUE_SCALE_PICO":      5,
	"SENSOR_VALUE_SCALE_NANO":      6,
	"SENSOR_VALUE_SCALE_MICRO":     7,
	"SENSOR_VALUE_SCALE_MILLI":     8,
	"SENSOR_VALUE_SCALE_UNITS":     9,
	"SENSOR_VALUE_SCALE_KILO":      10,
	"SENSOR_VALUE_SCALE_MEGA":      11,
	"SENSOR_VALUE_SCALE_GIGA":      12,
	"SENSOR_VALUE_SCALE_TERA":      13,
	"SENSOR_VALUE_SCALE_PETA":      14,
	"SENSOR_VALUE_SCALE_EXA":       15,
	"SENSOR_VALUE_SCALE_ZETTA":     16,
	"SENSOR_VALUE_SCALE_YOTTA":     17,
}

func (x SensorValueScale) String() string {
	return proto.EnumName(SensorValueScale_name, int32(x))
}

func (SensorValueScale) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{7}
}

type SensorStatus int32

const (
	SensorStatus_SENSOR_STATUS_UNDEFINED      SensorStatus = 0
	SensorStatus_SENSOR_STATUS_OK             SensorStatus = 1
	SensorStatus_SENSOR_STATUS_UNAVAILABLE    SensorStatus = 2
	SensorStatus_SENSOR_STATUS_NONOPERATIONAL SensorStatus = 3
)

var SensorStatus_name = map[int32]string{
	0: "SENSOR_STATUS_UNDEFINED",
	1: "SENSOR_STATUS_OK",
	2: "SENSOR_STATUS_UNAVAILABLE",
	3: "SENSOR_STATUS_NONOPERATIONAL",
}

var SensorStatus_value = map[string]int32{
	"SENSOR_STATUS_UNDEFINED":      0,
	"SENSOR_STATUS_OK":             1,
	"SENSOR_STATUS_UNAVAILABLE":    2,
	"SENSOR_STATUS_NONOPERATIONAL": 3,
}

func (x SensorStatus) String() string {
	return proto.EnumName(SensorStatus_name, int32(x))
}

func (SensorStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{8}
}

type Uuid struct {
	Uuid                 string   `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Uuid) Reset()         { *m = Uuid{} }
func (m *Uuid) String() string { return proto.CompactTextString(m) }
func (*Uuid) ProtoMessage()    {}
func (*Uuid) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{0}
}

func (m *Uuid) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Uuid.Unmarshal(m, b)
}
func (m *Uuid) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Uuid.Marshal(b, m, deterministic)
}
func (m *Uuid) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Uuid.Merge(m, src)
}
func (m *Uuid) XXX_Size() int {
	return xxx_messageInfo_Uuid.Size(m)
}
func (m *Uuid) XXX_DiscardUnknown() {
	xxx_messageInfo_Uuid.DiscardUnknown(m)
}

var xxx_messageInfo_Uuid proto.InternalMessageInfo

func (m *Uuid) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

type HardwareID struct {
	Uuid                 *Uuid    `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HardwareID) Reset()         { *m = HardwareID{} }
func (m *HardwareID) String() string { return proto.CompactTextString(m) }
func (*HardwareID) ProtoMessage()    {}
func (*HardwareID) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{1}
}

func (m *HardwareID) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HardwareID.Unmarshal(m, b)
}
func (m *HardwareID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HardwareID.Marshal(b, m, deterministic)
}
func (m *HardwareID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HardwareID.Merge(m, src)
}
func (m *HardwareID) XXX_Size() int {
	return xxx_messageInfo_HardwareID.Size(m)
}
func (m *HardwareID) XXX_DiscardUnknown() {
	xxx_messageInfo_HardwareID.DiscardUnknown(m)
}

var xxx_messageInfo_HardwareID proto.InternalMessageInfo

func (m *HardwareID) GetUuid() *Uuid {
	if m != nil {
		return m.Uuid
	}
	return nil
}

type Uri struct {
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Uri) Reset()         { *m = Uri{} }
func (m *Uri) String() string { return proto.CompactTextString(m) }
func (*Uri) ProtoMessage()    {}
func (*Uri) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{2}
}

func (m *Uri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Uri.Unmarshal(m, b)
}
func (m *Uri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Uri.Marshal(b, m, deterministic)
}
func (m *Uri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Uri.Merge(m, src)
}
func (m *Uri) XXX_Size() int {
	return xxx_messageInfo_Uri.Size(m)
}
func (m *Uri) XXX_DiscardUnknown() {
	xxx_messageInfo_Uri.DiscardUnknown(m)
}

var xxx_messageInfo_Uri proto.InternalMessageInfo

func (m *Uri) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

type ComponentState struct {
	StateLastChanged     *timestamp.Timestamp  `protobuf:"bytes,1,opt,name=state_last_changed,json=stateLastChanged,proto3" json:"state_last_changed,omitempty"`
	AdminState           ComponentAdminState   `protobuf:"varint,2,opt,name=admin_state,json=adminState,proto3,enum=dmi.ComponentAdminState" json:"admin_state,omitempty"`
	OperState            ComponentOperState    `protobuf:"varint,3,opt,name=oper_state,json=operState,proto3,enum=dmi.ComponentOperState" json:"oper_state,omitempty"`
	UsageState           ComponentUsageState   `protobuf:"varint,4,opt,name=usage_state,json=usageState,proto3,enum=dmi.ComponentUsageState" json:"usage_state,omitempty"`
	AlarmState           ComponentAlarmState   `protobuf:"varint,5,opt,name=alarm_state,json=alarmState,proto3,enum=dmi.ComponentAlarmState" json:"alarm_state,omitempty"`
	StandbyState         ComponentStandbyState `protobuf:"varint,6,opt,name=standby_state,json=standbyState,proto3,enum=dmi.ComponentStandbyState" json:"standby_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ComponentState) Reset()         { *m = ComponentState{} }
func (m *ComponentState) String() string { return proto.CompactTextString(m) }
func (*ComponentState) ProtoMessage()    {}
func (*ComponentState) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{3}
}

func (m *ComponentState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComponentState.Unmarshal(m, b)
}
func (m *ComponentState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComponentState.Marshal(b, m, deterministic)
}
func (m *ComponentState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentState.Merge(m, src)
}
func (m *ComponentState) XXX_Size() int {
	return xxx_messageInfo_ComponentState.Size(m)
}
func (m *ComponentState) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentState.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentState proto.InternalMessageInfo

func (m *ComponentState) GetStateLastChanged() *timestamp.Timestamp {
	if m != nil {
		return m.StateLastChanged
	}
	return nil
}

func (m *ComponentState) GetAdminState() ComponentAdminState {
	if m != nil {
		return m.AdminState
	}
	return ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED
}

func (m *ComponentState) GetOperState() ComponentOperState {
	if m != nil {
		return m.OperState
	}
	return ComponentOperState_COMP_OPER_STATE_UNDEFINED
}

func (m *ComponentState) GetUsageState() ComponentUsageState {
	if m != nil {
		return m.UsageState
	}
	return ComponentUsageState_COMP_USAGE_STATE_UNDEFINED
}

func (m *ComponentState) GetAlarmState() ComponentAlarmState {
	if m != nil {
		return m.AlarmState
	}
	return ComponentAlarmState_COMP_ALARM_STATE_UNDEFINED
}

func (m *ComponentState) GetStandbyState() ComponentStandbyState {
	if m != nil {
		return m.StandbyState
	}
	return ComponentStandbyState_COMP_STANDBY_STATE_UNDEFINED
}

type ComponentSensorData struct {
	Value           int32                `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Type            SensorValueType      `protobuf:"varint,2,opt,name=type,proto3,enum=dmi.SensorValueType" json:"type,omitempty"`
	Scale           SensorValueScale     `protobuf:"varint,3,opt,name=scale,proto3,enum=dmi.SensorValueScale" json:"scale,omitempty"`
	Precision       int32                `protobuf:"varint,4,opt,name=precision,proto3" json:"precision,omitempty"`
	Status          SensorStatus         `protobuf:"varint,5,opt,name=status,proto3,enum=dmi.SensorStatus" json:"status,omitempty"`
	UnitsDisplay    string               `protobuf:"bytes,6,opt,name=units_display,json=unitsDisplay,proto3" json:"units_display,omitempty"`
	Timestamp       *timestamp.Timestamp `protobuf:"bytes,7,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	ValueUpdateRate uint32               `protobuf:"varint,8,opt,name=value_update_rate,json=valueUpdateRate,proto3" json:"value_update_rate,omitempty"`
	// data_type can be of the string representation of MetricNames or something else as well
	DataType             string   `protobuf:"bytes,9,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComponentSensorData) Reset()         { *m = ComponentSensorData{} }
func (m *ComponentSensorData) String() string { return proto.CompactTextString(m) }
func (*ComponentSensorData) ProtoMessage()    {}
func (*ComponentSensorData) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{4}
}

func (m *ComponentSensorData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComponentSensorData.Unmarshal(m, b)
}
func (m *ComponentSensorData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComponentSensorData.Marshal(b, m, deterministic)
}
func (m *ComponentSensorData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComponentSensorData.Merge(m, src)
}
func (m *ComponentSensorData) XXX_Size() int {
	return xxx_messageInfo_ComponentSensorData.Size(m)
}
func (m *ComponentSensorData) XXX_DiscardUnknown() {
	xxx_messageInfo_ComponentSensorData.DiscardUnknown(m)
}

var xxx_messageInfo_ComponentSensorData proto.InternalMessageInfo

func (m *ComponentSensorData) GetValue() int32 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *ComponentSensorData) GetType() SensorValueType {
	if m != nil {
		return m.Type
	}
	return SensorValueType_SENSOR_VALUE_TYPE_UNDEFINED
}

func (m *ComponentSensorData) GetScale() SensorValueScale {
	if m != nil {
		return m.Scale
	}
	return SensorValueScale_SENSOR_VALUE_SCALE_UNDEFINED
}

func (m *ComponentSensorData) GetPrecision() int32 {
	if m != nil {
		return m.Precision
	}
	return 0
}

func (m *ComponentSensorData) GetStatus() SensorStatus {
	if m != nil {
		return m.Status
	}
	return SensorStatus_SENSOR_STATUS_UNDEFINED
}

func (m *ComponentSensorData) GetUnitsDisplay() string {
	if m != nil {
		return m.UnitsDisplay
	}
	return ""
}

func (m *ComponentSensorData) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *ComponentSensorData) GetValueUpdateRate() uint32 {
	if m != nil {
		return m.ValueUpdateRate
	}
	return 0
}

func (m *ComponentSensorData) GetDataType() string {
	if m != nil {
		return m.DataType
	}
	return ""
}

type Component struct {
	// The name of a component uniquely identifies an component within the Hardware
	Name        string        `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Class       ComponentType `protobuf:"varint,2,opt,name=class,proto3,enum=dmi.ComponentType" json:"class,omitempty"`
	Description string        `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The name of the parent of this component, empty "" in case of the root component
	Parent       string               `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	ParentRelPos int32                `protobuf:"varint,5,opt,name=parent_rel_pos,json=parentRelPos,proto3" json:"parent_rel_pos,omitempty"`
	Children     []*Component         `protobuf:"bytes,6,rep,name=children,proto3" json:"children,omitempty"`
	HardwareRev  string               `protobuf:"bytes,7,opt,name=hardware_rev,json=hardwareRev,proto3" json:"hardware_rev,omitempty"`
	FirmwareRev  string               `protobuf:"bytes,8,opt,name=firmware_rev,json=firmwareRev,proto3" json:"firmware_rev,omitempty"`
	SoftwareRev  string               `protobuf:"bytes,9,opt,name=software_rev,json=softwareRev,proto3" json:"software_rev,omitempty"`
	SerialNum    string               `protobuf:"bytes,10,opt,name=serial_num,json=serialNum,proto3" json:"serial_num,omitempty"`
	MfgName      string               `protobuf:"bytes,11,opt,name=mfg_name,json=mfgName,proto3" json:"mfg_name,omitempty"`
	ModelName    string               `protobuf:"bytes,12,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	Alias        string               `protobuf:"bytes,13,opt,name=alias,proto3" json:"alias,omitempty"`
	AssetId      string               `protobuf:"bytes,14,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	IsFru        bool                 `protobuf:"varint,15,opt,name=is_fru,json=isFru,proto3" json:"is_fru,omitempty"`
	MfgDate      *timestamp.Timestamp `protobuf:"bytes,16,opt,name=mfg_date,json=mfgDate,proto3" json:"mfg_date,omitempty"`
	Uri          *Uri                 `protobuf:"bytes,17,opt,name=uri,proto3" json:"uri,omitempty"`
	// The uuid of the component uniquely identifies the component across the entire system
	Uuid                 *Uuid                  `protobuf:"bytes,18,opt,name=uuid,proto3" json:"uuid,omitempty"`
	State                *ComponentState        `protobuf:"bytes,19,opt,name=state,proto3" json:"state,omitempty"`
	SensorData           []*ComponentSensorData `protobuf:"bytes,20,rep,name=sensor_data,json=sensorData,proto3" json:"sensor_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Component) Reset()         { *m = Component{} }
func (m *Component) String() string { return proto.CompactTextString(m) }
func (*Component) ProtoMessage()    {}
func (*Component) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{5}
}

func (m *Component) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Component.Unmarshal(m, b)
}
func (m *Component) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Component.Marshal(b, m, deterministic)
}
func (m *Component) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Component.Merge(m, src)
}
func (m *Component) XXX_Size() int {
	return xxx_messageInfo_Component.Size(m)
}
func (m *Component) XXX_DiscardUnknown() {
	xxx_messageInfo_Component.DiscardUnknown(m)
}

var xxx_messageInfo_Component proto.InternalMessageInfo

func (m *Component) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Component) GetClass() ComponentType {
	if m != nil {
		return m.Class
	}
	return ComponentType_COMPONENT_TYPE_UNDEFINED
}

func (m *Component) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Component) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Component) GetParentRelPos() int32 {
	if m != nil {
		return m.ParentRelPos
	}
	return 0
}

func (m *Component) GetChildren() []*Component {
	if m != nil {
		return m.Children
	}
	return nil
}

func (m *Component) GetHardwareRev() string {
	if m != nil {
		return m.HardwareRev
	}
	return ""
}

func (m *Component) GetFirmwareRev() string {
	if m != nil {
		return m.FirmwareRev
	}
	return ""
}

func (m *Component) GetSoftwareRev() string {
	if m != nil {
		return m.SoftwareRev
	}
	return ""
}

func (m *Component) GetSerialNum() string {
	if m != nil {
		return m.SerialNum
	}
	return ""
}

func (m *Component) GetMfgName() string {
	if m != nil {
		return m.MfgName
	}
	return ""
}

func (m *Component) GetModelName() string {
	if m != nil {
		return m.ModelName
	}
	return ""
}

func (m *Component) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *Component) GetAssetId() string {
	if m != nil {
		return m.AssetId
	}
	return ""
}

func (m *Component) GetIsFru() bool {
	if m != nil {
		return m.IsFru
	}
	return false
}

func (m *Component) GetMfgDate() *timestamp.Timestamp {
	if m != nil {
		return m.MfgDate
	}
	return nil
}

func (m *Component) GetUri() *Uri {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (m *Component) GetUuid() *Uuid {
	if m != nil {
		return m.Uuid
	}
	return nil
}

func (m *Component) GetState() *ComponentState {
	if m != nil {
		return m.State
	}
	return nil
}

func (m *Component) GetSensorData() []*ComponentSensorData {
	if m != nil {
		return m.SensorData
	}
	return nil
}

type Hardware struct {
	LastChange *timestamp.Timestamp `protobuf:"bytes,1,opt,name=last_change,json=lastChange,proto3" json:"last_change,omitempty"`
	// Each HW has one parent/root and all other components are children of this
	// The class of the root component would be set as UNDEFINED
	Root                 *Component `protobuf:"bytes,2,opt,name=root,proto3" json:"root,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Hardware) Reset()         { *m = Hardware{} }
func (m *Hardware) String() string { return proto.CompactTextString(m) }
func (*Hardware) ProtoMessage()    {}
func (*Hardware) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{6}
}

func (m *Hardware) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Hardware.Unmarshal(m, b)
}
func (m *Hardware) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Hardware.Marshal(b, m, deterministic)
}
func (m *Hardware) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Hardware.Merge(m, src)
}
func (m *Hardware) XXX_Size() int {
	return xxx_messageInfo_Hardware.Size(m)
}
func (m *Hardware) XXX_DiscardUnknown() {
	xxx_messageInfo_Hardware.DiscardUnknown(m)
}

var xxx_messageInfo_Hardware proto.InternalMessageInfo

func (m *Hardware) GetLastChange() *timestamp.Timestamp {
	if m != nil {
		return m.LastChange
	}
	return nil
}

func (m *Hardware) GetRoot() *Component {
	if m != nil {
		return m.Root
	}
	return nil
}

// The attributes of a component which are modifiable from the client side
type ModifiableComponent struct {
	// The name has to be unique for each component within the hardware and implementations need to
	// ascertain this when modifying the name
	Name                 string              `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Class                ComponentType       `protobuf:"varint,2,opt,name=class,proto3,enum=dmi.ComponentType" json:"class,omitempty"`
	Parent               *Component          `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	ParentRelPos         int32               `protobuf:"varint,4,opt,name=parent_rel_pos,json=parentRelPos,proto3" json:"parent_rel_pos,omitempty"`
	Alias                string              `protobuf:"bytes,5,opt,name=alias,proto3" json:"alias,omitempty"`
	AssetId              string              `protobuf:"bytes,6,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	Uri                  *Uri                `protobuf:"bytes,7,opt,name=uri,proto3" json:"uri,omitempty"`
	AdminState           ComponentAdminState `protobuf:"varint,8,opt,name=admin_state,json=adminState,proto3,enum=dmi.ComponentAdminState" json:"admin_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ModifiableComponent) Reset()         { *m = ModifiableComponent{} }
func (m *ModifiableComponent) String() string { return proto.CompactTextString(m) }
func (*ModifiableComponent) ProtoMessage()    {}
func (*ModifiableComponent) Descriptor() ([]byte, []int) {
	return fileDescriptor_d7c33d745c4ab367, []int{7}
}

func (m *ModifiableComponent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ModifiableComponent.Unmarshal(m, b)
}
func (m *ModifiableComponent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ModifiableComponent.Marshal(b, m, deterministic)
}
func (m *ModifiableComponent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ModifiableComponent.Merge(m, src)
}
func (m *ModifiableComponent) XXX_Size() int {
	return xxx_messageInfo_ModifiableComponent.Size(m)
}
func (m *ModifiableComponent) XXX_DiscardUnknown() {
	xxx_messageInfo_ModifiableComponent.DiscardUnknown(m)
}

var xxx_messageInfo_ModifiableComponent proto.InternalMessageInfo

func (m *ModifiableComponent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ModifiableComponent) GetClass() ComponentType {
	if m != nil {
		return m.Class
	}
	return ComponentType_COMPONENT_TYPE_UNDEFINED
}

func (m *ModifiableComponent) GetParent() *Component {
	if m != nil {
		return m.Parent
	}
	return nil
}

func (m *ModifiableComponent) GetParentRelPos() int32 {
	if m != nil {
		return m.ParentRelPos
	}
	return 0
}

func (m *ModifiableComponent) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *ModifiableComponent) GetAssetId() string {
	if m != nil {
		return m.AssetId
	}
	return ""
}

func (m *ModifiableComponent) GetUri() *Uri {
	if m != nil {
		return m.Uri
	}
	return nil
}

func (m *ModifiableComponent) GetAdminState() ComponentAdminState {
	if m != nil {
		return m.AdminState
	}
	return ComponentAdminState_COMP_ADMIN_STATE_UNDEFINED
}

func init() {
	proto.RegisterEnum("dmi.ComponentType", ComponentType_name, ComponentType_value)
	proto.RegisterEnum("dmi.ComponentAdminState", ComponentAdminState_name, ComponentAdminState_value)
	proto.RegisterEnum("dmi.ComponentOperState", ComponentOperState_name, ComponentOperState_value)
	proto.RegisterEnum("dmi.ComponentUsageState", ComponentUsageState_name, ComponentUsageState_value)
	proto.RegisterEnum("dmi.ComponentAlarmState", ComponentAlarmState_name, ComponentAlarmState_value)
	proto.RegisterEnum("dmi.ComponentStandbyState", ComponentStandbyState_name, ComponentStandbyState_value)
	proto.RegisterEnum("dmi.SensorValueType", SensorValueType_name, SensorValueType_value)
	proto.RegisterEnum("dmi.SensorValueScale", SensorValueScale_name, SensorValueScale_value)
	proto.RegisterEnum("dmi.SensorStatus", SensorStatus_name, SensorStatus_value)
	proto.RegisterType((*Uuid)(nil), "dmi.Uuid")
	proto.RegisterType((*HardwareID)(nil), "dmi.HardwareID")
	proto.RegisterType((*Uri)(nil), "dmi.Uri")
	proto.RegisterType((*ComponentState)(nil), "dmi.ComponentState")
	proto.RegisterType((*ComponentSensorData)(nil), "dmi.ComponentSensorData")
	proto.RegisterType((*Component)(nil), "dmi.Component")
	proto.RegisterType((*Hardware)(nil), "dmi.Hardware")
	proto.RegisterType((*ModifiableComponent)(nil), "dmi.ModifiableComponent")
}

func init() { proto.RegisterFile("dmi/hw.proto", fileDescriptor_d7c33d745c4ab367) }

var fileDescriptor_d7c33d745c4ab367 = []byte{
	// 1762 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x97, 0xcf, 0x6f, 0xe3, 0xc6,
	0x15, 0xc7, 0x2b, 0xeb, 0x87, 0xa5, 0x27, 0xd9, 0x9e, 0x1d, 0x7b, 0xd7, 0x5a, 0xef, 0x3a, 0xeb,
	0x28, 0x41, 0xe0, 0x28, 0x88, 0x0d, 0x6c, 0xd0, 0xa2, 0x41, 0x0e, 0xc5, 0x98, 0x9a, 0xb5, 0x59,
	0x4b, 0xa4, 0x30, 0x1c, 0x79, 0xe3, 0xbd, 0x10, 0xb4, 0x48, 0xdb, 0x44, 0x45, 0x51, 0x20, 0x29,
	0x07, 0x7b, 0x6c, 0xd1, 0x73, 0xff, 0x87, 0x5e, 0x8a, 0xf4, 0xdc, 0x43, 0x2f, 0xfd, 0xaf, 0xfa,
	0x0f, 0x14, 0x33, 0x24, 0xf5, 0x73, 0xb4, 0xc9, 0xa1, 0xb7, 0xd1, 0xfb, 0x7c, 0xdf, 0xcc, 0xe3,
	0x9b, 0xf7, 0x1e, 0x29, 0x68, 0xb8, 0x81, 0x7f, 0xfe, 0xf8, 0xd3, 0xd9, 0x24, 0x0a, 0x93, 0x10,
	0x17, 0xdd, 0xc0, 0x3f, 0x7a, 0xf3, 0x10, 0x86, 0x0f, 0x23, 0xef, 0x5c, 0x9a, 0xee, 0xa6, 0xf7,
	0xe7, 0x89, 0x1f, 0x78, 0x71, 0xe2, 0x04, 0x93, 0x54, 0xd5, 0x3a, 0x82, 0xd2, 0x60, 0xea, 0xbb,
	0x18, 0x43, 0x69, 0x3a, 0xf5, 0xdd, 0x66, 0xe1, 0xa4, 0x70, 0x5a, 0x63, 0x72, 0xdd, 0xfa, 0x06,
	0xe0, 0xca, 0x89, 0xdc, 0x9f, 0x9c, 0xc8, 0xd3, 0x3b, 0xf8, 0x78, 0x41, 0x51, 0x7f, 0x5b, 0x3b,
	0x73, 0x03, 0xff, 0x4c, 0xb8, 0x66, 0xe2, 0x43, 0x28, 0x0e, 0x22, 0x1f, 0x23, 0x28, 0x4e, 0x23,
	0x3f, 0xdb, 0x46, 0x2c, 0x5b, 0x7f, 0x2d, 0xc2, 0xae, 0x16, 0x06, 0x93, 0x70, 0xec, 0x8d, 0x13,
	0x2b, 0x71, 0x12, 0x0f, 0x5f, 0x01, 0x8e, 0xc5, 0xc2, 0x1e, 0x39, 0x71, 0x62, 0x0f, 0x1f, 0x9d,
	0xf1, 0x83, 0x97, 0x6f, 0x7c, 0x74, 0x96, 0x86, 0x7c, 0x96, 0x87, 0x7c, 0xc6, 0xf3, 0x90, 0x19,
	0x92, 0x5e, 0x5d, 0x27, 0x4e, 0xb4, 0xd4, 0x07, 0x7f, 0x0f, 0x75, 0xc7, 0x0d, 0xfc, 0xb1, 0x2d,
	0x49, 0x73, 0xeb, 0xa4, 0x70, 0xba, 0xfb, 0xb6, 0x29, 0x63, 0x9b, 0x9d, 0x49, 0x84, 0x40, 0x1e,
	0xcc, 0xc0, 0x99, 0xad, 0xf1, 0xef, 0x00, 0xc2, 0x89, 0x17, 0x65, 0x9e, 0x45, 0xe9, 0x79, 0xb8,
	0xec, 0x69, 0x4e, 0xbc, 0x28, 0x75, 0xac, 0x85, 0xf9, 0x52, 0x1c, 0x39, 0x8d, 0x9d, 0x07, 0x2f,
	0x73, 0x2c, 0xa9, 0x8e, 0x1c, 0x08, 0x41, 0x76, 0xe4, 0x74, 0xb6, 0x96, 0xd1, 0x8e, 0x9c, 0x28,
	0xc8, 0x5c, 0xcb, 0xca, 0x68, 0x85, 0x20, 0x8f, 0x76, 0xb6, 0xc6, 0x7f, 0x80, 0x9d, 0x38, 0x71,
	0xc6, 0xee, 0xdd, 0xc7, 0xcc, 0xb9, 0x22, 0x9d, 0x8f, 0x96, 0x9d, 0xad, 0x54, 0x92, 0xba, 0x37,
	0xe2, 0x85, 0x5f, 0xad, 0xff, 0x6e, 0xc1, 0xfe, 0x5c, 0xe7, 0x8d, 0xe3, 0x30, 0xea, 0x38, 0x89,
	0x83, 0x0f, 0xa0, 0xfc, 0xe4, 0x8c, 0xa6, 0x9e, 0x4c, 0x7f, 0x99, 0xa5, 0x3f, 0xf0, 0x29, 0x94,
	0x92, 0x8f, 0x93, 0x3c, 0xa1, 0x07, 0xf2, 0x94, 0xd4, 0xe9, 0x46, 0x70, 0xfe, 0x71, 0xe2, 0x31,
	0xa9, 0xc0, 0xdf, 0x40, 0x39, 0x1e, 0x3a, 0xa3, 0x3c, 0x83, 0xcf, 0x57, 0xa5, 0x96, 0x80, 0x2c,
	0xd5, 0xe0, 0xd7, 0x50, 0x9b, 0x44, 0xde, 0xd0, 0x8f, 0xfd, 0x70, 0x2c, 0x33, 0x57, 0x66, 0x73,
	0x03, 0xfe, 0x1a, 0x2a, 0xe2, 0xd9, 0xa6, 0x71, 0x96, 0x99, 0x67, 0x0b, 0x7b, 0x59, 0x12, 0xb0,
	0x4c, 0x80, 0xbf, 0x80, 0x9d, 0xe9, 0xd8, 0x4f, 0x62, 0xdb, 0xf5, 0xe3, 0xc9, 0xc8, 0xf9, 0x28,
	0xd3, 0x51, 0x63, 0x0d, 0x69, 0xec, 0xa4, 0x36, 0xfc, 0x7b, 0xa8, 0xcd, 0xca, 0xbd, 0xb9, 0xfd,
	0x8b, 0xd5, 0x35, 0x17, 0xe3, 0x36, 0x3c, 0x93, 0x79, 0xb0, 0xa7, 0x13, 0x57, 0xd4, 0x69, 0x24,
	0x32, 0x5e, 0x3d, 0x29, 0x9c, 0xee, 0xb0, 0x3d, 0x09, 0x06, 0xd2, 0xce, 0xc4, 0xcd, 0xbc, 0x82,
	0x9a, 0xeb, 0x24, 0x8e, 0x2d, 0xf3, 0x55, 0x93, 0x61, 0x54, 0x85, 0x41, 0xe4, 0xa8, 0xf5, 0xef,
	0x32, 0xd4, 0x66, 0x59, 0x17, 0x4d, 0x36, 0x76, 0x02, 0x2f, 0x6f, 0x32, 0xb1, 0xc6, 0xa7, 0x50,
	0x1e, 0x8e, 0x9c, 0x38, 0xce, 0x52, 0x8d, 0x97, 0x2f, 0x54, 0x26, 0x3a, 0x15, 0xe0, 0x13, 0xa8,
	0xbb, 0x5e, 0x3c, 0x8c, 0xfc, 0x49, 0x22, 0xd2, 0x57, 0x94, 0x9b, 0x2c, 0x9a, 0xf0, 0x0b, 0xa8,
	0x4c, 0x9c, 0xc8, 0x1b, 0x27, 0x32, 0xb7, 0x35, 0x96, 0xfd, 0xc2, 0x5f, 0xc2, 0x6e, 0xba, 0xb2,
	0x23, 0x6f, 0x64, 0x4f, 0xc2, 0x34, 0xc1, 0x65, 0xd6, 0x48, 0xad, 0xcc, 0x1b, 0xf5, 0xc3, 0x18,
	0xb7, 0xa1, 0x3a, 0x7c, 0xf4, 0x47, 0x6e, 0xe4, 0x8d, 0x9b, 0x95, 0x93, 0xe2, 0x69, 0xfd, 0xed,
	0xee, 0x72, 0x30, 0x6c, 0xc6, 0xf1, 0xe7, 0xd0, 0x78, 0xcc, 0x46, 0x83, 0x1d, 0x79, 0x4f, 0x32,
	0xbb, 0x35, 0x56, 0xcf, 0x6d, 0xcc, 0x7b, 0x12, 0x92, 0x7b, 0x3f, 0x0a, 0x66, 0x92, 0x6a, 0x2a,
	0xc9, 0x6d, 0x99, 0x24, 0x0e, 0xef, 0x93, 0x99, 0x24, 0xcd, 0x5e, 0x3d, 0xb7, 0x09, 0xc9, 0x31,
	0x40, 0xec, 0x45, 0xbe, 0x33, 0xb2, 0xc7, 0xd3, 0xa0, 0x09, 0x52, 0x50, 0x4b, 0x2d, 0xc6, 0x34,
	0xc0, 0x2f, 0xa1, 0x1a, 0xdc, 0x3f, 0xd8, 0x32, 0xab, 0x75, 0x09, 0xb7, 0x83, 0xfb, 0x07, 0x43,
	0x24, 0xf6, 0x18, 0x20, 0x08, 0x5d, 0x6f, 0x94, 0xc2, 0x46, 0xea, 0x29, 0x2d, 0x12, 0x1f, 0x40,
	0xd9, 0x19, 0xf9, 0x4e, 0xdc, 0xdc, 0x91, 0x24, 0xfd, 0x21, 0xf6, 0x73, 0xe2, 0xd8, 0x4b, 0x6c,
	0xdf, 0x6d, 0xee, 0xa6, 0xfb, 0xc9, 0xdf, 0xba, 0x8b, 0x9f, 0x43, 0xc5, 0x8f, 0xed, 0xfb, 0x68,
	0xda, 0xdc, 0x3b, 0x29, 0x9c, 0x56, 0x59, 0xd9, 0x8f, 0xdf, 0x45, 0x53, 0xfc, 0xdb, 0x34, 0x02,
	0x51, 0x0e, 0x4d, 0xf4, 0x8b, 0x35, 0x26, 0xa2, 0xeb, 0x88, 0xaa, 0x39, 0x4a, 0xe7, 0xe4, 0x33,
	0xe9, 0x51, 0x4d, 0x87, 0x69, 0xe4, 0xcb, 0x89, 0x39, 0x9b, 0xb4, 0x58, 0x39, 0x69, 0xf1, 0xd7,
	0x50, 0x4e, 0x47, 0xc0, 0xbe, 0xe4, 0xfb, 0x6b, 0x23, 0x20, 0x11, 0xfd, 0x96, 0x0f, 0x9c, 0x58,
	0xb6, 0x8f, 0x88, 0xcf, 0x69, 0x1e, 0xc8, 0x5b, 0x5d, 0x19, 0x38, 0xf3, 0x59, 0xc0, 0x20, 0x9e,
	0xad, 0x5b, 0x7f, 0x82, 0x6a, 0x3e, 0xfc, 0xf1, 0x0f, 0x50, 0x5f, 0x98, 0xd4, 0xbf, 0x62, 0x50,
	0xc3, 0x68, 0x36, 0xa3, 0x71, 0x0b, 0x4a, 0x51, 0x18, 0x26, 0xb2, 0xbe, 0xd7, 0x4b, 0x4a, 0xb2,
	0xd6, 0x3f, 0xb7, 0x60, 0xbf, 0x17, 0xba, 0xfe, 0xbd, 0xef, 0xdc, 0x8d, 0xbc, 0xff, 0x57, 0xc3,
	0x7c, 0x35, 0x6b, 0x87, 0xa2, 0xf2, 0xec, 0xcd, 0xed, 0x51, 0x52, 0xb4, 0xc7, 0xac, 0x60, 0xca,
	0x9b, 0x0a, 0xa6, 0xb2, 0x5c, 0x30, 0xd9, 0x15, 0x6f, 0xab, 0xae, 0x78, 0xe5, 0xbd, 0x55, 0xfd,
	0xf5, 0xef, 0xad, 0xf6, 0x9f, 0x4b, 0xb0, 0xb3, 0xf4, 0xb8, 0xf8, 0x35, 0x34, 0x35, 0xb3, 0xd7,
	0x37, 0x0d, 0x6a, 0x70, 0x9b, 0xdf, 0xf6, 0xa9, 0x3d, 0x30, 0x3a, 0xf4, 0x9d, 0x6e, 0xd0, 0x0e,
	0xfa, 0x0d, 0x3e, 0x82, 0x17, 0x6b, 0xf4, 0xda, 0x30, 0xdf, 0x1b, 0xa8, 0xa0, 0x60, 0xda, 0x15,
	0xb1, 0x2c, 0xdd, 0x42, 0x5b, 0x8a, 0x5d, 0x2f, 0x88, 0x76, 0xdd, 0xef, 0x12, 0x83, 0xa2, 0xa2,
	0x82, 0x6a, 0xa6, 0xc1, 0x89, 0x6e, 0x50, 0x86, 0x4a, 0xf8, 0x0d, 0xbc, 0x5a, 0xa1, 0x7d, 0xf3,
	0x3d, 0x65, 0xb6, 0x35, 0xe8, 0xf7, 0xbb, 0xb7, 0xa8, 0x8c, 0x5f, 0x00, 0x5e, 0x11, 0xbc, 0x23,
	0x06, 0xaa, 0xe0, 0x97, 0xf0, 0x7c, 0xc5, 0x6e, 0x51, 0xc3, 0x32, 0x19, 0xda, 0x56, 0xa0, 0x9e,
	0xd9, 0x19, 0x74, 0x29, 0xaa, 0xe2, 0x43, 0xd8, 0x5f, 0x3b, 0x8e, 0x71, 0x54, 0x53, 0x1c, 0xa3,
	0xf5, 0x07, 0x08, 0x14, 0xcf, 0x7d, 0x41, 0x38, 0xa7, 0xec, 0x16, 0xd5, 0x15, 0xcc, 0xe2, 0x26,
	0x23, 0x97, 0x14, 0x35, 0x54, 0x31, 0xd0, 0x9e, 0xc9, 0x6e, 0xd1, 0x0e, 0xfe, 0x0c, 0x8e, 0x56,
	0x10, 0x67, 0xc4, 0xb0, 0x34, 0xaa, 0xdf, 0x50, 0x86, 0x76, 0xf1, 0x17, 0xf0, 0x66, 0x85, 0x5f,
	0xf6, 0x4d, 0x63, 0x49, 0xb4, 0x87, 0xbf, 0x82, 0xd6, 0x8a, 0xe8, 0xc7, 0x4b, 0xcb, 0x5e, 0xd5,
	0xa1, 0xf6, 0xbf, 0x0a, 0x0b, 0x2f, 0xf3, 0x79, 0x9d, 0xe4, 0x41, 0xd8, 0xa4, 0xd3, 0xd3, 0x0d,
	0xdb, 0xe2, 0x84, 0x2f, 0xd7, 0x42, 0x76, 0x6b, 0x2b, 0x3c, 0xaf, 0x86, 0x57, 0x70, 0xb8, 0x46,
	0xbb, 0xa6, 0x76, 0x4d, 0x3b, 0x68, 0x0b, 0xb7, 0xe0, 0xb3, 0x35, 0x68, 0x5d, 0x0d, 0x38, 0xd7,
	0x8d, 0x4b, 0xbb, 0x23, 0x36, 0x28, 0xe2, 0x63, 0x78, 0xa9, 0xd8, 0x3e, 0xdb, 0xa2, 0xd4, 0xfe,
	0xb9, 0x00, 0x78, 0xfd, 0xdb, 0x6a, 0xe6, 0x65, 0xf6, 0x45, 0x85, 0xac, 0xc5, 0x9c, 0x47, 0xb5,
	0x84, 0xf3, 0x90, 0xf3, 0x07, 0x5a, 0x80, 0x1d, 0xdd, 0x22, 0x17, 0x5d, 0x19, 0xb3, 0xc2, 0x95,
	0x1a, 0x29, 0x2c, 0xaa, 0x20, 0xa7, 0x96, 0x78, 0x1c, 0x54, 0x6a, 0xff, 0x63, 0x31, 0xc1, 0xf3,
	0xaf, 0xb9, 0x59, 0x82, 0x07, 0x16, 0xb9, 0xa4, 0x9f, 0x48, 0xf0, 0x32, 0xcf, 0xa3, 0xcd, 0xca,
	0x67, 0x89, 0xea, 0x9d, 0x2e, 0x5d, 0x08, 0x75, 0x11, 0x11, 0x8d, 0xeb, 0x37, 0xa2, 0xd9, 0x54,
	0x7e, 0x17, 0x03, 0xeb, 0x16, 0x95, 0xda, 0x7f, 0x5b, 0xfc, 0xac, 0x9b, 0x7f, 0x3b, 0xce, 0x2b,
	0xa1, 0x4b, 0x58, 0xef, 0x53, 0x95, 0xb0, 0xc4, 0xf3, 0x40, 0x3f, 0x87, 0x63, 0xa5, 0x37, 0xb3,
	0x19, 0xed, 0x13, 0x9d, 0xa1, 0xad, 0xf9, 0x5d, 0x2f, 0x48, 0x34, 0xa6, 0x73, 0x5d, 0x23, 0x5d,
	0x54, 0xcc, 0xbb, 0x68, 0x09, 0xf7, 0xc8, 0x1f, 0x4d, 0x31, 0x1d, 0x94, 0x4c, 0x37, 0x4c, 0x86,
	0xca, 0xca, 0xb8, 0xde, 0x13, 0x66, 0x88, 0x6b, 0xa9, 0x28, 0xe3, 0xd2, 0x0d, 0x4e, 0x59, 0x8f,
	0x76, 0x74, 0xc2, 0x29, 0xda, 0x6e, 0xff, 0xa7, 0x00, 0xcf, 0x95, 0xdf, 0xc3, 0xf8, 0x04, 0x5e,
	0x4b, 0x67, 0x8b, 0x13, 0xa3, 0x73, 0x71, 0xab, 0x48, 0x4a, 0x9e, 0xb4, 0x55, 0xc5, 0xca, 0xb8,
	0x5c, 0xe1, 0x57, 0x26, 0x5f, 0xb8, 0xc0, 0x65, 0xa6, 0x99, 0x5d, 0x51, 0x6b, 0xa7, 0xf0, 0xa5,
	0x02, 0xf6, 0x99, 0x79, 0xa3, 0x77, 0x44, 0xff, 0x58, 0x94, 0xdd, 0xe8, 0x1a, 0x45, 0xa5, 0xf6,
	0xdf, 0x8b, 0xb0, 0xb7, 0xf2, 0xa1, 0x2d, 0xa6, 0x69, 0x3a, 0x05, 0xed, 0x1b, 0xd2, 0x1d, 0xd0,
	0xf5, 0x11, 0xff, 0x0a, 0x0e, 0xd7, 0x05, 0x26, 0xbf, 0xa2, 0x0c, 0x15, 0xc4, 0x45, 0xa9, 0xbc,
	0xd3, 0x67, 0xda, 0x12, 0xcf, 0xbc, 0x8e, 0x6f, 0xcc, 0x2e, 0xb7, 0x6c, 0xa2, 0xa1, 0xe2, 0xa7,
	0x78, 0x47, 0x43, 0x25, 0xf5, 0xf6, 0xa4, 0xd7, 0xa7, 0x8c, 0x5a, 0xa8, 0xac, 0x0e, 0xed, 0x3d,
	0xe1, 0xdc, 0x42, 0x15, 0x35, 0xbc, 0xa2, 0x8c, 0x7f, 0x40, 0xdb, 0xea, 0x8d, 0x35, 0xda, 0xb5,
	0xf4, 0x81, 0x85, 0xaa, 0xe2, 0x36, 0xd7, 0x71, 0x9f, 0x32, 0x4d, 0x8c, 0x4e, 0x76, 0x85, 0x6a,
	0xa2, 0x6b, 0xd6, 0x15, 0xac, 0xdf, 0x43, 0xa0, 0x46, 0x5a, 0xaf, 0x87, 0xea, 0xa2, 0xc4, 0xd6,
	0x11, 0x67, 0x03, 0x7e, 0x95, 0x1a, 0x50, 0xa3, 0xfd, 0x73, 0x09, 0xd0, 0xea, 0x3f, 0x9c, 0xb5,
	0x78, 0x2c, 0x8d, 0x74, 0xd7, 0x5a, 0x4e, 0xa1, 0xb8, 0x35, 0x35, 0x6e, 0xa6, 0x93, 0x4c, 0x41,
	0x3f, 0xd0, 0x3e, 0x37, 0xd3, 0xea, 0x52, 0x50, 0xc2, 0xb9, 0x99, 0xbe, 0x8b, 0x15, 0xf0, 0x1d,
	0xed, 0x71, 0x13, 0x95, 0x36, 0xb8, 0xf6, 0x75, 0xcd, 0x54, 0x5c, 0x4f, 0x0a, 0x0d, 0x62, 0x98,
	0xa8, 0xb2, 0x61, 0xdf, 0x9e, 0xae, 0x31, 0x13, 0x6d, 0x6f, 0xa4, 0xdd, 0xae, 0x8e, 0xaa, 0x1b,
	0xe8, 0xc0, 0xd0, 0xb9, 0x85, 0x6a, 0x1b, 0x8e, 0xbd, 0xd6, 0xbb, 0x26, 0x82, 0x0d, 0xb0, 0x47,
	0x2f, 0x09, 0xaa, 0x6f, 0x80, 0x97, 0xfa, 0x25, 0x41, 0x8d, 0x0d, 0x90, 0x53, 0x46, 0xd0, 0xce,
	0xa6, 0x3c, 0x50, 0x4e, 0xd0, 0xae, 0xe8, 0x6c, 0x05, 0xa4, 0x3f, 0x12, 0xb4, 0xb7, 0xf1, 0x66,
	0x38, 0x27, 0x08, 0x6d, 0xbc, 0x55, 0x41, 0x9f, 0xb5, 0xff, 0x52, 0x80, 0xc6, 0xe2, 0x1f, 0xd8,
	0x85, 0x28, 0xc4, 0x0c, 0x18, 0x58, 0x4b, 0x15, 0x72, 0x00, 0x68, 0x19, 0x9a, 0xd7, 0x4b, 0x0d,
	0x3c, 0x73, 0x21, 0x37, 0x44, 0xef, 0x8a, 0x17, 0x19, 0xda, 0x5a, 0x28, 0xbc, 0x0c, 0x1b, 0xa6,
	0x21, 0xde, 0x69, 0x84, 0xeb, 0xa6, 0x21, 0x66, 0xf1, 0xc5, 0x0f, 0x1f, 0xbe, 0x7f, 0xf0, 0x93,
	0xc7, 0xe9, 0xdd, 0xd9, 0x30, 0x0c, 0xce, 0xc3, 0x89, 0x37, 0x1e, 0x86, 0x91, 0x7b, 0xee, 0x7a,
	0x4f, 0xfe, 0xd0, 0xfb, 0x36, 0x70, 0xc6, 0xce, 0x83, 0x17, 0x78, 0xe3, 0xe4, 0x5b, 0x7f, 0x9c,
	0x78, 0xd1, 0xbd, 0x33, 0xf4, 0xce, 0x9f, 0xbe, 0x3b, 0x7f, 0x08, 0xcf, 0xdd, 0xc0, 0xbf, 0xab,
	0xc8, 0xcf, 0xfb, 0xef, 0xfe, 0x17, 0x00, 0x00, 0xff, 0xff, 0xcf, 0xe7, 0x9a, 0xfa, 0x5d, 0x12,
	0x00, 0x00,
}
