/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// AniGClassID is the 16-bit ID for the OMCI
// Managed entity ANI-G
const AniGClassID = ClassID(263) // 0x0107

var anigBME *ManagedEntityDefinition

// AniG (Class ID: #263 / 0x0107)
//	This ME organizes data associated with each access network interface supported by a GPON ONU.
//	The ONU automatically creates one instance of this ME for each PON physical port.
//
//	Relationships
//		An instance of this ME is associated with each instance of a physical PON interface.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Its value indicates the physical
//			position of the PON interface. The first byte is the slot ID, defined in clause 9.1.5. The
//			second byte is the port ID. (R) (mandatory) (2-bytes)
//
//		Sr Indication
//			This Boolean attribute indicates the ONU's capability to report queue status for DBA. The value
//			true means that status reporting is available for all TCONTs that are associated with the ANI.
//			(R) (mandatory) (1-byte)
//
//		Total TCont Number
//			This attribute indicates the total number of T-CONTs that can be supported on this ANI. (R)
//			(mandatory) (2-bytes)
//
//		Gem Block Length
//			This attribute specifies the queue occupancy reporting granularity for DBA, expressed in bytes.
//			This attribute is meaningful only in ITUT G.984.x systems. (R, W) (mandatory) (2 bytes)
//
//			In ITU-T G.984 systems, the value set by the OLT is used by all TCONTs on this ANI. Upon ME
//			instantiation, the ONU sets this attribute to 48. See [ITUT G.984.3] for further details.
//
//			In all other ITU-T PON systems, the unit for queue occupancy reporting is fixed in at 4-bytes by
//			the respective TC layer specification.
//
//		Piggyback Dba Reporting
//			This attribute indicates the ONU's piggyback DBA reporting format capabilities. [ITUT G.984.3]
//			defines two possible piggyback reporting modes. For reporting mode 0, the single field is the
//			entire report. For reporting mode 1, the DBA report is two fields long. Mode 0 is mandatory for
//			ITU-T G.984 ONUs that support piggyback DBA reporting; mode 1 is optional. Subsequent PON
//			specifications allows only one mode, which should be reported in this attribute as code point 0.
//
//			The following coding indicates the ONU's piggyback DBA reporting mode capabilities:
//
//			0	Mode 0 only
//
//			1	Modes 0 and 1
//
//			2	Deprecated
//
//			3	Deprecated
//
//			4	Piggyback DBA reporting not supported
//
//			(R) (mandatory) (1-byte)
//
//		Deprecated
//			This attribute should be set to 0 by the ONU and ignored by the OLT. (R) (mandatory) (1-byte)
//
//		Signal Fail Threshold
//			Signal fail (SF) threshold: This attribute specifies the downstream bit error rate (BER)
//			threshold to detect the SF alarm. When this value is y, the BER threshold is 10-y. Valid values
//			are 3..8. Upon ME instantiation, the ONU sets this attribute to 5. (R,-W) (mandatory) (1-byte)
//
//		Signal Degrade Threshold
//			Signal degrade (SD) threshold: This attribute specifies the downstream BER threshold to detect
//			the SD alarm. When this value is x, the BER threshold for SD is 10-x. Valid values are 4..10.
//			The SD threshold must be lower than the SF threshold; i.e., x-> y. Upon ME instantiation, the
//			ONU sets this attribute to 9. (R,-W) (mandatory) (1-byte)
//
//		Arc
//			See clause A.1.4.3. (R,-W) (optional) (1-byte)
//
//		Arc Interval
//			See clause A.1.4.3. (R,-W) (optional) (1-byte)
//
//		Optical Signal Level
//			This attribute reports the current measurement of the total downstream optical signal level. Its
//			value is a 2s complement integer referred to 1- mW (i.e., 1-dBm), with 0.002 dB granularity. (R)
//			(optional) (2-bytes)
//
//		Lower Optical Threshold
//			This attribute specifies the optical level the ONU uses to declare the downstream low received
//			optical power alarm. Valid values are  -127 dBm (coded as 254) to 0 dBm (coded as 0) in 0.5 dB
//			increments. The default value 0xFF selects the ONU's internal policy. (R,-W) (optional) (1-byte)
//
//		Upper Optical Threshold
//			This attribute specifies the optical level the ONU uses to declare the downstream high received
//			optical power alarm. Valid values are  -127 dBm (coded as 254) to 0 dBm (coded as 0) in 0.5 dB
//			increments. The default value 0xFF selects the ONU's internal policy. (R,-W) (optional) (1-byte)
//
//		Onu Response Time
//			This attribute indicates the ONU's actual response time. This attribute is in the range
//			34..36-us. Although this attribute is expressed in nanoseconds, its accuracy is likely to be
//			more coarse. Furthermore, the value may change from one activation cycle to the next. Valid
//			values are:
//
//			0 (Null, function not supported)
//
//			34000 to 36000 (response time in nanoseconds)
//
//			All other values reserved
//
//			(R) (optional) (2-bytes)
//
//		Transmit Optical Level
//			This attribute reports the current measurement of mean optical launch power. Its value is a 2s
//			complement integer referred to 1-mW (i.e., 1-dBm), with 0.002 dB granularity. (R) (optional)
//			(2-bytes)
//
//		Lower Transmit Power Threshold
//			This attribute specifies the minimum mean optical launch power that the ONU uses to declare the
//			low transmit optical power alarm. Its value is a 2s complement integer referred to 1-mW (i.e.,
//			dBm), with 0.5-dB granularity. The default value -63.5 (0x81) selects the ONU's internal policy.
//			(R,-W) (optional) (1-byte)
//
//		Upper Transmit Power Threshold
//			This attribute specifies the maximum mean optical launch power that the ONU uses to declare the
//			high transmit optical power alarm. Its value is a 2s complement integer referred to 1-mW (i.e.,
//			dBm), with 0.5-dB granularity. The default value -63.5 (0x81) selects the ONU's internal policy.
//			(R,-W) (optional) (1-byte)
//
type AniG struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const AniG_SrIndication = "SrIndication"
const AniG_TotalTcontNumber = "TotalTcontNumber"
const AniG_GemBlockLength = "GemBlockLength"
const AniG_PiggybackDbaReporting = "PiggybackDbaReporting"
const AniG_Deprecated = "Deprecated"
const AniG_SignalFailThreshold = "SignalFailThreshold"
const AniG_SignalDegradeThreshold = "SignalDegradeThreshold"
const AniG_Arc = "Arc"
const AniG_ArcInterval = "ArcInterval"
const AniG_OpticalSignalLevel = "OpticalSignalLevel"
const AniG_LowerOpticalThreshold = "LowerOpticalThreshold"
const AniG_UpperOpticalThreshold = "UpperOpticalThreshold"
const AniG_OnuResponseTime = "OnuResponseTime"
const AniG_TransmitOpticalLevel = "TransmitOpticalLevel"
const AniG_LowerTransmitPowerThreshold = "LowerTransmitPowerThreshold"
const AniG_UpperTransmitPowerThreshold = "UpperTransmitPowerThreshold"

func init() {
	anigBME = &ManagedEntityDefinition{
		Name:    "AniG",
		ClassID: AniGClassID,
		MessageTypes: mapset.NewSetWith(
			Get,
			Set,
			Test,
		),
		AllowedAttributeMask: 0xffff,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1:  ByteField(AniG_SrIndication, EnumerationAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(AniG_TotalTcontNumber, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read), false, false, false, 2),
			3:  Uint16Field(AniG_GemBlockLength, UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, Write), false, false, false, 3),
			4:  ByteField(AniG_PiggybackDbaReporting, EnumerationAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  ByteField(AniG_Deprecated, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, true, 5),
			6:  ByteField(AniG_SignalFailThreshold, UnsignedIntegerAttributeType, 0x0400, 5, mapset.NewSetWith(Read, Write), false, false, false, 6),
			7:  ByteField(AniG_SignalDegradeThreshold, UnsignedIntegerAttributeType, 0x0200, 9, mapset.NewSetWith(Read, Write), false, false, false, 7),
			8:  ByteField(AniG_Arc, EnumerationAttributeType, 0x0100, 0, mapset.NewSetWith(Read, Write), true, true, false, 8),
			9:  ByteField(AniG_ArcInterval, UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read, Write), false, true, false, 9),
			10: Uint16Field(AniG_OpticalSignalLevel, SignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, true, false, 10),
			11: ByteField(AniG_LowerOpticalThreshold, SignedIntegerAttributeType, 0x0020, 255, mapset.NewSetWith(Read, Write), false, true, false, 11),
			12: ByteField(AniG_UpperOpticalThreshold, SignedIntegerAttributeType, 0x0010, 255, mapset.NewSetWith(Read, Write), false, true, false, 12),
			13: Uint16Field(AniG_OnuResponseTime, UnsignedIntegerAttributeType, 0x0008, 35000, mapset.NewSetWith(Read), false, true, false, 13),
			14: Uint16Field(AniG_TransmitOpticalLevel, SignedIntegerAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, true, false, 14),
			15: ByteField(AniG_LowerTransmitPowerThreshold, SignedIntegerAttributeType, 0x0002, 129, mapset.NewSetWith(Read, Write), false, true, false, 15),
			16: ByteField(AniG_UpperTransmitPowerThreshold, SignedIntegerAttributeType, 0x0001, 129, mapset.NewSetWith(Read, Write), false, true, false, 16),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "Low received optical power",
			1: "High received optical power",
			2: "SF",
			3: "SD",
			4: "Low transmit optical power",
			5: "High transmit optical power",
			6: "Laser bias current",
		},
	}
}

// NewAniG (class ID 263) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewAniG(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*anigBME, params...)
}
