// Code generated by protoc-gen-go. DO NOT EDIT.
// source: dmi/hw_metrics_mgmt_service.proto

package dmi

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type MetricNames int32

const (
	MetricNames_METRIC_NAME_UNDEFINED MetricNames = 0
	// FAN related metrics
	MetricNames_METRIC_FAN_SPEED MetricNames = 1
	// CPU related metrics
	MetricNames_METRIC_CPU_TEMP             MetricNames = 100
	MetricNames_METRIC_CPU_USAGE_PERCENTAGE MetricNames = 101
	// Transceiver related metrics
	MetricNames_METRIC_TRANSCEIVER_TEMP       MetricNames = 200
	MetricNames_METRIC_TRANSCEIVER_VOLTAGE    MetricNames = 201
	MetricNames_METRIC_TRANSCEIVER_BIAS       MetricNames = 202
	MetricNames_METRIC_TRANSCEIVER_RX_POWER   MetricNames = 203
	MetricNames_METRIC_TRANSCEIVER_TX_POWER   MetricNames = 204
	MetricNames_METRIC_TRANSCEIVER_WAVELENGTH MetricNames = 205
	// Disk related metrics
	MetricNames_METRIC_DISK_TEMP                    MetricNames = 300
	MetricNames_METRIC_DISK_CAPACITY                MetricNames = 301
	MetricNames_METRIC_DISK_USAGE                   MetricNames = 302
	MetricNames_METRIC_DISK_USAGE_PERCENTAGE        MetricNames = 303
	MetricNames_METRIC_DISK_READ_WRITE_PERCENTAGE   MetricNames = 304
	MetricNames_METRIC_DISK_FAULTY_CELLS_PERCENTAGE MetricNames = 305
	// RAM related metrics
	MetricNames_METRIC_RAM_TEMP             MetricNames = 400
	MetricNames_METRIC_RAM_CAPACITY         MetricNames = 401
	MetricNames_METRIC_RAM_USAGE            MetricNames = 402
	MetricNames_METRIC_RAM_USAGE_PERCENTAGE MetricNames = 403
	// Power related metrics
	MetricNames_METRIC_POWER_MAX              MetricNames = 500
	MetricNames_METRIC_POWER_USAGE            MetricNames = 501
	MetricNames_METRIC_POWER_USAGE_PERCENTAGE MetricNames = 502
	// Chassis related metrics
	MetricNames_METRIC_INNER_SURROUNDING_TEMP MetricNames = 600
)

var MetricNames_name = map[int32]string{
	0:   "METRIC_NAME_UNDEFINED",
	1:   "METRIC_FAN_SPEED",
	100: "METRIC_CPU_TEMP",
	101: "METRIC_CPU_USAGE_PERCENTAGE",
	200: "METRIC_TRANSCEIVER_TEMP",
	201: "METRIC_TRANSCEIVER_VOLTAGE",
	202: "METRIC_TRANSCEIVER_BIAS",
	203: "METRIC_TRANSCEIVER_RX_POWER",
	204: "METRIC_TRANSCEIVER_TX_POWER",
	205: "METRIC_TRANSCEIVER_WAVELENGTH",
	300: "METRIC_DISK_TEMP",
	301: "METRIC_DISK_CAPACITY",
	302: "METRIC_DISK_USAGE",
	303: "METRIC_DISK_USAGE_PERCENTAGE",
	304: "METRIC_DISK_READ_WRITE_PERCENTAGE",
	305: "METRIC_DISK_FAULTY_CELLS_PERCENTAGE",
	400: "METRIC_RAM_TEMP",
	401: "METRIC_RAM_CAPACITY",
	402: "METRIC_RAM_USAGE",
	403: "METRIC_RAM_USAGE_PERCENTAGE",
	500: "METRIC_POWER_MAX",
	501: "METRIC_POWER_USAGE",
	502: "METRIC_POWER_USAGE_PERCENTAGE",
	600: "METRIC_INNER_SURROUNDING_TEMP",
}

var MetricNames_value = map[string]int32{
	"METRIC_NAME_UNDEFINED":               0,
	"METRIC_FAN_SPEED":                    1,
	"METRIC_CPU_TEMP":                     100,
	"METRIC_CPU_USAGE_PERCENTAGE":         101,
	"METRIC_TRANSCEIVER_TEMP":             200,
	"METRIC_TRANSCEIVER_VOLTAGE":          201,
	"METRIC_TRANSCEIVER_BIAS":             202,
	"METRIC_TRANSCEIVER_RX_POWER":         203,
	"METRIC_TRANSCEIVER_TX_POWER":         204,
	"METRIC_TRANSCEIVER_WAVELENGTH":       205,
	"METRIC_DISK_TEMP":                    300,
	"METRIC_DISK_CAPACITY":                301,
	"METRIC_DISK_USAGE":                   302,
	"METRIC_DISK_USAGE_PERCENTAGE":        303,
	"METRIC_DISK_READ_WRITE_PERCENTAGE":   304,
	"METRIC_DISK_FAULTY_CELLS_PERCENTAGE": 305,
	"METRIC_RAM_TEMP":                     400,
	"METRIC_RAM_CAPACITY":                 401,
	"METRIC_RAM_USAGE":                    402,
	"METRIC_RAM_USAGE_PERCENTAGE":         403,
	"METRIC_POWER_MAX":                    500,
	"METRIC_POWER_USAGE":                  501,
	"METRIC_POWER_USAGE_PERCENTAGE":       502,
	"METRIC_INNER_SURROUNDING_TEMP":       600,
}

func (x MetricNames) String() string {
	return proto.EnumName(MetricNames_name, int32(x))
}

func (MetricNames) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{0}
}

type MetricConfig struct {
	MetricId MetricNames `protobuf:"varint,1,opt,name=metric_id,json=metricId,proto3,enum=dmi.MetricNames" json:"metric_id,omitempty"`
	// Whether the device manager is collecting and reporting this metric or not
	IsConfigured bool `protobuf:"varint,2,opt,name=is_configured,json=isConfigured,proto3" json:"is_configured,omitempty"`
	// Number of seconds between two consecutive polls of the particular metric
	// Each device manager implemenation could have it's per metric default poll frequency which
	// can be requested to be changed using this value
	PollInterval         uint32   `protobuf:"varint,3,opt,name=poll_interval,json=pollInterval,proto3" json:"poll_interval,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricConfig) Reset()         { *m = MetricConfig{} }
func (m *MetricConfig) String() string { return proto.CompactTextString(m) }
func (*MetricConfig) ProtoMessage()    {}
func (*MetricConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{0}
}

func (m *MetricConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricConfig.Unmarshal(m, b)
}
func (m *MetricConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricConfig.Marshal(b, m, deterministic)
}
func (m *MetricConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricConfig.Merge(m, src)
}
func (m *MetricConfig) XXX_Size() int {
	return xxx_messageInfo_MetricConfig.Size(m)
}
func (m *MetricConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MetricConfig proto.InternalMessageInfo

func (m *MetricConfig) GetMetricId() MetricNames {
	if m != nil {
		return m.MetricId
	}
	return MetricNames_METRIC_NAME_UNDEFINED
}

func (m *MetricConfig) GetIsConfigured() bool {
	if m != nil {
		return m.IsConfigured
	}
	return false
}

func (m *MetricConfig) GetPollInterval() uint32 {
	if m != nil {
		return m.PollInterval
	}
	return 0
}

type MetricsConfig struct {
	Metrics              []*MetricConfig `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *MetricsConfig) Reset()         { *m = MetricsConfig{} }
func (m *MetricsConfig) String() string { return proto.CompactTextString(m) }
func (*MetricsConfig) ProtoMessage()    {}
func (*MetricsConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{1}
}

func (m *MetricsConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricsConfig.Unmarshal(m, b)
}
func (m *MetricsConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricsConfig.Marshal(b, m, deterministic)
}
func (m *MetricsConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsConfig.Merge(m, src)
}
func (m *MetricsConfig) XXX_Size() int {
	return xxx_messageInfo_MetricsConfig.Size(m)
}
func (m *MetricsConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsConfig.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsConfig proto.InternalMessageInfo

func (m *MetricsConfig) GetMetrics() []*MetricConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type ListMetricsResponse struct {
	Status               Status         `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               Reason         `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.Reason" json:"reason,omitempty"`
	Metrics              *MetricsConfig `protobuf:"bytes,3,opt,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ListMetricsResponse) Reset()         { *m = ListMetricsResponse{} }
func (m *ListMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*ListMetricsResponse) ProtoMessage()    {}
func (*ListMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{2}
}

func (m *ListMetricsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMetricsResponse.Unmarshal(m, b)
}
func (m *ListMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMetricsResponse.Marshal(b, m, deterministic)
}
func (m *ListMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMetricsResponse.Merge(m, src)
}
func (m *ListMetricsResponse) XXX_Size() int {
	return xxx_messageInfo_ListMetricsResponse.Size(m)
}
func (m *ListMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMetricsResponse proto.InternalMessageInfo

func (m *ListMetricsResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *ListMetricsResponse) GetReason() Reason {
	if m != nil {
		return m.Reason
	}
	return Reason_UNDEFINED_REASON
}

func (m *ListMetricsResponse) GetMetrics() *MetricsConfig {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type MetricsConfigurationRequest struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// Types that are valid to be assigned to Operation:
	//	*MetricsConfigurationRequest_Changes
	//	*MetricsConfigurationRequest_ResetToDefault
	Operation            isMetricsConfigurationRequest_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *MetricsConfigurationRequest) Reset()         { *m = MetricsConfigurationRequest{} }
func (m *MetricsConfigurationRequest) String() string { return proto.CompactTextString(m) }
func (*MetricsConfigurationRequest) ProtoMessage()    {}
func (*MetricsConfigurationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{3}
}

func (m *MetricsConfigurationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricsConfigurationRequest.Unmarshal(m, b)
}
func (m *MetricsConfigurationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricsConfigurationRequest.Marshal(b, m, deterministic)
}
func (m *MetricsConfigurationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsConfigurationRequest.Merge(m, src)
}
func (m *MetricsConfigurationRequest) XXX_Size() int {
	return xxx_messageInfo_MetricsConfigurationRequest.Size(m)
}
func (m *MetricsConfigurationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsConfigurationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsConfigurationRequest proto.InternalMessageInfo

func (m *MetricsConfigurationRequest) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

type isMetricsConfigurationRequest_Operation interface {
	isMetricsConfigurationRequest_Operation()
}

type MetricsConfigurationRequest_Changes struct {
	Changes *MetricsConfig `protobuf:"bytes,2,opt,name=changes,proto3,oneof"`
}

type MetricsConfigurationRequest_ResetToDefault struct {
	ResetToDefault bool `protobuf:"varint,3,opt,name=reset_to_default,json=resetToDefault,proto3,oneof"`
}

func (*MetricsConfigurationRequest_Changes) isMetricsConfigurationRequest_Operation() {}

func (*MetricsConfigurationRequest_ResetToDefault) isMetricsConfigurationRequest_Operation() {}

func (m *MetricsConfigurationRequest) GetOperation() isMetricsConfigurationRequest_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *MetricsConfigurationRequest) GetChanges() *MetricsConfig {
	if x, ok := m.GetOperation().(*MetricsConfigurationRequest_Changes); ok {
		return x.Changes
	}
	return nil
}

func (m *MetricsConfigurationRequest) GetResetToDefault() bool {
	if x, ok := m.GetOperation().(*MetricsConfigurationRequest_ResetToDefault); ok {
		return x.ResetToDefault
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MetricsConfigurationRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MetricsConfigurationRequest_Changes)(nil),
		(*MetricsConfigurationRequest_ResetToDefault)(nil),
	}
}

type MetricsConfigurationResponse struct {
	Status               Status   `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               Reason   `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.Reason" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricsConfigurationResponse) Reset()         { *m = MetricsConfigurationResponse{} }
func (m *MetricsConfigurationResponse) String() string { return proto.CompactTextString(m) }
func (*MetricsConfigurationResponse) ProtoMessage()    {}
func (*MetricsConfigurationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{4}
}

func (m *MetricsConfigurationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricsConfigurationResponse.Unmarshal(m, b)
}
func (m *MetricsConfigurationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricsConfigurationResponse.Marshal(b, m, deterministic)
}
func (m *MetricsConfigurationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsConfigurationResponse.Merge(m, src)
}
func (m *MetricsConfigurationResponse) XXX_Size() int {
	return xxx_messageInfo_MetricsConfigurationResponse.Size(m)
}
func (m *MetricsConfigurationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsConfigurationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsConfigurationResponse proto.InternalMessageInfo

func (m *MetricsConfigurationResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *MetricsConfigurationResponse) GetReason() Reason {
	if m != nil {
		return m.Reason
	}
	return Reason_UNDEFINED_REASON
}

type MetricMetaData struct {
	DeviceUuid *Uuid `protobuf:"bytes,1,opt,name=device_uuid,json=deviceUuid,proto3" json:"device_uuid,omitempty"`
	// uuid of the component
	ComponentUuid        *Uuid    `protobuf:"bytes,2,opt,name=component_uuid,json=componentUuid,proto3" json:"component_uuid,omitempty"`
	ComponentName        string   `protobuf:"bytes,3,opt,name=component_name,json=componentName,proto3" json:"component_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricMetaData) Reset()         { *m = MetricMetaData{} }
func (m *MetricMetaData) String() string { return proto.CompactTextString(m) }
func (*MetricMetaData) ProtoMessage()    {}
func (*MetricMetaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{5}
}

func (m *MetricMetaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricMetaData.Unmarshal(m, b)
}
func (m *MetricMetaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricMetaData.Marshal(b, m, deterministic)
}
func (m *MetricMetaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricMetaData.Merge(m, src)
}
func (m *MetricMetaData) XXX_Size() int {
	return xxx_messageInfo_MetricMetaData.Size(m)
}
func (m *MetricMetaData) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricMetaData.DiscardUnknown(m)
}

var xxx_messageInfo_MetricMetaData proto.InternalMessageInfo

func (m *MetricMetaData) GetDeviceUuid() *Uuid {
	if m != nil {
		return m.DeviceUuid
	}
	return nil
}

func (m *MetricMetaData) GetComponentUuid() *Uuid {
	if m != nil {
		return m.ComponentUuid
	}
	return nil
}

func (m *MetricMetaData) GetComponentName() string {
	if m != nil {
		return m.ComponentName
	}
	return ""
}

// The Metrics are conveyed to external systems by submitting them on a kafka bus.
// The topic to which are Metrics are submitted would be configured as startup
// configuration of the components
type Metric struct {
	MetricId             MetricNames          `protobuf:"varint,1,opt,name=metric_id,json=metricId,proto3,enum=dmi.MetricNames" json:"metric_id,omitempty"`
	MetricMetadata       *MetricMetaData      `protobuf:"bytes,2,opt,name=metric_metadata,json=metricMetadata,proto3" json:"metric_metadata,omitempty"`
	Value                *ComponentSensorData `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Metric) Reset()         { *m = Metric{} }
func (m *Metric) String() string { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()    {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{6}
}

func (m *Metric) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metric.Unmarshal(m, b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
}
func (m *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(m, src)
}
func (m *Metric) XXX_Size() int {
	return xxx_messageInfo_Metric.Size(m)
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

func (m *Metric) GetMetricId() MetricNames {
	if m != nil {
		return m.MetricId
	}
	return MetricNames_METRIC_NAME_UNDEFINED
}

func (m *Metric) GetMetricMetadata() *MetricMetaData {
	if m != nil {
		return m.MetricMetadata
	}
	return nil
}

func (m *Metric) GetValue() *ComponentSensorData {
	if m != nil {
		return m.Value
	}
	return nil
}

type GetMetricRequest struct {
	MetaData             *MetricMetaData `protobuf:"bytes,1,opt,name=meta_data,json=metaData,proto3" json:"meta_data,omitempty"`
	MetricId             MetricNames     `protobuf:"varint,2,opt,name=metric_id,json=metricId,proto3,enum=dmi.MetricNames" json:"metric_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *GetMetricRequest) Reset()         { *m = GetMetricRequest{} }
func (m *GetMetricRequest) String() string { return proto.CompactTextString(m) }
func (*GetMetricRequest) ProtoMessage()    {}
func (*GetMetricRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{7}
}

func (m *GetMetricRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMetricRequest.Unmarshal(m, b)
}
func (m *GetMetricRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMetricRequest.Marshal(b, m, deterministic)
}
func (m *GetMetricRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMetricRequest.Merge(m, src)
}
func (m *GetMetricRequest) XXX_Size() int {
	return xxx_messageInfo_GetMetricRequest.Size(m)
}
func (m *GetMetricRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMetricRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMetricRequest proto.InternalMessageInfo

func (m *GetMetricRequest) GetMetaData() *MetricMetaData {
	if m != nil {
		return m.MetaData
	}
	return nil
}

func (m *GetMetricRequest) GetMetricId() MetricNames {
	if m != nil {
		return m.MetricId
	}
	return MetricNames_METRIC_NAME_UNDEFINED
}

type GetMetricResponse struct {
	Status               Status   `protobuf:"varint,1,opt,name=status,proto3,enum=dmi.Status" json:"status,omitempty"`
	Reason               Reason   `protobuf:"varint,2,opt,name=reason,proto3,enum=dmi.Reason" json:"reason,omitempty"`
	Metric               *Metric  `protobuf:"bytes,3,opt,name=metric,proto3" json:"metric,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMetricResponse) Reset()         { *m = GetMetricResponse{} }
func (m *GetMetricResponse) String() string { return proto.CompactTextString(m) }
func (*GetMetricResponse) ProtoMessage()    {}
func (*GetMetricResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b6c2f1384c11ff5, []int{8}
}

func (m *GetMetricResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMetricResponse.Unmarshal(m, b)
}
func (m *GetMetricResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMetricResponse.Marshal(b, m, deterministic)
}
func (m *GetMetricResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMetricResponse.Merge(m, src)
}
func (m *GetMetricResponse) XXX_Size() int {
	return xxx_messageInfo_GetMetricResponse.Size(m)
}
func (m *GetMetricResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMetricResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetMetricResponse proto.InternalMessageInfo

func (m *GetMetricResponse) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_UNDEFINED_STATUS
}

func (m *GetMetricResponse) GetReason() Reason {
	if m != nil {
		return m.Reason
	}
	return Reason_UNDEFINED_REASON
}

func (m *GetMetricResponse) GetMetric() *Metric {
	if m != nil {
		return m.Metric
	}
	return nil
}

func init() {
	proto.RegisterEnum("dmi.MetricNames", MetricNames_name, MetricNames_value)
	proto.RegisterType((*MetricConfig)(nil), "dmi.MetricConfig")
	proto.RegisterType((*MetricsConfig)(nil), "dmi.MetricsConfig")
	proto.RegisterType((*ListMetricsResponse)(nil), "dmi.ListMetricsResponse")
	proto.RegisterType((*MetricsConfigurationRequest)(nil), "dmi.MetricsConfigurationRequest")
	proto.RegisterType((*MetricsConfigurationResponse)(nil), "dmi.MetricsConfigurationResponse")
	proto.RegisterType((*MetricMetaData)(nil), "dmi.MetricMetaData")
	proto.RegisterType((*Metric)(nil), "dmi.Metric")
	proto.RegisterType((*GetMetricRequest)(nil), "dmi.GetMetricRequest")
	proto.RegisterType((*GetMetricResponse)(nil), "dmi.GetMetricResponse")
}

func init() { proto.RegisterFile("dmi/hw_metrics_mgmt_service.proto", fileDescriptor_6b6c2f1384c11ff5) }

var fileDescriptor_6b6c2f1384c11ff5 = []byte{
	// 1008 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0x4b, 0x6f, 0xdb, 0x46,
	0x10, 0xc7, 0x4d, 0xa9, 0x71, 0xec, 0x91, 0x1f, 0xf4, 0xda, 0x4e, 0x14, 0xc5, 0x6d, 0x64, 0x19,
	0x2d, 0x0c, 0xb7, 0x96, 0x02, 0xe7, 0xd2, 0x47, 0x2e, 0xb4, 0x44, 0xdb, 0x44, 0x25, 0x5a, 0x58,
	0x51, 0x76, 0xd2, 0xcb, 0x62, 0x23, 0xae, 0x65, 0x02, 0x26, 0xa9, 0x92, 0x4b, 0xe7, 0xde, 0x4b,
	0x4f, 0x05, 0xfa, 0x40, 0x3f, 0x42, 0x6f, 0x7d, 0x7f, 0x8a, 0x3e, 0xef, 0xed, 0xf7, 0x68, 0x0b,
	0xf4, 0x56, 0x70, 0x97, 0x62, 0x57, 0x8e, 0xdc, 0x22, 0x40, 0x6e, 0xd2, 0x7f, 0x7e, 0xb3, 0xf3,
	0xdf, 0xe1, 0x72, 0x96, 0xb0, 0xe9, 0xfa, 0x5e, 0xe3, 0xfc, 0x29, 0xf1, 0x19, 0x8f, 0xbc, 0x41,
	0x4c, 0xfc, 0xa1, 0xcf, 0x49, 0xcc, 0xa2, 0x4b, 0x6f, 0xc0, 0xea, 0xa3, 0x28, 0xe4, 0x21, 0x2a,
	0xba, 0xbe, 0x57, 0x59, 0x49, 0xb9, 0x41, 0xe8, 0xfb, 0x61, 0x10, 0x4b, 0xbd, 0xb2, 0x20, 0x53,
	0xe5, 0xbf, 0xda, 0x87, 0x1a, 0x2c, 0x74, 0xc4, 0x22, 0xcd, 0x30, 0x38, 0xf3, 0x86, 0x68, 0x17,
	0xe6, 0xe5, 0xa2, 0xc4, 0x73, 0xcb, 0x5a, 0x55, 0xdb, 0x5e, 0xda, 0xd3, 0xeb, 0xae, 0xef, 0xd5,
	0x25, 0x65, 0x53, 0x9f, 0xc5, 0x78, 0x4e, 0x22, 0x96, 0x8b, 0xb6, 0x60, 0xd1, 0x8b, 0xc9, 0x40,
	0xe4, 0x26, 0x11, 0x73, 0xcb, 0x85, 0xaa, 0xb6, 0x3d, 0x87, 0x17, 0xbc, 0xb8, 0x99, 0x6b, 0x29,
	0x34, 0x0a, 0x2f, 0x2e, 0x88, 0x17, 0x70, 0x16, 0x5d, 0xd2, 0x8b, 0x72, 0xb1, 0xaa, 0x6d, 0x2f,
	0xe2, 0x85, 0x54, 0xb4, 0x32, 0xad, 0xf6, 0x10, 0x16, 0x65, 0x89, 0x2c, 0x13, 0xbd, 0x0e, 0x37,
	0xb3, 0xed, 0x95, 0xb5, 0x6a, 0x71, 0xbb, 0xb4, 0xb7, 0xa2, 0xf8, 0x90, 0x0c, 0x1e, 0x13, 0xb5,
	0x8f, 0x34, 0x58, 0x6d, 0x7b, 0x31, 0xcf, 0x96, 0xc0, 0x2c, 0x1e, 0x85, 0x41, 0xcc, 0xd0, 0x16,
	0xcc, 0xc6, 0x9c, 0xf2, 0x24, 0xce, 0xf6, 0x52, 0x12, 0x6b, 0xf4, 0x84, 0x84, 0xb3, 0x50, 0x0a,
	0x45, 0x8c, 0xc6, 0x61, 0x20, 0xdc, 0x8f, 0x21, 0x2c, 0x24, 0x9c, 0x85, 0xd0, 0x1b, 0xff, 0xda,
	0x49, 0xed, 0x97, 0xf6, 0x90, 0x62, 0x27, 0xbe, 0xea, 0xe7, 0x7b, 0x0d, 0xee, 0x4e, 0x84, 0x92,
	0x88, 0x72, 0x2f, 0x0c, 0x30, 0x7b, 0x3f, 0x61, 0x31, 0x47, 0x3b, 0x50, 0x72, 0x59, 0xfa, 0xb4,
	0x48, 0x92, 0x64, 0x8d, 0x2e, 0xed, 0xcd, 0x8b, 0x15, 0xfb, 0x89, 0xe7, 0x62, 0x90, 0xd1, 0xf4,
	0x37, 0xaa, 0xc3, 0xcd, 0xc1, 0x39, 0x0d, 0x86, 0x2c, 0x16, 0xfe, 0xa6, 0x56, 0x3e, 0x9a, 0xc1,
	0x63, 0x08, 0xed, 0x80, 0x1e, 0xb1, 0x98, 0x71, 0xc2, 0x43, 0xe2, 0xb2, 0x33, 0x9a, 0x5c, 0x70,
	0x61, 0x79, 0xee, 0x68, 0x06, 0x2f, 0x89, 0x88, 0x13, 0xb6, 0xa4, 0xbe, 0x5f, 0x82, 0xf9, 0x70,
	0xc4, 0xa4, 0xb7, 0xda, 0x39, 0x6c, 0x4c, 0xf7, 0xfc, 0xa2, 0x9b, 0x59, 0xfb, 0x5c, 0x83, 0x25,
	0x59, 0xaa, 0xc3, 0x38, 0x6d, 0x51, 0x4e, 0x9f, 0xab, 0x23, 0xf7, 0x61, 0x69, 0x10, 0xfa, 0xa3,
	0x30, 0x60, 0x01, 0x97, 0x78, 0xe1, 0x2a, 0xbe, 0x98, 0x03, 0x22, 0xe3, 0x55, 0x35, 0x23, 0xa0,
	0x3e, 0x13, 0x1d, 0x99, 0x57, 0xb0, 0xf4, 0x64, 0xd7, 0xbe, 0xd0, 0x60, 0x56, 0xfa, 0x7a, 0xde,
	0x17, 0xe1, 0x21, 0x2c, 0x67, 0xb8, 0xcf, 0x38, 0x75, 0x29, 0xa7, 0x99, 0xa7, 0x55, 0x25, 0x69,
	0xbc, 0x59, 0xbc, 0xe4, 0xe7, 0xff, 0x53, 0x14, 0xd5, 0xe1, 0xc6, 0x25, 0xbd, 0x48, 0x58, 0x76,
	0xb4, 0xca, 0x22, 0xa7, 0x39, 0xb6, 0xd6, 0x63, 0x41, 0x1c, 0x46, 0x22, 0x51, 0x62, 0xb5, 0x18,
	0xf4, 0x43, 0x96, 0x1d, 0xf6, 0xf1, 0x91, 0xba, 0x2f, 0x0c, 0x53, 0x22, 0x6a, 0x6b, 0xd7, 0xd7,
	0x4e, 0x3d, 0xcb, 0x96, 0x4f, 0x6c, 0xb1, 0xf0, 0x7f, 0x5b, 0xac, 0x7d, 0xa0, 0xc1, 0x8a, 0x52,
	0xf5, 0x85, 0xbf, 0x61, 0x5b, 0x30, 0x2b, 0x6b, 0x65, 0x5d, 0x28, 0x29, 0x5e, 0x70, 0x16, 0xda,
	0xf9, 0xfd, 0x06, 0x94, 0x14, 0x7b, 0xe8, 0x0e, 0xac, 0x77, 0x4c, 0x07, 0x5b, 0x4d, 0x62, 0x1b,
	0x1d, 0x93, 0xf4, 0xed, 0x96, 0x79, 0x60, 0xd9, 0x66, 0x4b, 0x9f, 0x41, 0x6b, 0xa0, 0x67, 0xa1,
	0x03, 0xc3, 0x26, 0xbd, 0xae, 0x69, 0xb6, 0x74, 0x0d, 0xad, 0xc2, 0x72, 0xa6, 0x36, 0xbb, 0x7d,
	0xe2, 0x98, 0x9d, 0xae, 0xee, 0xa2, 0x7b, 0x70, 0x57, 0x11, 0xfb, 0x3d, 0xe3, 0xd0, 0x24, 0x5d,
	0x13, 0x37, 0x4d, 0xdb, 0x31, 0x0e, 0x4d, 0x9d, 0xa1, 0x0d, 0xb8, 0x9d, 0x01, 0x0e, 0x36, 0xec,
	0x5e, 0xd3, 0xb4, 0x4e, 0x4c, 0x2c, 0xb3, 0x7f, 0xd0, 0xd0, 0x3d, 0xa8, 0x4c, 0x89, 0x9e, 0x1c,
	0xb7, 0x45, 0xf6, 0x8f, 0xda, 0x35, 0xe9, 0xfb, 0x96, 0xd1, 0xd3, 0x7f, 0xd2, 0x50, 0x35, 0xaf,
	0xae, 0x46, 0xf1, 0x23, 0xd2, 0x3d, 0x3e, 0x35, 0xb1, 0xfe, 0xf3, 0x75, 0x84, 0x33, 0x26, 0x7e,
	0xd1, 0x50, 0x0d, 0x5e, 0x9e, 0x42, 0x9c, 0x1a, 0x27, 0x66, 0xdb, 0xb4, 0x0f, 0x9d, 0x23, 0xfd,
	0x57, 0x0d, 0xad, 0xe7, 0x0d, 0x69, 0x59, 0xbd, 0x77, 0xa5, 0xfb, 0x2f, 0x0b, 0xe8, 0x0e, 0xac,
	0xa9, 0x72, 0xd3, 0xe8, 0x1a, 0x4d, 0xcb, 0x79, 0xac, 0x7f, 0x55, 0x40, 0xb7, 0x60, 0x45, 0x0d,
	0x89, 0xc6, 0xe8, 0x5f, 0x17, 0xd0, 0x26, 0x6c, 0x3c, 0xa3, 0xab, 0x0d, 0xfb, 0xa6, 0x80, 0x5e,
	0x83, 0x4d, 0x15, 0xc1, 0xa6, 0xd1, 0x22, 0xa7, 0xd8, 0x72, 0x26, 0xb8, 0x6f, 0x0b, 0x68, 0x1b,
	0xb6, 0x54, 0xee, 0xc0, 0xe8, 0xb7, 0x9d, 0xc7, 0xa4, 0x69, 0xb6, 0xdb, 0x3d, 0x95, 0xfc, 0xae,
	0x80, 0xd6, 0xf2, 0x27, 0x87, 0x8d, 0x8e, 0x74, 0xff, 0x71, 0x11, 0x95, 0x61, 0x55, 0x51, 0x73,
	0xf3, 0x9f, 0x14, 0x95, 0xed, 0xa6, 0x11, 0xe9, 0xfd, 0xd3, 0xa2, 0xd2, 0xcb, 0x5c, 0x56, 0x0b,
	0x7d, 0xa6, 0x26, 0x8a, 0xf6, 0x92, 0x8e, 0xf1, 0x48, 0xff, 0xa3, 0x88, 0x6e, 0x03, 0x9a, 0x90,
	0xe5, 0x8a, 0x7f, 0x16, 0x95, 0xde, 0x2b, 0x01, 0x75, 0xcd, 0xbf, 0x54, 0xc6, 0xb2, 0x6d, 0x13,
	0x93, 0x5e, 0x1f, 0xe3, 0xe3, 0xbe, 0xdd, 0xb2, 0xec, 0x43, 0xb9, 0x95, 0xdf, 0x5e, 0xda, 0xfb,
	0x5b, 0x83, 0x57, 0x6c, 0xca, 0xbd, 0x4b, 0x96, 0x8d, 0xe1, 0x0e, 0x0d, 0xe8, 0x90, 0xf9, 0x62,
	0x04, 0x88, 0xbb, 0x1d, 0xbd, 0x09, 0x25, 0xe5, 0x9a, 0x43, 0xcb, 0xe2, 0x15, 0x39, 0xa2, 0x91,
	0xfb, 0x94, 0x46, 0xcc, 0x6a, 0x55, 0xe4, 0xe4, 0x98, 0x76, 0x13, 0x52, 0xa8, 0xf4, 0x47, 0x2e,
	0xe5, 0x6c, 0xda, 0x88, 0x47, 0xd5, 0x67, 0xaf, 0x94, 0xc9, 0x1b, 0xab, 0xb2, 0xf9, 0x1f, 0x44,
	0x56, 0xe2, 0x6d, 0x98, 0xcf, 0xe7, 0x03, 0x5a, 0x17, 0xfc, 0xd5, 0x29, 0x55, 0xb9, 0x75, 0x55,
	0x96, 0xb9, 0xfb, 0xef, 0xbc, 0xf7, 0xd6, 0xd0, 0xe3, 0xe7, 0xc9, 0x93, 0xfa, 0x20, 0xf4, 0x1b,
	0xe1, 0x88, 0x05, 0x83, 0x30, 0x72, 0x1b, 0x72, 0xe8, 0xef, 0xfa, 0x79, 0x23, 0x76, 0xc5, 0x47,
	0xc4, 0x19, 0x1d, 0xb0, 0xc6, 0xe5, 0x83, 0xc6, 0x30, 0x6c, 0xb8, 0xbe, 0xf7, 0x64, 0x56, 0x7c,
	0xcc, 0x3c, 0xf8, 0x27, 0x00, 0x00, 0xff, 0xff, 0xfc, 0x65, 0x9d, 0xfb, 0x17, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// NativeMetricsManagementServiceClient is the client API for NativeMetricsManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type NativeMetricsManagementServiceClient interface {
	// List the supported metrics for the passed device.
	// This would be the first call that you make to know about the metrics that a particular device supports and
	// then use the UpdateMetricsConfiguration API to monitor only the required metrics.
	ListMetrics(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListMetricsResponse, error)
	// Updates the configuration of the list of metrics in the request
	// Acts upon single metric configuration, collection of a single metric can be started/stopped
	// by changing its configuration.
	//
	// This configuration is persisted across restart of the device or the device manager
	UpdateMetricsConfiguration(ctx context.Context, in *MetricsConfigurationRequest, opts ...grpc.CallOption) (*MetricsConfigurationResponse, error)
	// Get the instantenous value of a metric
	GetMetric(ctx context.Context, in *GetMetricRequest, opts ...grpc.CallOption) (*GetMetricResponse, error)
}

type nativeMetricsManagementServiceClient struct {
	cc *grpc.ClientConn
}

func NewNativeMetricsManagementServiceClient(cc *grpc.ClientConn) NativeMetricsManagementServiceClient {
	return &nativeMetricsManagementServiceClient{cc}
}

func (c *nativeMetricsManagementServiceClient) ListMetrics(ctx context.Context, in *HardwareID, opts ...grpc.CallOption) (*ListMetricsResponse, error) {
	out := new(ListMetricsResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeMetricsManagementService/ListMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeMetricsManagementServiceClient) UpdateMetricsConfiguration(ctx context.Context, in *MetricsConfigurationRequest, opts ...grpc.CallOption) (*MetricsConfigurationResponse, error) {
	out := new(MetricsConfigurationResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeMetricsManagementService/UpdateMetricsConfiguration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nativeMetricsManagementServiceClient) GetMetric(ctx context.Context, in *GetMetricRequest, opts ...grpc.CallOption) (*GetMetricResponse, error) {
	out := new(GetMetricResponse)
	err := c.cc.Invoke(ctx, "/dmi.NativeMetricsManagementService/GetMetric", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NativeMetricsManagementServiceServer is the server API for NativeMetricsManagementService service.
type NativeMetricsManagementServiceServer interface {
	// List the supported metrics for the passed device.
	// This would be the first call that you make to know about the metrics that a particular device supports and
	// then use the UpdateMetricsConfiguration API to monitor only the required metrics.
	ListMetrics(context.Context, *HardwareID) (*ListMetricsResponse, error)
	// Updates the configuration of the list of metrics in the request
	// Acts upon single metric configuration, collection of a single metric can be started/stopped
	// by changing its configuration.
	//
	// This configuration is persisted across restart of the device or the device manager
	UpdateMetricsConfiguration(context.Context, *MetricsConfigurationRequest) (*MetricsConfigurationResponse, error)
	// Get the instantenous value of a metric
	GetMetric(context.Context, *GetMetricRequest) (*GetMetricResponse, error)
}

func RegisterNativeMetricsManagementServiceServer(s *grpc.Server, srv NativeMetricsManagementServiceServer) {
	s.RegisterService(&_NativeMetricsManagementService_serviceDesc, srv)
}

func _NativeMetricsManagementService_ListMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HardwareID)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeMetricsManagementServiceServer).ListMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeMetricsManagementService/ListMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeMetricsManagementServiceServer).ListMetrics(ctx, req.(*HardwareID))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeMetricsManagementService_UpdateMetricsConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetricsConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeMetricsManagementServiceServer).UpdateMetricsConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeMetricsManagementService/UpdateMetricsConfiguration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeMetricsManagementServiceServer).UpdateMetricsConfiguration(ctx, req.(*MetricsConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NativeMetricsManagementService_GetMetric_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetricRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NativeMetricsManagementServiceServer).GetMetric(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dmi.NativeMetricsManagementService/GetMetric",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NativeMetricsManagementServiceServer).GetMetric(ctx, req.(*GetMetricRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NativeMetricsManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dmi.NativeMetricsManagementService",
	HandlerType: (*NativeMetricsManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMetrics",
			Handler:    _NativeMetricsManagementService_ListMetrics_Handler,
		},
		{
			MethodName: "UpdateMetricsConfiguration",
			Handler:    _NativeMetricsManagementService_UpdateMetricsConfiguration_Handler,
		},
		{
			MethodName: "GetMetric",
			Handler:    _NativeMetricsManagementService_GetMetric_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "dmi/hw_metrics_mgmt_service.proto",
}
