/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// XgPonDownstreamManagementPerformanceMonitoringHistoryDataClassID is the 16-bit ID for the OMCI
// Managed entity XG-PON downstream management performance monitoring history data
const XgPonDownstreamManagementPerformanceMonitoringHistoryDataClassID = ClassID(345) // 0x0159

var xgpondownstreammanagementperformancemonitoringhistorydataBME *ManagedEntityDefinition

// XgPonDownstreamManagementPerformanceMonitoringHistoryData (Class ID: #345 / 0x0159)
//	This ME collects PM data associated with the XG-PON TC layer. It collects counters associated
//	with downstream PLOAM and OMCI messages.
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an ANI-G.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the ANI-G. (R, set-by-create) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 ME that
//			contains PM threshold values. Since no threshold value attribute number exceeds 7, a threshold
//			data 2 ME is optional. (R,-W, set-by-create) (mandatory) (2-bytes)
//
//		Ploam Message Integrity Check Mic Error Count
//			PLOAM message integrity check (MIC) error count: This attribute counts MIC errors detected in
//			downstream PLOAM messages, either directed to this ONU or broadcast to all ONUs. (R) (optional)
//			(4-bytes)
//
//		Downstream Ploam Messages Count
//			This attribute counts PLOAM messages received, either directed to this ONU or broadcast to all
//			ONUs. (R) (optional) (4-bytes)
//
//		Profile Messages Received
//			This attribute counts the number of profile messages received, either directed to this ONU or
//			broadcast to all ONUs. In [ITU-T G.9807.1], this attribute is used for received burst_profile
//			message count.  (R) (optional) (4-bytes)
//
//		Ranging_Time Messages Received
//			This attribute counts the number of ranging_time messages received, either directed to this ONU
//			or broadcast to all ONUs. (R) (mandatory) (4-bytes)
//
//		Deactivate_Onu_Id Messages Received
//			Deactivate_ONU-ID messages received: This attribute counts the number of deactivate_ONU-ID
//			messages received, either directed to this ONU or broadcast to all ONUs. Deactivate_ONU-ID
//			messages do not reset this counter. (R) (optional) (4-bytes)
//
//		Disable_Serial_Number Messages Received
//			This attribute counts the number of disable_serial_number messages received, whose serial number
//			specified this ONU. (R) (optional) (4-bytes)
//
//		Request_Registration Messages Received
//			This attribute counts the number of request_registration messages received. (R) (optional)
//			(4-bytes)
//
//		Assign_Alloc_Id Messages Received
//			Assign_alloc-ID messages received: This attribute counts the number of assign_alloc-ID messages
//			received. (R) (optional) (4-bytes)
//
//		Key_Control Messages Received
//			This attribute counts the number of key_control messages received, either directed to this ONU
//			or broadcast to all ONUs. (R) (optional) (4-bytes)
//
//		Sleep_Allow Messages Received
//			This attribute counts the number of sleep_allow messages received, either directed to this ONU
//			or broadcast to all ONUs. (R) (optional) (4-bytes)
//
//		Baseline Omci Messages Received Count
//			This attribute counts the number of OMCI messages received in the baseline message format. (R)
//			(optional) (4-bytes)
//
//		Extended Omci Messages Received Count
//			This attribute counts the number of OMCI messages received in the extended message format. (R)
//			(optional) (4-bytes)
//
//		Assign_Onu_Id Messages Received
//			Assign_ONU-ID messages received: This attribute counts the number of assign_ONU-ID messages
//			received since the last re-boot. (R) (optional) (4-bytes)
//
//		Omci Mic Error Count
//			This attribute counts MIC errors detected in OMCI messages directed to this ONU. (R) (optional)
//			(4-bytes)
//
type XgPonDownstreamManagementPerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const XgPonDownstreamManagementPerformanceMonitoringHistoryData_IntervalEndTime = "IntervalEndTime"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_ThresholdData12Id = "ThresholdData12Id"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_PloamMessageIntegrityCheckMicErrorCount = "PloamMessageIntegrityCheckMicErrorCount"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_DownstreamPloamMessagesCount = "DownstreamPloamMessagesCount"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_ProfileMessagesReceived = "ProfileMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_RangingTimeMessagesReceived = "RangingTimeMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_DeactivateOnuIdMessagesReceived = "DeactivateOnuIdMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_DisableSerialNumberMessagesReceived = "DisableSerialNumberMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_RequestRegistrationMessagesReceived = "RequestRegistrationMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_AssignAllocIdMessagesReceived = "AssignAllocIdMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_KeyControlMessagesReceived = "KeyControlMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_SleepAllowMessagesReceived = "SleepAllowMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_BaselineOmciMessagesReceivedCount = "BaselineOmciMessagesReceivedCount"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_ExtendedOmciMessagesReceivedCount = "ExtendedOmciMessagesReceivedCount"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_AssignOnuIdMessagesReceived = "AssignOnuIdMessagesReceived"
const XgPonDownstreamManagementPerformanceMonitoringHistoryData_OmciMicErrorCount = "OmciMicErrorCount"

func init() {
	xgpondownstreammanagementperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "XgPonDownstreamManagementPerformanceMonitoringHistoryData",
		ClassID: XgPonDownstreamManagementPerformanceMonitoringHistoryDataClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xffff,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(XgPonDownstreamManagementPerformanceMonitoringHistoryData_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_ThresholdData12Id, PointerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_PloamMessageIntegrityCheckMicErrorCount, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, true, false, 3),
			4:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_DownstreamPloamMessagesCount, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, true, false, 4),
			5:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_ProfileMessagesReceived, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, true, false, 5),
			6:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_RangingTimeMessagesReceived, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_DeactivateOnuIdMessagesReceived, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, true, false, 7),
			8:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_DisableSerialNumberMessagesReceived, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, true, false, 8),
			9:  Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_RequestRegistrationMessagesReceived, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, true, false, 9),
			10: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_AssignAllocIdMessagesReceived, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, true, false, 10),
			11: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_KeyControlMessagesReceived, CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, true, false, 11),
			12: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_SleepAllowMessagesReceived, CounterAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, true, false, 12),
			13: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_BaselineOmciMessagesReceivedCount, CounterAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, true, false, 13),
			14: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_ExtendedOmciMessagesReceivedCount, CounterAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, true, false, 14),
			15: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_AssignOnuIdMessagesReceived, CounterAttributeType, 0x0002, 0, mapset.NewSetWith(Read), false, true, false, 15),
			16: Uint32Field(XgPonDownstreamManagementPerformanceMonitoringHistoryData_OmciMicErrorCount, CounterAttributeType, 0x0001, 0, mapset.NewSetWith(Read), false, true, false, 16),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			1: "PLOAM MIC error count",
			2: "OMCI MIC error count",
		},
	}
}

// NewXgPonDownstreamManagementPerformanceMonitoringHistoryData (class ID 345) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewXgPonDownstreamManagementPerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*xgpondownstreammanagementperformancemonitoringhistorydataBME, params...)
}
