/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// EthernetPerformanceMonitoringHistoryDataClassID is the 16-bit ID for the OMCI
// Managed entity Ethernet performance monitoring history data
const EthernetPerformanceMonitoringHistoryDataClassID = ClassID(24) // 0x0018

var ethernetperformancemonitoringhistorydataBME *ManagedEntityDefinition

// EthernetPerformanceMonitoringHistoryData (Class ID: #24 / 0x0018)
//	This ME collects some of the PM data for a physical Ethernet interface. Instances of this ME are
//	created and deleted by the OLT.
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an instance of the PPTP Ethernet UNI.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the PPTP Ethernet UNI. (R, setbycreate) (mandatory)
//			(2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 and 2 MEs
//			that contains PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Fcs Errors
//			This attribute counts frames received on a particular interface that were an integral number of
//			octets in length but failed the FCS check. The count is incremented when the MAC service returns
//			the frameCheckError status to the link layer control (LLC) or other MAC user. Received frames
//			for which multiple error conditions are obtained are counted according to the error status
//			presented to the LLC. (R) (mandatory) (4-bytes)
//
//		Excessive Collision Counter
//			This attribute counts frames whose transmission failed due to excessive collisions.-(R)
//			(mandatory) (4-bytes)
//
//		Late Collision Counter
//			This attribute counts the number of times that a collision was detected later than 512 bit times
//			into the transmission of a packet. (R) (mandatory) (4-bytes)
//
//		Frames Too Long
//			This attribute counts received frames that exceeded the maximum permitted frame size. The count
//			is incremented when the MAC service returns the frameTooLong status to the LLC. (R) (mandatory)
//			(4-bytes)
//
//		Buffer Overflows On Receive
//			This attribute counts the number of times that the receive buffer overflowed. (R) (mandatory)
//			(4-bytes)
//
//		Buffer Overflows On Transmit
//			This attribute counts the number of times that the transmit buffer overflowed. (R) (mandatory)
//			(4-bytes)
//
//		Single Collision Frame Counter
//			This attribute counts successfully transmitted frames whose transmission was delayed by exactly
//			one collision. (R) (mandatory) (4-bytes)
//
//		Multiple Collisions Frame Counter
//			This attribute counts successfully transmitted frames whose transmission was delayed by more
//			than one collision. (R) (mandatory) (4-bytes)
//
//		Sqe Counter
//			This attribute counts the number of times that the SQE test error message was generated by the
//			PLS sublayer. (R) (mandatory) (4-bytes)
//
//		Deferred Transmission Counter
//			This attribute counts frames whose first transmission attempt was delayed because the medium was
//			busy. The count does not include frames involved in collisions. (R) (mandatory) (4-bytes)
//
//		Internal Mac Transmit Error Counter
//			This attribute counts frames whose transmission failed due to an internal MAC sublayer transmit
//			error. (R) (mandatory) (4-bytes)
//
//		Carrier Sense Error Counter
//			This attribute counts the number of times that carrier sense was lost or never asserted when
//			attempting to transmit a frame. (R) (mandatory) (4-bytes)
//
//		Alignment Error Counter
//			This attribute counts received frames that were not an integral number of octets in length and
//			did not pass the FCS check. (R) (mandatory) (4-bytes)
//
//		Internal Mac Receive Error Counter
//			This attribute counts frames whose reception failed due to an internal MAC sublayer receive
//			error. (R) (mandatory) (4-bytes)
//
type EthernetPerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const EthernetPerformanceMonitoringHistoryData_IntervalEndTime = "IntervalEndTime"
const EthernetPerformanceMonitoringHistoryData_ThresholdData12Id = "ThresholdData12Id"
const EthernetPerformanceMonitoringHistoryData_FcsErrors = "FcsErrors"
const EthernetPerformanceMonitoringHistoryData_ExcessiveCollisionCounter = "ExcessiveCollisionCounter"
const EthernetPerformanceMonitoringHistoryData_LateCollisionCounter = "LateCollisionCounter"
const EthernetPerformanceMonitoringHistoryData_FramesTooLong = "FramesTooLong"
const EthernetPerformanceMonitoringHistoryData_BufferOverflowsOnReceive = "BufferOverflowsOnReceive"
const EthernetPerformanceMonitoringHistoryData_BufferOverflowsOnTransmit = "BufferOverflowsOnTransmit"
const EthernetPerformanceMonitoringHistoryData_SingleCollisionFrameCounter = "SingleCollisionFrameCounter"
const EthernetPerformanceMonitoringHistoryData_MultipleCollisionsFrameCounter = "MultipleCollisionsFrameCounter"
const EthernetPerformanceMonitoringHistoryData_SqeCounter = "SqeCounter"
const EthernetPerformanceMonitoringHistoryData_DeferredTransmissionCounter = "DeferredTransmissionCounter"
const EthernetPerformanceMonitoringHistoryData_InternalMacTransmitErrorCounter = "InternalMacTransmitErrorCounter"
const EthernetPerformanceMonitoringHistoryData_CarrierSenseErrorCounter = "CarrierSenseErrorCounter"
const EthernetPerformanceMonitoringHistoryData_AlignmentErrorCounter = "AlignmentErrorCounter"
const EthernetPerformanceMonitoringHistoryData_InternalMacReceiveErrorCounter = "InternalMacReceiveErrorCounter"

func init() {
	ethernetperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "EthernetPerformanceMonitoringHistoryData",
		ClassID: EthernetPerformanceMonitoringHistoryDataClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xffff,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(EthernetPerformanceMonitoringHistoryData_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(EthernetPerformanceMonitoringHistoryData_ThresholdData12Id, PointerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(EthernetPerformanceMonitoringHistoryData_FcsErrors, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(EthernetPerformanceMonitoringHistoryData_ExcessiveCollisionCounter, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(EthernetPerformanceMonitoringHistoryData_LateCollisionCounter, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(EthernetPerformanceMonitoringHistoryData_FramesTooLong, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(EthernetPerformanceMonitoringHistoryData_BufferOverflowsOnReceive, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(EthernetPerformanceMonitoringHistoryData_BufferOverflowsOnTransmit, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  Uint32Field(EthernetPerformanceMonitoringHistoryData_SingleCollisionFrameCounter, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(EthernetPerformanceMonitoringHistoryData_MultipleCollisionsFrameCounter, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint32Field(EthernetPerformanceMonitoringHistoryData_SqeCounter, CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, false, false, 11),
			12: Uint32Field(EthernetPerformanceMonitoringHistoryData_DeferredTransmissionCounter, CounterAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, false, false, 12),
			13: Uint32Field(EthernetPerformanceMonitoringHistoryData_InternalMacTransmitErrorCounter, CounterAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, false, false, 13),
			14: Uint32Field(EthernetPerformanceMonitoringHistoryData_CarrierSenseErrorCounter, CounterAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, false, false, 14),
			15: Uint32Field(EthernetPerformanceMonitoringHistoryData_AlignmentErrorCounter, CounterAttributeType, 0x0002, 0, mapset.NewSetWith(Read), false, false, false, 15),
			16: Uint32Field(EthernetPerformanceMonitoringHistoryData_InternalMacReceiveErrorCounter, CounterAttributeType, 0x0001, 0, mapset.NewSetWith(Read), false, false, false, 16),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0:  "FCS errors",
			1:  "Excessive collision counter",
			2:  "Late collision counter",
			3:  "Frames too long",
			4:  "Buffer overflows on receive",
			5:  "Buffer overflows on transmit",
			6:  "Single collision frame counter",
			7:  "Multiple collisions frame counter",
			8:  "SQE counter",
			9:  "Deferred transmission counter",
			10: "Internal MAC transmit error counter",
			11: "Carrier sense error counter",
			12: "Alignment error counter",
			13: "Internal MAC receive error counter",
		},
	}
}

// NewEthernetPerformanceMonitoringHistoryData (class ID 24) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewEthernetPerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*ethernetperformancemonitoringhistorydataBME, params...)
}
