/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// PseudowirePerformanceMonitoringHistoryDataClassID is the 16-bit ID for the OMCI
// Managed entity Pseudowire performance monitoring history data
const PseudowirePerformanceMonitoringHistoryDataClassID = ClassID(285) // 0x011d

var pseudowireperformancemonitoringhistorydataBME *ManagedEntityDefinition

// PseudowirePerformanceMonitoringHistoryData (Class ID: #285 / 0x011d)
//	This ME collects PM for a pseudowire TP. Most of the attributes monitor packets received from
//	the PSN, and may therefore be considered egress PM. For the most part, ingress PM is collected
//	at the CES PPTP ME.
//
//	NOTE - The pseudowire PM history data ME collects data similar, but not identical, to that
//	available from the MAC bridge port PM history data ME associated with a MAC bridge. When the
//	pseudowire is bridge-based, it may not be necessary to collect both.
//
//	Instances of this ME are created and deleted by the OLT.
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an instance of the pseudowire TP.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the pseudowire TP. (R, setbycreate) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 and 2 MEs
//			that contains PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Received Packets
//			This attribute counts the total number of packets, both payload and signalling, received in the
//			PSN to the TDM direction. (R) (mandatory) (4-bytes)
//
//		Transmitted Packets
//			This attribute counts the total number of packets, both payload and signalling, transmitted in
//			the TDM to the PSN direction. The count includes packets whose L bit is set and which may
//			therefore not contain a payload. (R) (mandatory) (4-bytes)
//
//		Missing Packets
//			This attribute counts the number of lost packets, as indicated by gaps in the control word
//			numbering sequence. Both payload and signalling packets, if any, contribute to this count. (R)
//			(mandatory) (4-bytes)
//
//		Misordered Packets Usable
//			Misordered packets, usable: This attribute counts the number of packets received out of order,
//			but which were able to be successfully re-ordered and played out. Both payload and signalling
//			packets, if any, contribute to this count. (R) (mandatory) (4-bytes)
//
//		Misordered Packets Dropped
//			This attribute counts the number of packets received out of sequence that were discarded, either
//			because the ONU did not support reordering or because it was too late to reorder them. Both
//			payload and signalling packets, if any, contribute to this count. (R) (mandatory) (4-bytes)
//
//		Playout Buffer Underruns_Overruns
//			Playout buffer underruns/overruns: This attribute counts the number of packets that were
//			discarded because they arrived too late or too early to be played out. Both payload and
//			signalling packets, if any, contribute to this count. (R) (mandatory) (4-bytes)
//
//		Malformed Packets
//			This attribute counts the number of malformed packets, e.g., because the packet length was not
//			as expected or because of an unexpected RTP payload type. Both payload and signalling packets,
//			if any, contribute to this count. (R) (mandatory) (4-bytes)
//
//		Stray Packets
//			This attribute counts the number of packets whose ECID or RTP SSRC failed to match the expected
//			value, or which are otherwise known to have been misdelivered. Stray packets are discarded
//			without affecting any of the other PM counters. Both payload and signalling packets, if any,
//			contribute to this count. (R) (mandatory) (4-bytes)
//
//		Remote Packet Loss
//			This attribute counts received packets whose R bit is set, indicating the loss of packets at the
//			far end. Both payload and signalling packets, if any, contribute to this count. (R) (mandatory)
//			(4-bytes)
//
//		Tdm L_Bit Packets Transmitted
//			TDM L-bit packets transmitted: This attribute counts the number of packets transmitted with the
//			L bit set, indicating a near-end TDM fault. Both payload and signalling packets, if any,
//			contribute to this count. (R) (mandatory) (4-bytes)
//
//		Es
//			This attribute counts errored seconds. Any discarded, lost, malformed or unusable packet
//			received from the PSN during a given second causes this counter to increment. Both payload and
//			signalling packets, if any, contribute to this count. (R) (mandatory) (4-bytes)
//
//		Ses
//			This attribute counts severely errored seconds. The criterion for an SES may be configured
//			through the pseudowire maintenance profile ME. Both payload and signalling packets, if any,
//			contribute to this count. (R) (mandatory) (4-bytes)
//
//		Uas
//			This attribute counts unavailable seconds. An unavailable second begins at the onset of 10
//			consecutive SES and ends at the onset of 10 consecutive seconds that are not severely errored. A
//			service is unavailable if either its payload or its signalling, if any, are unavailable. During
//			unavailable time, only UAS should be counted; other anomalies should not be counted. (R)
//			(mandatory) (4-bytes)
//
type PseudowirePerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const PseudowirePerformanceMonitoringHistoryData_IntervalEndTime = "IntervalEndTime"
const PseudowirePerformanceMonitoringHistoryData_ThresholdData12Id = "ThresholdData12Id"
const PseudowirePerformanceMonitoringHistoryData_ReceivedPackets = "ReceivedPackets"
const PseudowirePerformanceMonitoringHistoryData_TransmittedPackets = "TransmittedPackets"
const PseudowirePerformanceMonitoringHistoryData_MissingPackets = "MissingPackets"
const PseudowirePerformanceMonitoringHistoryData_MisorderedPacketsUsable = "MisorderedPacketsUsable"
const PseudowirePerformanceMonitoringHistoryData_MisorderedPacketsDropped = "MisorderedPacketsDropped"
const PseudowirePerformanceMonitoringHistoryData_PlayoutBufferUnderrunsOverruns = "PlayoutBufferUnderrunsOverruns"
const PseudowirePerformanceMonitoringHistoryData_MalformedPackets = "MalformedPackets"
const PseudowirePerformanceMonitoringHistoryData_StrayPackets = "StrayPackets"
const PseudowirePerformanceMonitoringHistoryData_RemotePacketLoss = "RemotePacketLoss"
const PseudowirePerformanceMonitoringHistoryData_TdmLBitPacketsTransmitted = "TdmLBitPacketsTransmitted"
const PseudowirePerformanceMonitoringHistoryData_Es = "Es"
const PseudowirePerformanceMonitoringHistoryData_Ses = "Ses"
const PseudowirePerformanceMonitoringHistoryData_Uas = "Uas"

func init() {
	pseudowireperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "PseudowirePerformanceMonitoringHistoryData",
		ClassID: PseudowirePerformanceMonitoringHistoryDataClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xfffe,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(PseudowirePerformanceMonitoringHistoryData_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(PseudowirePerformanceMonitoringHistoryData_ThresholdData12Id, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_ReceivedPackets, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_TransmittedPackets, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_MissingPackets, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_MisorderedPacketsUsable, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_MisorderedPacketsDropped, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_PlayoutBufferUnderrunsOverruns, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  Uint32Field(PseudowirePerformanceMonitoringHistoryData_MalformedPackets, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(PseudowirePerformanceMonitoringHistoryData_StrayPackets, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint32Field(PseudowirePerformanceMonitoringHistoryData_RemotePacketLoss, CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, false, false, 11),
			12: Uint32Field(PseudowirePerformanceMonitoringHistoryData_TdmLBitPacketsTransmitted, CounterAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, false, false, 12),
			13: Uint32Field(PseudowirePerformanceMonitoringHistoryData_Es, CounterAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, false, false, 13),
			14: Uint32Field(PseudowirePerformanceMonitoringHistoryData_Ses, CounterAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, false, false, 14),
			15: Uint32Field(PseudowirePerformanceMonitoringHistoryData_Uas, CounterAttributeType, 0x0002, 0, mapset.NewSetWith(Read), false, false, false, 15),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0: "Missing packets",
			1: "Misordered packets, usable",
			2: "Misordered packets dropped",
			3: "Playout buffer underruns/overruns",
			4: "Malformed packets",
			5: "Stray packets",
			6: "Remote packet loss",
			7: "ES",
			8: "SES",
			9: "UAS",
		},
	}
}

// NewPseudowirePerformanceMonitoringHistoryData (class ID 285) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewPseudowirePerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*pseudowireperformancemonitoringhistorydataBME, params...)
}
