# ONU State Machine

In `BBSim` the device state is createdtained using a state machine library: [fsm](https://github.com/looplab/fsm).

Here is a list of possible state transitions in BBSim:

|Transition|Starting States|End State| Notes |
| --- | --- | --- | --- |
| - | - | created |
| discover | created | discovered |
| enable | discovered, disabled | enabled |
| receive_eapol_flow | enabled, gem_port_added | eapol_flow_received |
| add_gem_port | enabled, eapol_flow_received | gem_port_added | We need to wait for both the flow and the gem port to come before moving to `auth_started` |
| start_auth | eapol_flow_received, gem_port_added | auth_started |
| eap_start_sent | auth_started | eap_start_sent |
| eap_response_identity_sent | eap_start_sent | eap_response_identity_sent |
| eap_response_challenge_sent | eap_response_identity_sent | eap_response_challenge_sent |
| eap_response_success_received | eap_response_challenge_sent | eap_response_success_received |
| auth_failed | auth_started, eap_start_sent, eap_response_identity_sent, eap_response_challenge_sent | auth_failed |
| start_dhcp | eap_response_success_received | dhcp_started |
| dhcp_discovery_sent | dhcp_started | dhcp_discovery_sent |
| dhcp_request_sent | dhcp_discovery_sent | dhcp_request_sent |
| dhcp_ack_received | dhcp_request_sent | dhcp_ack_received |
| dhcp_failed | dhcp_started, dhcp_discovery_sent, dhcp_request_sent | dhcp_failed |


In addition some transition can be forced via the API:

|Transition|Starting States|End State| Notes |
| --- | --- | --- | --- |
| disable | eap_response_success_received, auth_failed, dhcp_ack_received, dhcp_failed | disabled | Emulates a devide mulfunction. Sends a `DyingGaspInd` and then an `OnuIndication{OperState: 'down'}`|