/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// OnuGClassID is the 16-bit ID for the OMCI
// Managed entity ONU-G
const OnuGClassID = ClassID(256) // 0x0100

var onugBME *ManagedEntityDefinition

// OnuG (Class ID: #256 / 0x0100)
//	This ME represents the ONU as equipment. The ONU automatically creates an instance of this ME.
//	It assigns values to read-only attributes according to data within the ONU itself.
//
//	This ME has evolved from the ONT-G of [ITUT G.984.4].
//
//	Relationships
//		In ITU-T GTC based PON applications, all other MEs in this Recommendation are related directly
//		or indirectly to the ONU-G entity.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. There is only one instance, number
//			0. (R) (mandatory) (2-bytes)
//
//		Vendor Id
//			This attribute identifies the vendor of the ONU. It is the same as the four most significant
//			bytes of the ONU serial number as specified in the respective transmission convergence (TC)
//			layer specification. (R) (mandatory) (4-bytes)
//
//		Version
//			This attribute identifies the version of the ONU as defined by the vendor. The character value 0
//			indicates that version information is not available or applicable. (R) (mandatory) (14-bytes)
//
//		Serial Number
//			The serial number is unique for each ONU. It is defined in the respective TC layer specification
//			and contains the vendor ID and version number. The first four bytes are an ASCII-encoded four-
//			letter vendor ID. The second four bytes are a binary encoded serial number, under the control of
//			the ONU vendor. (R) (mandatory) (8-bytes)
//
//		Traffic Management Option
//			This attribute identifies the upstream traffic management function implemented in the ONU. There
//			are three options:
//
//			0	Priority controlled and flexibly scheduled upstream traffic. The traffic scheduler and
//			priority queue mechanism are used for upstream traffic.
//
//			1	Rate controlled upstream traffic. The maximum upstream traffic of each individual connection
//			is guaranteed by shaping.
//
//			2	Priority and rate controlled. The traffic scheduler and priority queue mechanism are used for
//			upstream traffic. The maximum upstream traffic of each individual connection is guaranteed by
//			shaping.
//
//			For a further explanation, see Appendix II.
//
//			Downstream priority queues are managed via the GEM port network CTP ME.
//
//			Upon ME instantiation, the ONU sets this attribute to the value that describes its
//			implementation. The OLT must adapt its model to conform to the ONU's selection. (R) (mandatory)
//			(1-byte)
//
//		Deprecated
//			This attribute is not used. If it is present, it should be set to 0. (R) (optional) (1-byte)
//
//		Battery Backup
//			This Boolean attribute controls whether the ONU performs backup battery monitoring (assuming it
//			is capable of doing so). False disables battery alarm monitoring; true enables battery alarm
//			monitoring. (R,-W) (mandatory) (1-byte)
//
//		Administrative State
//			This attribute locks (1) and unlocks (0) the functions performed by the ONU as an entirety.
//			Administrative state is further described in clause A.1.6. (R,-W) (mandatory) (1-byte)
//
//		Operational State
//			This attribute reports whether the ME is currently capable of performing its function. Valid
//			values are enabled (0) and disabled (1). (R) (optional) (1-byte)
//
//		Onu Survival Time
//			This attribute indicates the minimum guaranteed time in milliseconds between the loss of
//			external power and the silence of the ONU. This does not include survival time attributable to a
//			backup battery. The value zero implies that the actual time is not known. (R) (optional)
//			(1-byte)
//
//		Logical Onu Id
//			This attribute provides a way for the ONU to identify itself. It is a text string, null
//			terminated if it is shorter than 24 bytes, with a null default value. The mechanism for creation
//			or modification of this information is beyond the scope of this Recommendation, but might
//			include, for example, a web page displayed to a user. (R) (optional) (24 bytes)
//
//		Logical Password
//			This attribute provides a way for the ONU to submit authentication credentials. It is a text
//			string, null terminated if it is shorter than 12 bytes, with a null default value. The mechanism
//			for creation or modification of this information is beyond the scope of this Recommendation. (R)
//			(optional) (12-bytes)
//
//		Credentials Status
//			This attribute permits the OLT to signal to the ONU whether its credentials are valid or not.
//			The behaviour of the ONU is not specified, but might, for example, include displaying an error
//			screen to the user. (R, W) (optional) (1-byte)
//
//			Values include:
//
//			0	Initial state, status indeterminate
//
//			1	Successful authentication
//
//			2	Logical ONU ID (LOID) error
//
//			3	Password error
//
//			4	Duplicate LOID
//
//			Other values are reserved.
//
//		Extended Tc_Layer Options
//			Extended TC-layer options: This attribute is meaningful in ITU-T G.984 systems only. It is a bit
//			map that defines whether the ONU supports (1) or does not support (0) various optional TC-layer
//			capabilities of [ITU-T G.984.3]. Bits are assigned as follows.
//
//			Bit	Meaning
//
//			1 (LSB)	Annex C  of [ITU-T G.984.3], PON-ID maintenance.
//
//			2	Annex D of [ITU-T G.984.3], PLOAM channel enhancements: swift_POPUP and Ranging_adjustment
//			messages.
//
//			3..16	Reserved
//
//			(R) (optional) (2-bytes)
//
type OnuG struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const OnuG_VendorId = "VendorId"
const OnuG_Version = "Version"
const OnuG_SerialNumber = "SerialNumber"
const OnuG_TrafficManagementOption = "TrafficManagementOption"
const OnuG_Deprecated = "Deprecated"
const OnuG_BatteryBackup = "BatteryBackup"
const OnuG_AdministrativeState = "AdministrativeState"
const OnuG_OperationalState = "OperationalState"
const OnuG_OnuSurvivalTime = "OnuSurvivalTime"
const OnuG_LogicalOnuId = "LogicalOnuId"
const OnuG_LogicalPassword = "LogicalPassword"
const OnuG_CredentialsStatus = "CredentialsStatus"
const OnuG_ExtendedTcLayerOptions = "ExtendedTcLayerOptions"

func init() {
	onugBME = &ManagedEntityDefinition{
		Name:    "OnuG",
		ClassID: OnuGClassID,
		MessageTypes: mapset.NewSetWith(
			Get,
			Reboot,
			Set,
			SynchronizeTime,
			Test,
		),
		AllowedAttributeMask: 0xfff8,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1:  MultiByteField(OnuG_VendorId, StringAttributeType, 0x8000, 4, toOctets("ICAgIA=="), mapset.NewSetWith(Read), false, false, false, 1),
			2:  MultiByteField(OnuG_Version, StringAttributeType, 0x4000, 14, toOctets("MAAAAAAAAAAAAAAAAAA="), mapset.NewSetWith(Read), false, false, false, 2),
			3:  MultiByteField(OnuG_SerialNumber, OctetsAttributeType, 0x2000, 8, toOctets("AAAAAAAAAAA="), mapset.NewSetWith(Read), false, false, false, 3),
			4:  ByteField(OnuG_TrafficManagementOption, EnumerationAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  ByteField(OnuG_Deprecated, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, true, true, 5),
			6:  ByteField(OnuG_BatteryBackup, EnumerationAttributeType, 0x0400, 0, mapset.NewSetWith(Read, Write), false, false, false, 6),
			7:  ByteField(OnuG_AdministrativeState, EnumerationAttributeType, 0x0200, 0, mapset.NewSetWith(Read, Write), false, false, false, 7),
			8:  ByteField(OnuG_OperationalState, EnumerationAttributeType, 0x0100, 0, mapset.NewSetWith(Read), true, true, false, 8),
			9:  ByteField(OnuG_OnuSurvivalTime, UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, true, false, 9),
			10: MultiByteField(OnuG_LogicalOnuId, OctetsAttributeType, 0x0040, 24, toOctets("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"), mapset.NewSetWith(Read), true, true, false, 10),
			11: MultiByteField(OnuG_LogicalPassword, OctetsAttributeType, 0x0020, 12, toOctets("AAAAAAAAAAAAAAAA"), mapset.NewSetWith(Read), true, true, false, 11),
			12: ByteField(OnuG_CredentialsStatus, EnumerationAttributeType, 0x0010, 0, mapset.NewSetWith(Read, Write), false, true, false, 12),
			13: Uint16Field(OnuG_ExtendedTcLayerOptions, BitFieldAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, true, false, 13),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0:  "Equipment alarm",
			1:  "Powering alarm",
			2:  "Battery missing",
			3:  "Battery failure",
			4:  "Battery low",
			5:  "Physical intrusion",
			6:  "ONU self-test failure",
			7:  "Dying gasp",
			8:  "Temperature yellow",
			9:  "Temperature red",
			10: "Voltage yellow",
			11: "Voltage red",
			12: "ONU manual power off",
			13: "Inv-Image",
			14: "PSE overload yellow",
			15: "PSE overload red",
		},
	}
}

// NewOnuG (class ID 256) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewOnuG(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*onugBME, params...)
}
