/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// EponDownstreamPerformanceMonitoringConfigurationClassID is the 16-bit ID for the OMCI
// Managed entity EPON downstream performance monitoring configuration
const EponDownstreamPerformanceMonitoringConfigurationClassID = ClassID(406) // 0x0196

var epondownstreamperformancemonitoringconfigurationBME *ManagedEntityDefinition

// EponDownstreamPerformanceMonitoringConfiguration (Class ID: #406 / 0x0196)
//	This ME represents window sizes and threshold values for EPON downstream PM operations which are
//	defined in [IEEE 802.3] as: errored symbol period, errored frame, errored frame period and
//	errored frame seconds summary.
//
//	The EPON ONU automatically instantiates an instance of this ME for each ANI-E.
//
//	Relationships
//		An instance of this ME is associated with an ANI-E.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the ANI-E. (R, set-by-create) (mandatory) (2-bytes)
//
//		Errored Symbol Period Window
//			This attribute specifies the number of symbols in the measurement period, as defined in clause
//			57.5.3.1 of [IEEE 802.3]. (R, W) (optional) (8-bytes)
//
//		Errored Symbol Period Threshold
//			This attribute specifies the threshold of errored symbols for generating an event report, as
//			defined in clause 57.5.3.1 of [IEEE 802.3]. (R, W) (optional) (8-bytes)
//
//		Errored Frame Window
//			This attribute specifies the duration in units of 100-ms of the measurement period, as defined
//			in clause 57.5.3.2 of [IEEE 802.3]. (R, W) (optional) (2-bytes)
//
//		Errored Frame Threshold
//			This attribute specifies the threshold of errored frames for generating an event report, as
//			defined in clause 57.5.3.2 of [IEEE 802.3]. (R, W) (optional) (4-bytes)
//
//		Errored Frame Period Window
//			This attribute specifies the duration in terms of frames of the measurement period, as defined
//			in clause 57.5.3.3 of [IEEE 802.3]. (R, W) (optional) (4-bytes)
//
//		Errored Frame Period Threshold
//			This attribute specifies the threshold of errored frames for generating an event report, as
//			defined in clause 57.5.3.3 of [IEEE 802.3]. (R, W) (optional) (4-bytes)
//
//		Errored Frame Seconds Summary Window
//			This attribute specifies the duration in units of 100ms of the measurement period, as defined in
//			clause-57.5.3.4 of [IEEE-802.3]. (R, W) (optional) (2-bytes)
//
//		Errored Frame Seconds Summary Threshold
//			This attribute specifies the threshold of errored frame seconds for generating an event report,
//			as defined in clause 57.5.3.4 of [IEEE 802.3]. (R, W) (optional) (2-bytes)
//
type EponDownstreamPerformanceMonitoringConfiguration struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const EponDownstreamPerformanceMonitoringConfiguration_ErroredSymbolPeriodWindow = "ErroredSymbolPeriodWindow"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredSymbolPeriodThreshold = "ErroredSymbolPeriodThreshold"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameWindow = "ErroredFrameWindow"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameThreshold = "ErroredFrameThreshold"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredFramePeriodWindow = "ErroredFramePeriodWindow"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredFramePeriodThreshold = "ErroredFramePeriodThreshold"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameSecondsSummaryWindow = "ErroredFrameSecondsSummaryWindow"
const EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameSecondsSummaryThreshold = "ErroredFrameSecondsSummaryThreshold"

func init() {
	epondownstreamperformancemonitoringconfigurationBME = &ManagedEntityDefinition{
		Name:    "EponDownstreamPerformanceMonitoringConfiguration",
		ClassID: EponDownstreamPerformanceMonitoringConfigurationClassID,
		MessageTypes: mapset.NewSetWith(
			Get,
			Set,
		),
		AllowedAttributeMask: 0xff00,
		AttributeDefinitions: AttributeDefinitionMap{
			0: Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1: Uint64Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredSymbolPeriodWindow, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read, Write), false, true, false, 1),
			2: Uint64Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredSymbolPeriodThreshold, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, Write), false, true, false, 2),
			3: Uint16Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameWindow, UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read, Write), false, true, false, 3),
			4: Uint32Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameThreshold, UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read, Write), false, true, false, 4),
			5: Uint32Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredFramePeriodWindow, UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read, Write), false, true, false, 5),
			6: Uint32Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredFramePeriodThreshold, UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read, Write), false, true, false, 6),
			7: Uint16Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameSecondsSummaryWindow, UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read, Write), false, true, false, 7),
			8: Uint16Field(EponDownstreamPerformanceMonitoringConfiguration_ErroredFrameSecondsSummaryThreshold, UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read, Write), false, true, false, 8),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
	}
}

// NewEponDownstreamPerformanceMonitoringConfiguration (class ID 406) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewEponDownstreamPerformanceMonitoringConfiguration(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*epondownstreamperformancemonitoringconfigurationBME, params...)
}
