/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// EfmBondingLinkPerformanceMonitoringHistoryDataClassID is the 16-bit ID for the OMCI
// Managed entity EFM bonding link performance monitoring history data
const EfmBondingLinkPerformanceMonitoringHistoryDataClassID = ClassID(422) // 0x01a6

var efmbondinglinkperformancemonitoringhistorydataBME *ManagedEntityDefinition

// EfmBondingLinkPerformanceMonitoringHistoryData (Class ID: #422 / 0x01a6)
//	This ME collects PM data as seen at the xTU-C. Instances of this ME are created and deleted by
//	the OLT.
//
//	Relationships
//		An instance of this ME is associated with an xDSL UNI.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the EFM bonding link. (R, setbycreate) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 and 2 MEs
//			that contain PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Rx Errored Fragments
//			Clause 45.2.3.29 of [IEEE 802.3]. (R) (mandatory) (4-bytes)
//
//		Rx Small Fragments
//			Clause 45.2.3.30 of [IEEE 802.3]. (R) (mandatory) (4-bytes)
//
//		Rx Large Fragments
//			Clause 45.2.3.31 of [IEEE 802.3]. (R) (mandatory) (4-bytes)
//
//		Rx Discarded Fragments
//			Clause 45.2.3.32 of [IEEE 802.3]. (R) (mandatory) (4-bytes)
//
//		Rx Fcs Errors
//			Clause 45.2.6.11 of [IEEE 802.3]. (R) (mandatory) (4-bytes)
//
//		Rx Coding Errors
//			Clause 45.2.6.12 of [IEEE 802.3]. (R) (mandatory) (4-bytes)
//
//		Rx Fragments
//			Number of fragments received over this link. (R) (mandatory) (4-bytes)
//
//		Tx Fragments
//			Number of fragments transmitted over this link. (R) (mandatory) (4-bytes)
//
type EfmBondingLinkPerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const EfmBondingLinkPerformanceMonitoringHistoryData_IntervalEndTime = "IntervalEndTime"
const EfmBondingLinkPerformanceMonitoringHistoryData_ThresholdData12Id = "ThresholdData12Id"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxErroredFragments = "RxErroredFragments"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxSmallFragments = "RxSmallFragments"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxLargeFragments = "RxLargeFragments"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxDiscardedFragments = "RxDiscardedFragments"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxFcsErrors = "RxFcsErrors"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxCodingErrors = "RxCodingErrors"
const EfmBondingLinkPerformanceMonitoringHistoryData_RxFragments = "RxFragments"
const EfmBondingLinkPerformanceMonitoringHistoryData_TxFragments = "TxFragments"

func init() {
	efmbondinglinkperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "EfmBondingLinkPerformanceMonitoringHistoryData",
		ClassID: EfmBondingLinkPerformanceMonitoringHistoryDataClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xffc0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(EfmBondingLinkPerformanceMonitoringHistoryData_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(EfmBondingLinkPerformanceMonitoringHistoryData_ThresholdData12Id, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxErroredFragments, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxSmallFragments, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxLargeFragments, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxDiscardedFragments, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxFcsErrors, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxCodingErrors, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_RxFragments, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(EfmBondingLinkPerformanceMonitoringHistoryData_TxFragments, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
	}
}

// NewEfmBondingLinkPerformanceMonitoringHistoryData (class ID 422) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewEfmBondingLinkPerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*efmbondinglinkperformancemonitoringhistorydataBME, params...)
}
