/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */
package generated

import "github.com/deckarep/golang-set"

const VoipFeatureAccessCodesClassId ClassID = ClassID(147)

var voipfeatureaccesscodesBME *ManagedEntityDefinition

// VoipFeatureAccessCodes (class ID #147)
//	The VoIP feature access codes ME defines administrable feature access codes for the VoIP
//	subscriber. It is optional for ONUs that support VoIP services. If a non-OMCI interface is used
//	to manage VoIP signalling, this ME is unnecessary.
//
//	Instances of this ME are created and deleted by the OLT. A VoIP feature access codes instance is
//	needed for each unique set of feature access code attributes.
//
//	Relationships
//		An instance of this ME may be associated with one or more SIP user data MEs.
//
//	Attributes
//		Managed Entity Id
//			Managed entity ID: This attribute uniquely identifies each instance of this ME. (R) (mandatory)
//			(2 bytes)
//
//		Cancel Call Waiting
//			Cancel call waiting:	(R, W) (optional) (5 bytes)
//
//		Call Hold
//			Call hold:		(R, W) (optional) (5 bytes)
//
//		Call Park
//			Call park:		(R, W) (optional) (5 bytes)
//
//		Caller Id Activate
//			Caller ID activate:	(R, W) (optional) (5 bytes)
//
//		Caller Id Deactivate
//			Caller ID deactivate:	(R, W) (optional) (5 bytes)
//
//		Do Not Disturb Activation
//			Do not disturb activation:	(R, W) (optional) (5 bytes)
//
//		Do Not Disturb Deactivation
//			Do not disturb deactivation:	(R, W) (optional) (5 bytes)
//
//		Do Not Disturb Pin Change
//			Do not disturb PIN change:	(R, W) (optional) (5 bytes)
//
//		Emergency Service Number
//			Emergency service number:	(R, W) (optional) (5 bytes)
//
//		Intercom Service
//			Intercom service:	(R, W) (optional) (5 bytes)
//
//		Unattended_Blind Call Transfer
//			Unattended/blind call transfer:	(R, W) (optional) (5 bytes)
//
//		Attended Call Transfer
//			Attended call transfer:	(R, W) (optional) (5 bytes)
//
type VoipFeatureAccessCodes struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	voipfeatureaccesscodesBME = &ManagedEntityDefinition{
		Name:    "VoipFeatureAccessCodes",
		ClassID: 147,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0XFFF0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", 0, mapset.NewSetWith(Read), false, false, false, false, 0),
			1:  MultiByteField("CancelCallWaiting", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 1),
			2:  MultiByteField("CallHold", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 2),
			3:  MultiByteField("CallPark", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 3),
			4:  MultiByteField("CallerIdActivate", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 4),
			5:  MultiByteField("CallerIdDeactivate", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 5),
			6:  MultiByteField("DoNotDisturbActivation", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 6),
			7:  MultiByteField("DoNotDisturbDeactivation", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 7),
			8:  MultiByteField("DoNotDisturbPinChange", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 8),
			9:  MultiByteField("EmergencyServiceNumber", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 9),
			10: MultiByteField("IntercomService", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 10),
			11: MultiByteField("UnattendedBlindCallTransfer", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 11),
			12: MultiByteField("AttendedCallTransfer", 5, nil, mapset.NewSetWith(Read, Write), false, false, true, false, 12),
		},
	}
}

// NewVoipFeatureAccessCodes (class ID 147 creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from the wire, about to be sent on the wire.
func NewVoipFeatureAccessCodes(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(voipfeatureaccesscodesBME, params...)
}
