/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// TwdmChannelTuningPerformanceMonitoringHistoryDataPart2ClassID is the 16-bit ID for the OMCI
// Managed entity TWDM channel tuning performance monitoring history data part 2
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2ClassID = ClassID(450) // 0x01c2

var twdmchanneltuningperformancemonitoringhistorydatapart2BME *ManagedEntityDefinition

// TwdmChannelTuningPerformanceMonitoringHistoryDataPart2 (Class ID: #450 / 0x01c2)
//	This ME collects additional tuning-control-related PM data associated with the slot/circuit
//	pack, hosting one or more ANI-G MEs, for a specific TWDM channel. Instances of this ME are
//	created and deleted by the OLT.
//
//	The relevant events this ME is concerned with are counted towards the PM statistics associated
//	with the source TWDM channel. This ME contains the counters characterized as optional in clause
//	14 of [ITU-T- G.989.3].
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an instance of TWDM channel ME.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the TWDM channel ME. (R, setbycreate) (mandatory) (2-bytes)
//
//		Interval End Time
//			This attribute identifies the most recently finished 15-min interval. (R) (mandatory) (1-byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 and 2 MEs
//			that contains PM threshold values. (R,-W, setbycreate) (mandatory) (2-bytes)
//
//		Tuning Control Requests Rejected_Ds_Albl
//			Tuning control requests rejected/DS_ALBL: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and DS_ALBL response code, indicating downstream
//			administrative label inconsistency. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Ds_Void
//			Tuning control requests rejected/DS_VOID: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and DS_VOID response code, indicating that the target
//			downstream wavelength channel descriptor is void. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Ds_Part
//			Tuning control requests rejected/DS_PART: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and DS_PART response code, indicating that tuning request
//			involves channel partition violation. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Ds_Tunr
//			Tuning control requests rejected/DS_TUNR: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and DS_TUNR response code, indicating that the target DS
//			wavelength channel is out of receiver tuning range. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Ds_Lnrt
//			Tuning control requests rejected/DS_LNRT: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and DS_LNRT response code, indicating downstream line rate
//			inconsistency in the target channel. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Ds_Lncd
//			Tuning control requests rejected/DS_LNCD: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and DS_LNCD response code, indicating downstream line code
//			inconsistency in the target channel. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Albl
//			Tuning control requests rejected/US_ALBL: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_ALBL response code, indicating upstream administrative
//			label inconsistency. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Void
//			Tuning control requests rejected/US_VOID: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_VOID response code, indicating that the target upstream
//			wavelength channel descriptor is void. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Tunr
//			Tuning control requests rejected/US_TUNR: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_TUNR response code, indicating that the target US
//			wavelength channel is out of transmitter tuning range. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Clbr
//			Tuning control requests rejected/US_CLBR: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_CLBR response code, indicating that the transmitter has
//			insufficient calibration accuracy in the target US wavelength channel. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Lktp
//			Tuning control requests rejected/US_LKTP: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_LKTP response code, indicating upstream optical link
//			type inconsistency. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Lnrt
//			Tuning control requests rejected/US_LNRT: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_LNRT response code, indicating upstream line rate
//			inconsistency in the target channel. (R) (mandatory) (4-byte)
//
//		Tuning Control Requests Rejected_Us_Lncd
//			Tuning control requests rejected/US_LNCD: The counter of transmitted Tuning_Response PLOAM
//			messages with NACK operation code and US_LNCD response code, indicating upstream line code
//			inconsistency in the target channel. (R) (mandatory) (4-byte)
//
type TwdmChannelTuningPerformanceMonitoringHistoryDataPart2 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

// Attribute name constants

const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_IntervalEndTime = "IntervalEndTime"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_ThresholdData12Id = "ThresholdData12Id"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsAlbl = "TuningControlRequestsRejectedDsAlbl"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsVoid = "TuningControlRequestsRejectedDsVoid"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsPart = "TuningControlRequestsRejectedDsPart"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsTunr = "TuningControlRequestsRejectedDsTunr"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsLnrt = "TuningControlRequestsRejectedDsLnrt"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsLncd = "TuningControlRequestsRejectedDsLncd"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsAlbl = "TuningControlRequestsRejectedUsAlbl"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsVoid = "TuningControlRequestsRejectedUsVoid"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsTunr = "TuningControlRequestsRejectedUsTunr"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsClbr = "TuningControlRequestsRejectedUsClbr"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsLktp = "TuningControlRequestsRejectedUsLktp"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsLnrt = "TuningControlRequestsRejectedUsLnrt"
const TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsLncd = "TuningControlRequestsRejectedUsLncd"

func init() {
	twdmchanneltuningperformancemonitoringhistorydatapart2BME = &ManagedEntityDefinition{
		Name:    "TwdmChannelTuningPerformanceMonitoringHistoryDataPart2",
		ClassID: TwdmChannelTuningPerformanceMonitoringHistoryDataPart2ClassID,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
			GetCurrentData,
		),
		AllowedAttributeMask: 0xfffe,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field(ManagedEntityID, PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, 0),
			1:  ByteField(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_IntervalEndTime, UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, false, false, 1),
			2:  Uint16Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_ThresholdData12Id, UnsignedIntegerAttributeType, 0x4000, 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, 2),
			3:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsAlbl, CounterAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, false, false, 3),
			4:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsVoid, CounterAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, false, false, 4),
			5:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsPart, CounterAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, false, false, 5),
			6:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsTunr, CounterAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, false, false, 6),
			7:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsLnrt, CounterAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, false, false, 7),
			8:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedDsLncd, CounterAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, false, false, 8),
			9:  Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsAlbl, CounterAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, false, false, 9),
			10: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsVoid, CounterAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, false, false, 10),
			11: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsTunr, CounterAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, false, false, 11),
			12: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsClbr, CounterAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, false, false, 12),
			13: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsLktp, CounterAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, false, false, 13),
			14: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsLnrt, CounterAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, false, false, 14),
			15: Uint32Field(TwdmChannelTuningPerformanceMonitoringHistoryDataPart2_TuningControlRequestsRejectedUsLncd, CounterAttributeType, 0x0002, 0, mapset.NewSetWith(Read), false, false, false, 15),
		},
		Access:  CreatedByOlt,
		Support: UnknownSupport,
		Alarms: AlarmMap{
			0:  "Tuning control requests rejected/DS_ALBL",
			1:  "Tuning control requests rejected/DS_VOID",
			2:  "Tuning control requests rejected/DS_PART",
			3:  "Tuning control requests rejected/DS_TUNR",
			4:  "Tuning control requests rejected/DS_LNRT",
			5:  "Tuning control requests rejected/DS_LNCD",
			6:  "Tuning control requests rejected/US_ALBL",
			7:  "Tuning control requests rejected/US_VOID",
			8:  "Tuning control requests rejected/US_TUNR",
			9:  "Tuning control requests rejected/US_CLBR",
			10: "Tuning control requests rejected/US_LKTP",
			11: "Tuning control requests rejected/US_LNRT",
			12: "Tuning control requests rejected/US_LNCD",
		},
	}
}

// NewTwdmChannelTuningPerformanceMonitoringHistoryDataPart2 (class ID 450) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewTwdmChannelTuningPerformanceMonitoringHistoryDataPart2(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*twdmchanneltuningperformancemonitoringhistorydatapart2BME, params...)
}
