/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */
package generated

import "github.com/deckarep/golang-set"

const MacBridgePortFilterPreAssignTableClassId ClassID = ClassID(79)

var macbridgeportfilterpreassigntableBME *ManagedEntityDefinition

// MacBridgePortFilterPreAssignTable (class ID #79)
//	This ME provides an alternate approach to DA filtering from that supported through the MAC
//	bridge port filter table data ME. This alternate approach is useful when all groups of addresses
//	are stored beforehand in the ONU, and the MAC bridge port filter pre-assign table ME designates
//	which groups are valid or invalid for filtering. On a circuit pack in which all groups of
//	addresses are pre-assigned and stored locally, the ONU creates or deletes an instance of this ME
//	automatically upon creation or deletion of a MAC bridge port configuration data ME.
//
//	Relationships
//		An instance of this ME is associated with an instance of a MAC bridge port configuration data
//		ME.
//
//	Attributes
//		Managed Entity Id
//			Managed entity ID: This attribute uniquely identifies each instance of this ME. Through an
//			identical ID, this ME is implicitly linked to an instance of the MAC bridge port configuration
//			data ME. (R) (mandatory) (2 bytes)
//
//		Ipv4 Multicast Filtering
//			IPv4 multicast filtering:	(R, W) (mandatory) (1 byte)
//
//		Ipv6 Multicast Filtering
//			IPv6 multicast filtering:	(R, W) (mandatory) (1 byte)
//
//		Ipv4 Broadcast Filtering
//			IPv4 broadcast filtering:	(R, W) (mandatory) (1 byte)
//
//		Rarp Filtering
//			RARP filtering:	(R, W) (mandatory) (1 byte)
//
//		Ipx Filtering
//			IPX filtering:		(R, W) (mandatory) (1 byte)
//
//		Netbeui Filtering
//			NetBEUI filtering:	(R, W) (mandatory) (1 byte)
//
//		Appletalk Filtering
//			AppleTalk filtering:	(R, W) (mandatory) (1 byte)
//
//		Bridge Management Information Filtering
//			2	Addresses from 01.80.C2.00.00.20 to 01.80.C2.00.00.2F are used for generic attribute
//			registration protocol (GARP) applications.
//
//		Arp Filtering
//			ARP filtering:	(R, W) (mandatory) (1 byte)
//
//		Point_To_Point Protocol Over Ethernet Pppoe Broadcast Filtering
//			Point-to-point protocol over Ethernet (PPPoE) broadcast filtering:	(R, W) (mandatory) (1 byte)
//
type MacBridgePortFilterPreAssignTable struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	macbridgeportfilterpreassigntableBME = &ManagedEntityDefinition{
		Name:    "MacBridgePortFilterPreAssignTable",
		ClassID: 79,
		MessageTypes: mapset.NewSetWith(
			Get,
			Set,
		),
		AllowedAttributeMask: 0XFFC0,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", 0, mapset.NewSetWith(Read), false, false, false, false, 0),
			1:  ByteField("Ipv4MulticastFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 1),
			2:  ByteField("Ipv6MulticastFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 2),
			3:  ByteField("Ipv4BroadcastFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 3),
			4:  ByteField("RarpFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 4),
			5:  ByteField("IpxFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 5),
			6:  ByteField("NetbeuiFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 6),
			7:  ByteField("AppletalkFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 7),
			8:  ByteField("BridgeManagementInformationFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 8),
			9:  ByteField("ArpFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 9),
			10: ByteField("PointToPointProtocolOverEthernetPppoeBroadcastFiltering", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 10),
		},
	}
}

// NewMacBridgePortFilterPreAssignTable (class ID 79 creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from the wire, about to be sent on the wire.
func NewMacBridgePortFilterPreAssignTable(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(macbridgeportfilterpreassigntableBME, params...)
}
