/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */
package generated

import "github.com/deckarep/golang-set"

const XgPonTcPerformanceMonitoringHistoryDataClassId ClassID = ClassID(344)

var xgpontcperformancemonitoringhistorydataBME *ManagedEntityDefinition

// XgPonTcPerformanceMonitoringHistoryData (class ID #344)
//	This ME collects PM data associated with the XG-PON TC layer.
//
//	For a complete discussion of generic PM architecture, refer to clause I.4.
//
//	Relationships
//		An instance of this ME is associated with an ANI-G.
//
//	Attributes
//		Managed Entity Id
//			Managed entity ID: This attribute uniquely identifies each instance of this ME. Through an
//			identical ID, this ME is implicitly linked to an instance of the ANI-G. (R, set-by-create)
//			(mandatory) (2 bytes)
//
//		Interval End Time
//			Interval end time: This attribute identifies the most recently finished 15 min interval. (R)
//			(mandatory) (1 byte)
//
//		Threshold Data 1_2 Id
//			Threshold data 1/2 ID: This attribute points to an instance of the threshold data 1 ME that
//			contains PM threshold values. (R, W, set-by-create) (mandatory) (2 bytes)
//
//		Psbd Hec Error Count
//			PSBd HEC error count: This attribute counts HEC errors in any of the fields of the downstream
//			physical sync block. (R) (optional) (4 bytes)
//
//		Xgtc Hec Error Count
//			XGTC HEC error count: This attribute counts HEC errors detected in the XGTC header. In [ITU-T
//			G.9807.1], this attribute is used for framing sublayer (FS) HEC error count management. (R)
//			(optional) (4 bytes)
//
//		Unknown Profile Count
//			Unknown profile count: This attribute counts the number of grants received whose specified
//			profile was not known to the ONU. (R) (optional) (4 bytes)
//
//		Transmitted Xg_Pon Encapsulation Method Xgem Frames
//			Transmitted XG-PON encapsulation method (XGEM) frames: This attribute counts the number of non-
//			idle XGEM frames transmitted. If a service data unit (SDU) is fragmented, each fragment is an
//			XGEM frame and is counted as such. (R) (mandatory) (4 bytes)
//
//		Fragment Xgem Frames
//			Fragment XGEM frames: This attribute counts the number of XGEM frames that represent fragmented
//			SDUs, as indicated by the LF bit = 0. (R) (optional) (4 bytes)
//
//		Xgem Hec Lost Words Count
//			XGEM HEC lost words count: This attribute counts the number of 4 byte words lost because of an
//			XGEM frame HEC error. In general, all XGTC payload following the error is lost, until the next
//			PSBd event. (R) (optional) (4 bytes)
//
//		Xgem Key Errors
//			(R) (mandatory) (4 bytes)
//
//		Xgem Hec Error Count
//			XGEM HEC error count: This attribute counts the number of instances of an XGEM frame HEC error.
//			(R) (mandatory) (4 bytes)
//
//		Transmitted Bytes In Non_Idle Xgem Frames
//			Transmitted bytes in non-idle XGEM frames: This attribute counts the number of transmitted bytes
//			in non-idle XGEM frames. (R) (mandatory) (8 bytes)
//
//		Received Bytes In Non_Idle Xgem Frames
//			Received bytes in non-idle XGEM frames: This attribute counts the number of received bytes in
//			non-idle XGEM frames. (R) (optional) (8 bytes)
//
//		Loss Of Downstream Synchronization Lods Event Count
//			Loss of downstream synchronization (LODS) event count: This attribute counts the number of state
//			transitions from O5.1 to O6. (R) (optional) (4 bytes)
//
//		Lods Event Restored Count
//			LODS event restored count: This attribute counts the number of LODS cleared events. (R)
//			(optional) (4 bytes)
//
//		Onu Reactivation By Lods Events
//			ONU reactivation by LODS events: This attribute counts the number of LODS events resulting in
//			ONU reactivation without synchronization being reacquired. (R) (optional) (4 bytes)
//
type XgPonTcPerformanceMonitoringHistoryData struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	xgpontcperformancemonitoringhistorydataBME = &ManagedEntityDefinition{
		Name:    "XgPonTcPerformanceMonitoringHistoryData",
		ClassID: 344,
		MessageTypes: mapset.NewSetWith(
			Create,
			Delete,
			Get,
			Set,
		),
		AllowedAttributeMask: 0XFFFE,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", 0, mapset.NewSetWith(Read, SetByCreate), false, false, false, false, 0),
			1:  ByteField("IntervalEndTime", 0, mapset.NewSetWith(Read), false, false, false, false, 1),
			2:  Uint16Field("ThresholdData12Id", 0, mapset.NewSetWith(Read, SetByCreate, Write), false, false, false, false, 2),
			3:  Uint32Field("PsbdHecErrorCount", 0, mapset.NewSetWith(Read), false, false, true, false, 3),
			4:  Uint32Field("XgtcHecErrorCount", 0, mapset.NewSetWith(Read), false, false, true, false, 4),
			5:  Uint32Field("UnknownProfileCount", 0, mapset.NewSetWith(Read), false, false, true, false, 5),
			6:  Uint32Field("TransmittedXgPonEncapsulationMethodXgemFrames", 0, mapset.NewSetWith(Read), false, false, false, false, 6),
			7:  Uint32Field("FragmentXgemFrames", 0, mapset.NewSetWith(Read), false, false, true, false, 7),
			8:  Uint32Field("XgemHecLostWordsCount", 0, mapset.NewSetWith(Read), false, false, true, false, 8),
			9:  Uint32Field("XgemKeyErrors", 0, mapset.NewSetWith(Read), false, false, false, false, 9),
			10: Uint32Field("XgemHecErrorCount", 0, mapset.NewSetWith(Read), false, false, false, false, 10),
			11: Uint64Field("TransmittedBytesInNonIdleXgemFrames", 0, mapset.NewSetWith(Read), false, false, false, false, 11),
			12: Uint64Field("ReceivedBytesInNonIdleXgemFrames", 0, mapset.NewSetWith(Read), false, false, true, false, 12),
			13: Uint32Field("LossOfDownstreamSynchronizationLodsEventCount", 0, mapset.NewSetWith(Read), false, false, true, false, 13),
			14: Uint32Field("LodsEventRestoredCount", 0, mapset.NewSetWith(Read), false, false, true, false, 14),
			15: Uint32Field("OnuReactivationByLodsEvents", 0, mapset.NewSetWith(Read), false, false, true, false, 15),
		},
	}
}

// NewXgPonTcPerformanceMonitoringHistoryData (class ID 344 creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from the wire, about to be sent on the wire.
func NewXgPonTcPerformanceMonitoringHistoryData(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(xgpontcperformancemonitoringhistorydataBME, params...)
}
