/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */
package generated

import "github.com/deckarep/golang-set"

const PhysicalPathTerminationPointEthernetUniClassId ClassID = ClassID(11)

var physicalpathterminationpointethernetuniBME *ManagedEntityDefinition

// PhysicalPathTerminationPointEthernetUni (class ID #11)
//	This ME represents the point at an Ethernet UNI where the physical path terminates and Ethernet
//	physical level functions are performed.
//
//	The ONU automatically creates an instance of this ME per port:
//
//	•	when the ONU has Ethernet ports built into its factory configuration;
//
//	•	when a cardholder is provisioned to expect a circuit pack of the Ethernet type;
//
//	•	when a cardholder provisioned for plug-and-play is equipped with a circuit pack of the
//	Ethernet type. Note that the installation of a plug-and-play card may indicate the presence of
//	Ethernet ports via equipment ID as well as its type, and indeed may cause the ONU to instantiate
//	a port-mapping package that specifies Ethernet ports.
//
//	The ONU automatically deletes instances of this ME when a cardholder is neither provisioned to
//	expect an Ethernet circuit pack, nor is it equipped with an Ethernet circuit pack.
//
//	Relationships
//		An instance of this ME is associated with each instance of a pre-provisioned or real Ethernet
//		port.
//
//	Attributes
//		Managed Entity Id
//			Managed entity ID: This attribute uniquely identifies each instance of this ME. This 2 byte
//			number indicates the physical position of the UNI. The first byte is the slot ID (defined in
//			clause 9.1.5). The second byte is the port ID, with the range 1..255. (R) (mandatory) (2 bytes)
//
//		Expected Type
//			Upon ME instantiation, the ONU sets this attribute to 0. (R, W) (mandatory) (1 byte)
//
//		Sensed Type
//			(R) (mandatory if the ONU supports circuit packs with configurable interface types, e.g., 10/100
//			BASE-T card) (1 byte)
//
//		Auto Detection Configuration
//			Upon ME instantiation, the ONU sets this attribute to 0. (R, W) (mandatory for interfaces with
//			autodetection options) (1 byte)
//
//		Ethernet Loopback Configuration
//			Upon ME instantiation, the ONU sets this attribute to 0. (R, W) (mandatory) (1 byte)
//
//		Administrative State
//			Administrative state: This attribute locks (1) and unlocks (0) the functions performed by this
//			ME. Administrative state is further described in clause A.1.6. (R, W) (mandatory) (1 byte)
//
//		Operational State
//			Operational state: This attribute indicates whether the ME is capable of performing its
//			function. Valid values are enabled (0) and disabled (1). (R) (optional) (1 byte)
//
//		Configuration Ind
//			The value 0 indicates that the configuration status is unknown (e.g., Ethernet link is not
//			established or the circuit pack is not yet installed). Upon ME instantiation, the ONU sets this
//			attribute to 0. (R) (mandatory) (1 byte)
//
//		Max Frame Size
//			Max frame size: This attribute denotes the maximum frame size allowed across this interface.
//			Upon ME instantiation, the ONU sets the attribute to 1518. (R, W) (mandatory for G-PON, optional
//			for ITU-T G.986 systems) (2 bytes)
//
//		Dte Or Dce Ind
//			(R, W) (mandatory) (1 byte)
//
//		Pause Time
//			Pause time:	This attribute allows the PPTP to ask the subscriber terminal to temporarily suspend
//			sending data. Units are in pause quanta (1 pause quantum is 512 bit times of the particular
//			implementation). Values: 0..0xFFFF. Upon ME instantiation, the ONU sets this attribute to 0.
//			(R, W) (optional) (2 bytes)
//
//		Bridged Or Ip Ind
//			Upon ME instantiation, the ONU sets this attribute to 2. (R, W) (optional) (1 byte)
//
//		Arc
//			ARC:	See clause A.1.4.3. (R, W) (optional) (1 byte)
//
//		Arc Interval
//			ARC interval: See clause A.1.4.3. (R, W) (optional) (1 byte)
//
//		Pppoe Filter
//			PPPoE filter: This attribute controls filtering of PPPoE packets on this Ethernet port. The
//			value 0 allows packets of all types. The value 1 discards everything but PPPoE packets. The
//			default value is 0. (R, W) (optional) (1 byte)
//
//		Power Control
//			NOTE – This attribute is the equivalent of the acPSEAdminControl variable defined in clause
//			30.9.1.2.1 of [IEEE 802.3]. Other variables related to PoE appear in the PoE control ME.
//
type PhysicalPathTerminationPointEthernetUni struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	physicalpathterminationpointethernetuniBME = &ManagedEntityDefinition{
		Name:    "PhysicalPathTerminationPointEthernetUni",
		ClassID: 11,
		MessageTypes: mapset.NewSetWith(
			Get,
			Set,
		),
		AllowedAttributeMask: 0XFFFE,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", 0, mapset.NewSetWith(Read), false, false, false, false, 0),
			1:  ByteField("ExpectedType", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 1),
			2:  ByteField("SensedType", 0, mapset.NewSetWith(Read), true, false, false, false, 2),
			3:  ByteField("AutoDetectionConfiguration", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 3),
			4:  ByteField("EthernetLoopbackConfiguration", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 4),
			5:  ByteField("AdministrativeState", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 5),
			6:  ByteField("OperationalState", 0, mapset.NewSetWith(Read), true, false, true, false, 6),
			7:  ByteField("ConfigurationInd", 0, mapset.NewSetWith(Read), false, false, false, false, 7),
			8:  Uint16Field("MaxFrameSize", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 8),
			9:  ByteField("DteOrDceInd", 0, mapset.NewSetWith(Read, Write), false, false, false, false, 9),
			10: Uint16Field("PauseTime", 0, mapset.NewSetWith(Read, Write), false, false, true, false, 10),
			11: ByteField("BridgedOrIpInd", 0, mapset.NewSetWith(Read, Write), false, false, true, false, 11),
			12: ByteField("Arc", 0, mapset.NewSetWith(Read, Write), true, false, true, false, 12),
			13: ByteField("ArcInterval", 0, mapset.NewSetWith(Read, Write), false, false, true, false, 13),
			14: ByteField("PppoeFilter", 0, mapset.NewSetWith(Read, Write), false, false, true, false, 14),
			15: ByteField("PowerControl", 0, mapset.NewSetWith(Read, Write), false, false, true, false, 15),
		},
	}
}

// NewPhysicalPathTerminationPointEthernetUni (class ID 11 creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from the wire, about to be sent on the wire.
func NewPhysicalPathTerminationPointEthernetUni(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(physicalpathterminationpointethernetuniBME, params...)
}
