/*
 * Copyright (c) 2018 - present.  Boling Consulting Solutions (bcsw.net)
 * Copyright 2020-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * NOTE: This file was generated, manual edits will be overwritten!
 *
 * Generated by 'goCodeGenerator.py':
 *              https://github.com/cboling/OMCI-parser/README.md
 */

package generated

import "github.com/deckarep/golang-set"

// Vdsl2LineInventoryAndStatusDataPart4ClassID is the 16-bit ID for the OMCI
// Managed entity VDSL2 line inventory and status data part 4
const Vdsl2LineInventoryAndStatusDataPart4ClassID = ClassID(415) // 0x019f

var vdsl2lineinventoryandstatusdatapart4BME *ManagedEntityDefinition

// Vdsl2LineInventoryAndStatusDataPart4 (Class ID: #415 / 0x019f)
//	This ME extends the other xDSL line inventory and status data MEs with attributes specific to
//	VDSL2.
//
//	Relationships
//		This is one of the status data MEs associated with an xDSL UNI. It is required only if VDSL2 is
//		supported by the PPTP. The ONU automatically creates or deletes an instance of this ME upon
//		creation or deletion of a PPTP xDSL UNI part 1 that supports these attributes.
//
//	Attributes
//		Managed Entity Id
//			This attribute uniquely identifies each instance of this ME. Through an identical ID, this ME is
//			implicitly linked to an instance of the PPTP xDSL UNI part 1 ME. (R) (mandatory) (2-bytes)
//
//		Vtu_O Estimated Upstream Power Back_Off Electrical Length Per Band Upbokle_Pb
//			VTU-O estimated upstream power back-off electrical length per band (UPBOKLE-pb): This parameter
//			is a vector of UPBO electrical length per-band estimates for each supported upstream band except
//			US0, calculated by the VTU-O, based on separate measurements in the supported upstream bands
//			excluding US0. This parameter is required for the alternative electrical length estimation
//			method (ELE-M1). Each per-band estimate is represented by 2-bytes, where the estimate is defined
//			as the integer value multiplied by 0.1-dB. The valid range of values is given in clause
//			7.5.1.23.3 of [ITU-T G.997.1] (R) (optional) (4 bands- 2-bytes)
//
//		Vtu_R Estimated Upstream Power Back_Off Electrical Length Per Band Upbokle_R_Pb
//			VTU-R estimated upstream power back-off electrical length per band (UPBOKLE-R-pb): This
//			parameter is a vector of UPBO electrical length per-band estimates for each supported downstream
//			band, calculated by the VTU-R, based on separate measurements in the supported downstream bands.
//			This parameter is required for the alternative electrical length estimation method (ELEM1). Each
//			per-band estimate is represented by 2-bytes, where the estimate is defined as the integer value
//			multiplied by 0.1-dB. The valid range of values is given in clause 7.5.1.23.4 of [ITU-T G.997.1]
//			(R) (optional) (3-bands- 2-bytes)
//
//		Upbo Downstream Receiver Signal Level Threshold Rxthrshds
//			UPBO downstream receiver signal level threshold (RXTHRSHds): This parameter reports the
//			downstream received signal level threshold value used in the alternative electrical length
//			estimation method (ELE-M1). Valid values range from 0  (-64-dB) to 64 (0 dB). See clause
//			7.5.1.23.5 of [ITU-T G.997.1] (R) (optional) (1-byte)
//
//		Upbo Upstream Receiver Signal Level Threshold Rxthrshus
//			UPBO upstream receiver signal level threshold (RXTHRSHus): This parameter reports the upstream
//			received signal level threshold value used in the alternative electrical length estimation
//			method. Valid values range from 0 (-64 dB) to 64-(0 dB). See clause 7.5.1.23.6 of [ITU-T
//			G.997.1] (R) (optional) (1-byte)
//
//		Actual Alternative Electrical Length Estimation Mod E Act_Aele_Mode
//			Actual alternative electrical length estimation mode (ACT-AELE-MODE): This parameter reports the
//			actual AELE-MODE. Valid values are given in clause-7.5.1.23.7 of [ITU-T G.997.1] (R) (optional)
//			(1-byte)
//
//		Actual Downstream Ripolicy Actripolicyds
//			Actual downstream RIPOLICY (ACTRIPOLICYds): This parameter indicates the actual re-
//			initialization policy in use in the downstream direction. Valid values are given in clause
//			7.5.1.40.1 of [ITU-T G.997.1] (R) (optional) (1-byte)
//
//		Actual Upstream Ripolicy Actripolicyus
//			Actual upstream RIPOLICY (ACTRIPOLICYus): This parameter indicates the actual reinitialization
//			policy in use in the upstream direction. Valid values are given in clause 7.5.1.40.2 of [ITU-T
//			G.997.1] (R) (optional) (1-byte)
//
//		Attndr Actual M Ethod Attndr_Actmethod
//			ATTNDR actual method (ATTNDR_ACTMETHOD): This parameter indicates the actual ATTNDR Method used
//			for calculation of the ATTNDR in the downstream and upstream direction. Valid values are given
//			in clause 7.5.1.41.1 of [ITUT-G.997.1] (R) (optional) (1-byte)
//
//		Attndr Downstream A Ctual Impulse Noise Protection Attndr_Actinpds
//			ATTNDR downstream actual impulse noise protection (ATTNDR_ACTINPds): If retransmission is not
//			used in the downstream direction, this parameter indicates the actual INP used in the improved
//			calculation of the ATTNDR in the downstream direction. If retransmission is used in the
//			downstream direction, this parameter indicates the actual INP against SHINE used in the improved
//			calculation of the ATTNDR in the downstream direction. The format and usage is identical to that
//			of the ACTINP attribute defined in the xDSL channel downstream status data ME. See clause
//			7.5.1.41.2 of [ITU-T G.997.1] (R) (optional) (1-byte)
//
//		Attndr Upstream A Ctual Impulse Noise Protection Attndr_Actinpus
//			ATTNDR upstream actual impulse noise protection (ATTNDR_ACTINPus): If retransmission is not used
//			in the upstream direction, this parameter indicates the actual INP used in the improved
//			calculation of the ATTNDR in the upstream direction. If retransmission is used in the upstream
//			direction, this parameter indicates the actual INP against SHINE used in the improved
//			calculation of the ATTNDR in the upstream direction. The format and usage is identical to that
//			of the ACTINP attribute defined in the xDSL channel downstream status data ME. See clause
//			7.5.1.41.3 of [ITU-T G.997.1] (R) (optional) (1-byte)
//
//		Attndr Downstream A Ctual Impulse Noise Protection Against Rein Attndr_Actinp_Reinds
//			ATTNDR downstream actual impulse noise protection against REIN (ATTNDR_ACTINP_REINds): If
//			retransmission is used in the downstream direction, this parameter reports the actual INP
//			against REIN used in the improved calculation of the ATTNDR in the downstream direction. The
//			format and usage is identical to that of the ACTINP_REIN attribute defined in the xDSL channel
//			downstream status data ME. See clause 7.5.1.41.4 of [ITU-T G.997.1] (R) (optional) (1-byte)
//
//		Attndr Upstream A Ctual Impulse Noise Protection Against Rein Attndr_Actinp_Reinus
//			ATTNDR upstream actual impulse noise protection against REIN (ATTNDR_ACTINP_REINus): If
//			retransmission is used in the upstream direction, this parameter reports the actual INP against
//			REIN used in the improved calculation of the ATTNDR in the upstream direction. The format and
//			usage is identical to that of the ACTINP_REIN attribute defined in the xDSL channel downstream
//			status data ME. See clause 7.5.1.41.5 of [ITUT-G.997.1] (R) (optional) (1-byte)
//
//		Attndr Downstream Actual Delay Attndr_Actdelayds
//			ATTNDR downstream actual delay (ATTNDR_ACTDELAYds): This parameter indicates the actual delay
//			used in the improved calculation of the ATTNDR in the downstream direction. The delay of this
//			attribute is equal to the integer value multiplied by 0.1-ms. Valid values are given in clause
//			7.5.1.41.6 of [ITUT G.997.1] (R) (optional) (1-byte)
//
//		Attndr Upstream A Ctual Delay Attndr_Actdelayus
//			ATTNDR upstream actual delay (ATTNDR_ACTDELAYus): This parameter indicates the actual delay used
//			in the improved calculation of the ATTNDR in the upstream direction. The delay of this attribute
//			is equal to the integer value multiplied by 0.1-ms. Valid values are given in clause 7.5.1.41.7
//			of [ITUT-G.997.1] (R) (optional) (1-byte)
//
//		Near_End A Ggregate Achievable Net Data Rate Aggachndr_Ne
//			Near-end aggregate achievable net data rate (AGGACHNDR_NE): This parameter reports the aggregate
//			achievable net data rate of the VTU-O, in bits per second. See clause 7.5.1.42.1 of [ITU-T
//			G.997.1] (R) (optional) (4-bytes)
//
//		Far_End Aggregate Achievable Net Data Rate Aggachndr_Fe
//			Far-end aggregate achievable net data rate (AGGACHNDR_FE): This parameter reports the aggregate
//			achievable net data rate of the VTU-R, in bits per second. See clause-7.5.1.42.2 of [ITU-T
//			G.997.1] (R) (optional) (4-bytes)
//
type Vdsl2LineInventoryAndStatusDataPart4 struct {
	ManagedEntityDefinition
	Attributes AttributeValueMap
}

func init() {
	vdsl2lineinventoryandstatusdatapart4BME = &ManagedEntityDefinition{
		Name:    "Vdsl2LineInventoryAndStatusDataPart4",
		ClassID: 415,
		MessageTypes: mapset.NewSetWith(
			Get,
		),
		AllowedAttributeMask: 0xffff,
		AttributeDefinitions: AttributeDefinitionMap{
			0:  Uint16Field("ManagedEntityId", PointerAttributeType, 0x0000, 0, mapset.NewSetWith(Read), false, false, false, 0),
			1:  Uint32Field("VtuOEstimatedUpstreamPowerBackOffElectricalLengthPerBandUpboklePb", UnsignedIntegerAttributeType, 0x8000, 0, mapset.NewSetWith(Read), false, true, false, 1),
			2:  MultiByteField("VtuREstimatedUpstreamPowerBackOffElectricalLengthPerBandUpbokleRPb", OctetsAttributeType, 0x4000, 3, toOctets("AAAA"), mapset.NewSetWith(Read), false, true, false, 2),
			3:  ByteField("UpboDownstreamReceiverSignalLevelThresholdRxthrshds", UnsignedIntegerAttributeType, 0x2000, 0, mapset.NewSetWith(Read), false, true, false, 3),
			4:  ByteField("UpboUpstreamReceiverSignalLevelThresholdRxthrshus", UnsignedIntegerAttributeType, 0x1000, 0, mapset.NewSetWith(Read), false, true, false, 4),
			5:  ByteField("ActualAlternativeElectricalLengthEstimationModEActAeleMode", UnsignedIntegerAttributeType, 0x0800, 0, mapset.NewSetWith(Read), false, true, false, 5),
			6:  ByteField("ActualDownstreamRipolicyActripolicyds", UnsignedIntegerAttributeType, 0x0400, 0, mapset.NewSetWith(Read), false, true, false, 6),
			7:  ByteField("ActualUpstreamRipolicyActripolicyus", UnsignedIntegerAttributeType, 0x0200, 0, mapset.NewSetWith(Read), false, true, false, 7),
			8:  ByteField("AttndrActualMEthodAttndrActmethod", UnsignedIntegerAttributeType, 0x0100, 0, mapset.NewSetWith(Read), false, true, false, 8),
			9:  ByteField("AttndrDownstreamACtualImpulseNoiseProtectionAttndrActinpds", UnsignedIntegerAttributeType, 0x0080, 0, mapset.NewSetWith(Read), false, true, false, 9),
			10: ByteField("AttndrUpstreamACtualImpulseNoiseProtectionAttndrActinpus", UnsignedIntegerAttributeType, 0x0040, 0, mapset.NewSetWith(Read), false, true, false, 10),
			11: ByteField("AttndrDownstreamACtualImpulseNoiseProtectionAgainstReinAttndrActinpReinds", UnsignedIntegerAttributeType, 0x0020, 0, mapset.NewSetWith(Read), false, true, false, 11),
			12: ByteField("AttndrUpstreamACtualImpulseNoiseProtectionAgainstReinAttndrActinpReinus", UnsignedIntegerAttributeType, 0x0010, 0, mapset.NewSetWith(Read), false, true, false, 12),
			13: ByteField("AttndrDownstreamActualDelayAttndrActdelayds", UnsignedIntegerAttributeType, 0x0008, 0, mapset.NewSetWith(Read), false, true, false, 13),
			14: ByteField("AttndrUpstreamACtualDelayAttndrActdelayus", UnsignedIntegerAttributeType, 0x0004, 0, mapset.NewSetWith(Read), false, true, false, 14),
			15: Uint32Field("NearEndAGgregateAchievableNetDataRateAggachndrNe", UnsignedIntegerAttributeType, 0x0002, 0, mapset.NewSetWith(Read), false, true, false, 15),
			16: Uint32Field("FarEndAggregateAchievableNetDataRateAggachndrFe", UnsignedIntegerAttributeType, 0x0001, 0, mapset.NewSetWith(Read), false, true, false, 16),
		},
		Access:  CreatedByOnu,
		Support: UnknownSupport,
	}
}

// NewVdsl2LineInventoryAndStatusDataPart4 (class ID 415) creates the basic
// Managed Entity definition that is used to validate an ME of this type that
// is received from or transmitted to the OMCC.
func NewVdsl2LineInventoryAndStatusDataPart4(params ...ParamData) (*ManagedEntity, OmciErrors) {
	return NewManagedEntity(*vdsl2lineinventoryandstatusdatapart4BME, params...)
}
