/*
   Copyright 2017 the original author or authors.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package physical

/*
Edgecore Implements the Edgecore linecard as an OLT
*/
type Edgecore struct {
	SimpleOLT
}

/*
CreateEdgecore takes simple olt struct and generates Edgecore OLT
*/
func CreateEdgecore(olt *SimpleOLT) *Edgecore {
	var newPorts [16]PONPort
	edge := Edgecore{SimpleOLT: *olt}
	for i := 0; i < 16; i++ {
		newPorts[i].Parent = &edge
	}
	edge.Ports = newPorts[:]
	return &edge
}
