from rest_framework.response import Response
from rest_framework import serializers
from api.xosapi_helpers import PlusModelSerializer, XOSViewSet, ReadOnlyField
from services.passivetest.models import PassiveTestService

class PassiveTestSerializer(PlusModelSerializer):
    id = ReadOnlyField()
    humanReadableName = serializers.SerializerMethodField("getHumanReadableName")
    tap_ports = serializers.CharField(required=False)
    reset_viv = serializers.BooleanField(required=False)

    class Meta:
        model = PassiveTestService
        fields = ('humanReadableName',
                  'id',
                  'tap_ports',
                  'reset_viv')

    def getHumanReadableName(self, obj):
        return obj.__unicode__()

class PassiveTestViewSet(XOSViewSet):
    base_name = "passivetest"
    method_name = "passivetest"
    method_kind = "viewset"
    queryset = PassiveTestService.get_service_objects().all()
    serializer_class = PassiveTestSerializer

    @classmethod
    def get_urlpatterns(self, api_path="^"):
        patterns = super(PassiveTestViewSet, self).get_urlpatterns(api_path=api_path)
        return patterns

    def list(self, request):
        object_list = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(object_list, many=True)
        return Response(serializer.data)

