from core.models import Tenant, Service
from services.activetest.models import Qt600Tenant

from xosresource import XOSResource

class XOSQt600Tenant(XOSResource):
    name_field = "service_specific_id"
    provides = "tosca.nodes.Qt600Tenant"
    copyin_props = ("is_reflector","is_initiator","reflector",)
    xos_model = Qt600Tenant

    def get_xos_args(self, throw_exception=True):
        args = super(XOSQt600Tenant, self).get_xos_args()

        # Qt600Tenant must always have a provider_service
        provider_name = self.get_requirement("tosca.relationships.TenantOfService", throw_exception=True)
        if provider_name:
            args["provider_service"] = self.get_xos_object(Service, throw_exception=True, name=provider_name)

        return args

    def can_delete(self, obj):
        return super(XOSQt600Tenant, self).can_delete(obj)

    def get_existing_objs(self):
        args = self.get_xos_args(throw_exception=False)
        return Qt600Tenant.get_tenant_objects().filter(provider_service=args["provider_service"], service_specific_id=args["service_specific_id"])
        return []
