from rest_framework.decorators import api_view
from rest_framework.response import Response
from rest_framework.reverse import reverse
from rest_framework import serializers
from rest_framework import generics
from rest_framework import status
from core.models import *
from django.forms import widgets
from xos.apibase import XOSListCreateAPIView, XOSRetrieveUpdateDestroyAPIView, XOSPermissionDenied
from api.xosapi_helpers import PlusModelSerializer, XOSViewSet, ReadOnlyField

from services.activetest.models import ActiveTestTenant, ActiveTestService, VpmaService, VpmaTenant, Qt600Service, Qt600Tenant

def get_default_activetest_service():
    activetest_services = ActiveTestService.get_service_objects().all()
    if activetest_services:
        return activetest_services[0]
    return None

class ActiveTestTenantSerializer(PlusModelSerializer):
        id = ReadOnlyField()
        provider_service = serializers.PrimaryKeyRelatedField(queryset=ActiveTestService.get_service_objects().all(), default=get_default_activetest_service)
        backend_status = ReadOnlyField()

        humanReadableName = serializers.SerializerMethodField("getHumanReadableName")

        class Meta:
            model = ActiveTestTenant
            fields = ('humanReadableName', 'id', 'provider_service', 'backend_status')

        def getHumanReadableName(self, obj):
            return obj.__unicode__()

class ActiveTestTenantViewSet(XOSViewSet):
    base_name = "activetesttenant"
    method_name = "activetesttenant"
    method_kind = "viewset"
    queryset = ActiveTestTenant.get_tenant_objects().all()
    serializer_class = ActiveTestTenantSerializer


    def list(self, request):
        queryset = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)

#####################################################################################################################

def get_default_vpma_service():
    vpma_services = VpmaService.get_service_objects().all()
    if vpma_services:
        return vpma_services[0]
    return None

class VpmaTenantSerializer(PlusModelSerializer):
        id = ReadOnlyField()
        provider_service = serializers.PrimaryKeyRelatedField(queryset=VpmaService.get_service_objects().all(), default=get_default_vpma_service)
        backend_status = ReadOnlyField()
        is_reflector = serializers.BooleanField(required=False)
        is_initiator = serializers.BooleanField(required=False)
        reflector = serializers.CharField(required=False)

        humanReadableName = serializers.SerializerMethodField("getHumanReadableName")

        class Meta:
            model = VpmaTenant
            fields = ('humanReadableName', 'id', 'provider_service', 'is_reflector', 'is_initiator', 'reflector', 'backend_status')

        def getHumanReadableName(self, obj):
            return obj.__unicode__()

class VpmaTenantViewSet(XOSViewSet):
    base_name = "vpmatenant"
    method_name = "vpmatenant"
    method_kind = "viewset"
    queryset = VpmaTenant.get_tenant_objects().all()
    serializer_class = VpmaTenantSerializer

    @classmethod
    def get_urlpatterns(self, api_path="^"):
        patterns = super(VpmaTenantViewSet, self).get_urlpatterns(api_path=api_path)

        # example to demonstrate adding a custom endpoint
        patterns.append( self.detail_url("is_initiator/$", {"get": "get_is_initiator", "put": "set_is_initiator"}, "is_initiator") )
        patterns.append( self.detail_url("is_reflector/$", {"get": "get_is_reflector", "put": "set_is_reflector"}, "is_reflector") )
        patterns.append( self.detail_url("reflector/$", {"get": "get_reflector", "put": "set_reflector"}, "reflector") )

        return patterns

    def list(self, request):
        queryset = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)

    def get_is_initiator(self, request, pk=None):
        vpma_tenant = self.get_object()
        return Response({"is_initiator": vpma_tenant.is_initiator})

    def set_is_initiator(self, request, pk=None):
        vpma_tenant = self.get_object()
        vpma_tenant.is_initiator = request.data["is_initiator"]
        vpma_tenant.save()
        return Response({"is_initiator": vpma_tenant.is_initiator})

    def get_is_reflector(self, request, pk=None):
        vpma_tenant = self.get_object()
        return Response({"is_reflector": vpma_tenant.is_reflector})

    def set_is_reflector(self, request, pk=None):
        vpma_tenant = self.get_object()
        vpma_tenant.is_reflector = request.data["is_reflector"]
        vpma_tenant.save()
        return Response({"is_reflector": vpma_tenant.is_reflector})

    def get_reflector(self, request, pk=None):
        vpma_tenant = self.get_object()
        return Response({"reflector": vpma_tenant.reflector})

    def set_reflector(self, request, pk=None):
        vpma_tenant = self.get_object()
        vpma_tenant.reflector = request.data["reflector"]
        vpma_tenant.save()
        return Response({"reflector": vpma_tenant.reflector})

#####################################################################################################################

def get_default_qt600_service():
    qt600_services = Qt600Service.get_service_objects().all()
    if qt600_services:
        return qt600_services[0]
    return None

class Qt600TenantSerializer(PlusModelSerializer):
        id = ReadOnlyField()
        provider_service = serializers.PrimaryKeyRelatedField(queryset=Qt600Service.get_service_objects().all(), default=get_default_qt600_service)
        backend_status = ReadOnlyField()
        is_reflector = serializers.BooleanField(required=False)
        is_initiator = serializers.BooleanField(required=False)
        reflector = serializers.CharField(required=False)

        humanReadableName = serializers.SerializerMethodField("getHumanReadableName")

        class Meta:
            model = Qt600Tenant
            fields = ('humanReadableName', 'id', 'provider_service', 'is_reflector', 'is_initiator', 'reflector', 'backend_status')

        def getHumanReadableName(self, obj):
            return obj.__unicode__()

class Qt600TenantViewSet(XOSViewSet):
    base_name = "qt600tenant"
    method_name = "qt600tenant"
    method_kind = "viewset"
    queryset = Qt600Tenant.get_tenant_objects().all()
    serializer_class = Qt600TenantSerializer

    @classmethod
    def get_urlpatterns(self, api_path="^"):
        patterns = super(Qt600TenantViewSet, self).get_urlpatterns(api_path=api_path)

        # example to demonstrate adding a custom endpoint
        patterns.append( self.detail_url("is_initiator/$", {"get": "get_is_initiator", "put": "set_is_initiator"}, "is_initiator") )
        patterns.append( self.detail_url("is_reflector/$", {"get": "get_is_reflector", "put": "set_is_reflector"}, "is_reflector") )
        patterns.append( self.detail_url("reflector/$", {"get": "get_reflector", "put": "set_reflector"}, "reflector") )

        return patterns

    def list(self, request):
        queryset = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)

    def get_is_initiator(self, request, pk=None):
        qt600_tenant = self.get_object()
        return Response({"is_initiator": qt600_tenant.is_initiator})

    def set_is_initiator(self, request, pk=None):
        qt600_tenant = self.get_object()
        qt600_tenant.is_initiator = request.data["is_initiator"]
        qt600_tenant.save()
        return Response({"is_initiator": qt600_tenant.is_initiator})

    def get_is_reflector(self, request, pk=None):
        qt600_tenant = self.get_object()
        return Response({"is_reflector": qt600_tenant.is_reflector})

    def set_is_reflector(self, request, pk=None):
        qt600_tenant = self.get_object()
        qt600_tenant.is_reflector = request.data["is_reflector"]
        qt600_tenant.save()
        return Response({"is_reflector": qt600_tenant.is_reflector})

    def get_reflector(self, request, pk=None):
        qt600_tenant = self.get_object()
        return Response({"reflector": qt600_tenant.reflector})

    def set_reflector(self, request, pk=None):
        qt600_tenant = self.get_object()
        qt600_tenant.reflector = request.data["reflector"]
        qt600_tenant.save()
        return Response({"reflector": qt600_tenant.reflector})
