import os
import sys
from django.db.models import Q, F
from services.activetest.models import VpmaTenant
from synchronizers.base.SyncInstanceUsingAnsible import SyncInstanceUsingAnsible

parentdir = os.path.join(os.path.dirname(__file__), "..")
sys.path.insert(0, parentdir)

class SyncVpmaTenant(SyncInstanceUsingAnsible):

    provides = [VpmaTenant]

    observes = VpmaTenant

    requested_interval = 0

    template_name = "vpmatenant_playbook.yaml"

    service_key_name = "/opt/xos/synchronizers/activetest/activetest_private_key"

    def __init__(self, *args, **kwargs):
        super(SyncVpmaTenant, self).__init__(*args, **kwargs)

    def fetch_pending(self, deleted):

        if (not deleted):
            objs = VpmaTenant.get_tenant_objects().filter(
                Q(enacted__lt=F('updated')) | Q(enacted=None), Q(lazy_blocked=False))
        else:
            # If this is a deletion we get all of the deleted tenants..
            objs = VpmaTenant.get_deleted_tenant_objects()

        return objs

    # Gets the attributes that are used by the Ansible template but are not
    # part of the set of default attributes.
    def get_extra_attributes(self, o):
        return { "private_ip":o.private_ip,
                 "public_ip":o.public_ip,
                 "controller_ip":o.controller_ip,
                 "reflector_ip":o.reflector_ip,
                 "reflector_public_ip":o.reflector_public_ip,
                 "is_reflector":o.is_reflector,
                 "is_initiator":o.is_initiator
             }


