import os
import sys
from django.db.models import Q, F
from services.activetest.models import ActiveTestService, ActiveTestTenant
from synchronizers.base.SyncInstanceUsingAnsible import SyncInstanceUsingAnsible

parentdir = os.path.join(os.path.dirname(__file__), "..")
sys.path.insert(0, parentdir)

class SyncActiveTestTenant(SyncInstanceUsingAnsible):

    provides = [ActiveTestTenant]

    observes = ActiveTestTenant

    requested_interval = 0

    template_name = "activetesttenant_playbook.yaml"

    service_key_name = "/opt/xos/synchronizers/activetest/activetest_private_key"

    def __init__(self, *args, **kwargs):
        super(SyncActiveTestTenant, self).__init__(*args, **kwargs)

    def fetch_pending(self, deleted):

        if (not deleted):
            objs = ActiveTestTenant.get_tenant_objects().filter(
                Q(enacted__lt=F('updated')) | Q(enacted=None), Q(lazy_blocked=False))
        else:
            # If this is a deletion we get all of the deleted tenants..
            objs = ActiveTestTenant.get_deleted_tenant_objects()

        return objs

    def get_activetestservice(self, o):
        if not o.provider_service:
            return None

        activetestservice = ActiveTestService.get_service_objects().filter(id=o.provider_service.id)

        if not activetestservice:
            return None

        return activetestservice[0]

    # Gets the attributes that are used by the Ansible template but are not
    # part of the set of default attributes.
    def get_extra_attributes(self, o):
        return { "public_ip": o.public_ip }


