from rest_framework.decorators import api_view
from rest_framework.response import Response
from rest_framework.reverse import reverse
from rest_framework import serializers
from rest_framework import generics
from rest_framework import viewsets
from rest_framework import status
from rest_framework.decorators import detail_route, list_route
from rest_framework.views import APIView
from core.models import *
from django.forms import widgets
from django.conf.urls import patterns, url
from api.xosapi_helpers import PlusModelSerializer, XOSViewSet, ReadOnlyField
from django.shortcuts import get_object_or_404
from xos.apibase import XOSListCreateAPIView, XOSRetrieveUpdateDestroyAPIView, XOSPermissionDenied
from xos.exceptions import *
import json
import subprocess
from services.activetest.models import ActiveTestService, VpmaService, Qt600Service

class ActiveTestSerializer(PlusModelSerializer):
        id = ReadOnlyField()
        humanReadableName = serializers.SerializerMethodField("getHumanReadableName")

        class Meta:
            model = ActiveTestService
            fields = ('humanReadableName',
                      'id')

        def getHumanReadableName(self, obj):
            return obj.__unicode__()

class ActiveTestViewSet(XOSViewSet):
    base_name = "activetest"
    method_name = "activetest"
    method_kind = "viewset"
    queryset = ActiveTestService.get_service_objects().all()
    serializer_class = ActiveTestSerializer

    @classmethod
    def get_urlpatterns(self, api_path="^"):
        patterns = super(ActiveTestViewSet, self).get_urlpatterns(api_path=api_path)
        return patterns

    def list(self, request):
        object_list = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(object_list, many=True)
        return Response(serializer.data)

############################################################################################

class VpmaSerializer(PlusModelSerializer):
        id = ReadOnlyField()
        humanReadableName = serializers.SerializerMethodField("getHumanReadableName")

        class Meta:
            model = VpmaService
            fields = ('humanReadableName',
                      'id')

        def getHumanReadableName(self, obj):
            return obj.__unicode__()

class VpmaViewSet(XOSViewSet):
    base_name = "vpma"
    method_name = "vpma"
    method_kind = "viewset"
    queryset = VpmaService.get_service_objects().all()
    serializer_class = VpmaSerializer

    @classmethod
    def get_urlpatterns(self, api_path="^"):
        patterns = super(VpmaViewSet, self).get_urlpatterns(api_path=api_path)
        return patterns

    def list(self, request):
        object_list = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(object_list, many=True)
        return Response(serializer.data)

class Qt600Serializer(PlusModelSerializer):
        id = ReadOnlyField()
        humanReadableName = serializers.SerializerMethodField("getHumanReadableName")

        class Meta:
            model = Qt600Service
            fields = ('humanReadableName',
                      'id')

        def getHumanReadableName(self, obj):
            return obj.__unicode__()

class Qt600ViewSet(XOSViewSet):
    base_name = "qt600"
    method_name = "qt600"
    method_kind = "viewset"
    queryset = Qt600Service.get_service_objects().all()
    serializer_class = Qt600Serializer

    @classmethod
    def get_urlpatterns(self, api_path="^"):
        patterns = super(Qt600ViewSet, self).get_urlpatterns(api_path=api_path)
        return patterns

    def list(self, request):
        object_list = self.filter_queryset(self.get_queryset())
        serializer = self.get_serializer(object_list, many=True)
        return Response(serializer.data)
